/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IFluidIngredient;
import net.minecraftforge.fluids.FluidStack;

public class FluidArrayIngredient
implements IFluidIngredient {
    public List<IFluidIngredient> ingredientList;
    public List<FluidStack> cachedStackList = new ArrayList<FluidStack>();

    public FluidArrayIngredient(IFluidIngredient ... ingredients) {
        this(Lists.newArrayList((Object[])ingredients));
    }

    public FluidArrayIngredient(List<IFluidIngredient> ingredientList) {
        this.ingredientList = ingredientList;
        ingredientList.forEach(input -> this.cachedStackList.add((FluidStack)input.getStack()));
    }

    @Override
    public FluidStack getStack() {
        if (this.cachedStackList == null || this.cachedStackList.isEmpty() || this.cachedStackList.get(0) == null) {
            return null;
        }
        return this.cachedStackList.get(0).copy();
    }

    @Override
    public String getIngredientName() {
        return this.getIngredientNamesConcat();
    }

    @Override
    public String getIngredientNamesConcat() {
        String names = "";
        for (IFluidIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getIngredientName();
        }
        return "{ " + names.substring(2) + " }";
    }

    public String getIngredientRecipeString() {
        String names = "";
        for (IFluidIngredient ingredient : this.ingredientList) {
            names = names + ", " + ingredient.getMaxStackSize(0) + " x " + ingredient.getIngredientName();
        }
        return "{ " + names.substring(2) + " }";
    }

    @Override
    public int getMaxStackSize(int ingredientNumber) {
        return this.ingredientList.get(ingredientNumber).getMaxStackSize(0);
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        for (IFluidIngredient ingredient : this.ingredientList) {
            ingredient.setMaxStackSize(stackSize);
        }
        for (FluidStack stack : this.cachedStackList) {
            stack.amount = stackSize;
        }
    }

    @Override
    public List<FluidStack> getInputStackList() {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        this.ingredientList.forEach(ingredient -> ingredient.getInputStackList().forEach(obj -> stacks.add((FluidStack)obj)));
        return stacks;
    }

    @Override
    public List<FluidStack> getOutputStackList() {
        if (this.cachedStackList == null || this.cachedStackList.isEmpty()) {
            return new ArrayList<FluidStack>();
        }
        return Lists.newArrayList((Object[])new FluidStack[]{this.getStack()});
    }

    @Override
    public IngredientMatchResult match(Object object, IngredientSorption sorption) {
        for (int i = 0; i < this.ingredientList.size(); ++i) {
            if (!this.ingredientList.get(i).match(object, sorption).matches()) continue;
            return new IngredientMatchResult(true, i);
        }
        return IngredientMatchResult.FAIL;
    }

    @Override
    public boolean isValid() {
        return this.cachedStackList != null && !this.cachedStackList.isEmpty();
    }
}

