/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import cubex2.cs4.api.Color;
import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.api.InitPhase;
import cubex2.cs4.api.Length;
import cubex2.cs4.data.SimpleContent;
import cubex2.cs4.plugins.vanilla.ColorImpl;
import cubex2.cs4.plugins.vanilla.GuiMapping;
import cubex2.cs4.util.GuiHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

class GuiModifier
extends SimpleContent {
    String gui;
    List<Label> labels = Collections.emptyList();
    List<Integer> removeButtons = Collections.emptyList();
    List<EditButton> editButtons = Collections.emptyList();

    GuiModifier() {
    }

    @Override
    protected void doInit(InitPhase phase, ContentHelper helper) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected boolean isReady() {
        return true;
    }

    @SubscribeEvent
    void onPostInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (this.isCorrectGui(event.getGui())) {
            event.getButtonList().removeIf(button -> this.removeButtons.contains(button.field_146127_k));
            this.editButtons.forEach(b -> b.postInit(event));
        }
    }

    @SubscribeEvent
    void onRenderGui(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (this.isCorrectGui(event.getGui())) {
            this.labels.forEach(m -> m.render(event));
        }
    }

    private boolean isCorrectGui(GuiScreen screen) {
        Class<? extends GuiScreen> guiClass = GuiMapping.getGuiClass(this.gui.toLowerCase());
        return guiClass != null && guiClass.isAssignableFrom(screen.getClass());
    }

    static class EditButton
    extends PositionedModifier {
        int buttonId;
        String text = null;
        Length width = Length.ZERO;
        Length height = Length.ZERO;

        EditButton() {
        }

        void postInit(GuiScreenEvent.InitGuiEvent.Post event) {
            Optional<GuiButton> button = event.getButtonList().stream().filter(b -> b.field_146127_k == this.buttonId).findFirst();
            button.ifPresent(b -> this.modifyButton(event.getGui(), (GuiButton)b));
        }

        private void modifyButton(GuiScreen gui, GuiButton button) {
            if (this.text != null) {
                button.field_146126_j = this.text;
            }
            if (this.width != Length.ZERO) {
                button.field_146120_f = this.width.getLength(gui.field_146294_l);
            }
            if (this.height != Length.ZERO) {
                button.field_146121_g = this.height.getLength(gui.field_146295_m);
            }
            if (this.offsetX != Length.ZERO) {
                button.field_146128_h = this.getLeft(gui, button.field_146120_f);
            }
            if (this.offsetY != Length.ZERO) {
                button.field_146129_i = this.getTop(gui, button.field_146121_g);
            }
        }
    }

    static class Label
    extends PositionedModifier {
        String text;
        boolean dropShadow = true;
        Color color = new ColorImpl(0xFFFFFF);

        Label() {
        }

        @Override
        public void render(GuiScreenEvent.DrawScreenEvent.Post event) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int left = this.getLeft(event.getGui(), font.func_78256_a(this.text));
            int top = this.getTop(event.getGui(), font.field_78288_b);
            font.func_175065_a(this.text, (float)left, (float)top, this.color.getRGB(), this.dropShadow);
        }
    }

    static abstract class PositionedModifier
    implements Modifier {
        String alignX = "left";
        String alignY = "top";
        Length offsetX = Length.ZERO;
        Length offsetY = Length.ZERO;

        PositionedModifier() {
        }

        int getLeft(GuiScreen gui, int elemWidth) {
            int offset = this.offsetX.getLength(gui.field_146294_l);
            return GuiHelper.calculateLeft(this.alignX, offset, elemWidth, gui.field_146294_l);
        }

        int getTop(GuiScreen gui, int elemHeight) {
            int offset = this.offsetY.getLength(gui.field_146295_m);
            return GuiHelper.calculateTop(this.alignY, offset, elemHeight, gui.field_146295_m);
        }
    }

    static interface Modifier {
        default public void render(GuiScreenEvent.DrawScreenEvent.Post event) {
        }
    }
}

