/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.items.urantypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.UranBaseType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.util.Registry;

public class UOX
extends UranBaseType {
    public UOX() {
        this.loadDefaults();
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(IUranium.RodType type) {
        return Ic2Icons.getTextures((String)"ic2c_extras_nuclear_cells")[this.getRodID(type) - 1100];
    }

    public int getRow() {
        return 1;
    }

    public int getMaxDurability() {
        return 8000;
    }

    public float getEUPerPulse() {
        return 1.0f;
    }

    public int getPulsesPerTick() {
        return 2;
    }

    public int getPulsesForConnection() {
        return 1;
    }

    public float getHeatModifier() {
        return 0.5f;
    }

    public float getExplosionEffectModifier() {
        return 2.0f;
    }

    public ItemStack getUraniumIngot() {
        return new ItemStack((Item)Registry.oxidizedUraniumIngot);
    }

    public ItemStack getRodType(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return new ItemStack((Item)Registry.singleUOXCell).func_77946_l();
            }
            case DualRod: {
                return new ItemStack((Item)Registry.doubleUOXCell).func_77946_l();
            }
            case QuadRod: {
                return new ItemStack((Item)Registry.quadUOXCell).func_77946_l();
            }
            case NearDepletedRod: {
                return new ItemStack((Item)Registry.nearDepletedUOXCell).func_77946_l();
            }
            case IsotopicRod: {
                return new ItemStack((Item)Registry.isotopicUOXCell).func_77946_l();
            }
            case ReEnrichedRod: {
                return new ItemStack((Item)Registry.reEnrichedUOXCell).func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getNewIsotopicRod() {
        return StackUtil.copyWithDamage((ItemStack)this.getRodType(IUranium.RodType.IsotopicRod), (int)(this.getMaxDurability() - 1));
    }

    public short getRodID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 1110;
            }
            case DualRod: {
                return 1105;
            }
            case QuadRod: {
                return 1100;
            }
            case ReEnrichedRod: {
                return 1125;
            }
            case NearDepletedRod: {
                return 1115;
            }
            case IsotopicRod: {
                return 1120;
            }
        }
        return 0;
    }

    public LocaleComp getName(IUranium.RodType rodType) {
        return Ic2Lang.nullKey;
    }

    public boolean isReEnrichedUran() {
        return true;
    }

    public Color getReEnrichedColor() {
        return new Color(0xFFFFFF);
    }

    public ItemStack getIngridient() {
        return Ic2Items.airCell;
    }

    public int getIngrientPoints() {
        return 25;
    }

    public int getIngridientCost() {
        return 25;
    }
}

