/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.info;

import java.util.ArrayList;
import java.util.List;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.storage.PregenTask;
import pregenerator.impl.storage.TaskStorage;

public class ShowTaskListSubCommand
extends BasePregenCommand {
    public ShowTaskListSubCommand() {
        super(0);
        this.addSuggestion("ShowTaskList", "Shows all the Tasks that are stored");
    }

    @Override
    public String getName() {
        return "ShowTaskList";
    }

    @Override
    public String getDescription() {
        return "Shows all the Tasks of the Pregenerator";
    }

    @Override
    public int getRequiredParameterCount() {
        return 0;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        TaskStorage storage = container.getStorage();
        if (storage.hasTasks()) {
            container.sendChatMessage("Pregenerator TaskList: " + storage.getTaskCount() + " Tasks");
            int i = 1;
            for (PregenTask task : container.getStorage().getTasks()) {
                container.sendChatMessage("[" + i + "] " + task.toString());
                ++i;
            }
            container.sendChatMessage("End of TaskList");
        } else {
            container.sendChatMessage("Pregenerator TaskList: Empty");
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        return new ArrayList<String>();
    }
}

