/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network;

import com.direwolf20.buildinggadgets.common.blocks.templatemanager.TemplateManagerCommands;
import com.direwolf20.buildinggadgets.common.blocks.templatemanager.TemplateManagerContainer;
import com.direwolf20.buildinggadgets.common.blocks.templatemanager.TemplateManagerTileEntity;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTemplateManagerPaste
implements IMessage {
    private BlockPos pos;
    private byte[] data;
    private String templateName;

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.templateName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.data = new byte[buf.readableBytes()];
        buf.readBytes(this.data);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.templateName);
        buf.writeBytes(this.data);
    }

    public PacketTemplateManagerPaste() {
    }

    public PacketTemplateManagerPaste(ByteArrayOutputStream pasteStream, BlockPos TMpos, String name) {
        this.pos = TMpos;
        this.data = pasteStream.toByteArray();
        this.templateName = name;
    }

    public static class Handler
    implements IMessageHandler<PacketTemplateManagerPaste, IMessage> {
        public IMessage onMessage(PacketTemplateManagerPaste message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketTemplateManagerPaste message, MessageContext ctx) {
            ByteArrayInputStream bais = new ByteArrayInputStream(message.data);
            try {
                NBTTagCompound newTag = CompressedStreamTools.func_74796_a((InputStream)bais);
                if (newTag.equals((Object)new NBTTagCompound())) {
                    return;
                }
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                BlockPos pos = message.pos;
                TileEntity te = world.func_175625_s(pos);
                if (!(te instanceof TemplateManagerTileEntity)) {
                    return;
                }
                TemplateManagerContainer container = ((TemplateManagerTileEntity)te).getContainer((EntityPlayer)player);
                TemplateManagerCommands.pasteTemplate(container, (EntityPlayer)player, newTag, message.templateName);
            }
            catch (Throwable t) {
                System.out.println(t);
            }
        }
    }
}

