/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.docdump;

import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.core.MethodWrapperLuaObject;
import org.squiddev.plethora.core.PartialContext;
import org.squiddev.plethora.integration.MetaWrapper;

public class ObjectWriter {
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#.#######");
    protected final Appendable output;

    public ObjectWriter(Appendable stream) {
        this.output = stream;
    }

    protected void writeValue(String value) throws IOException {
        this.output.append('\"').append(value).append('\"');
    }

    protected void writeValue(int value) throws IOException {
        this.output.append(Integer.toString(value));
    }

    protected void writeValue(double value) throws IOException {
        if (Double.isFinite(value)) {
            this.output.append(NUMBER_FORMAT.format(value));
        } else if (Double.isNaN(value)) {
            this.output.append("nan");
        } else {
            this.output.append(value > 0.0 ? "inf" : "-inf");
        }
    }

    protected void writeValue(Void value) throws IOException {
        this.output.append("nil");
    }

    protected void writeValue(boolean value) throws IOException {
        this.output.append(Boolean.toString(value));
    }

    protected void writeValue(Map<?, ?> value, String indent) throws IOException {
        if (value.isEmpty()) {
            this.output.append("{}");
            return;
        }
        this.output.append("{");
        this.writeMapBody(value, indent);
        this.output.append("}");
    }

    protected void writeMapBody(Map<?, ?> value, String indent) throws IOException {
        boolean arrayLike = true;
        int max = 0;
        for (Object key : value.keySet()) {
            if (!(key instanceof Number)) {
                arrayLike = false;
                break;
            }
            Number number = (Number)key;
            int n = number.intValue();
            if (n <= 0 || (double)n != number.doubleValue() || !Double.isFinite(n)) {
                arrayLike = false;
                break;
            }
            if (n <= max) continue;
            max = n;
        }
        if (arrayLike && max / 2 > value.size()) {
            arrayLike = false;
        }
        String childIndent = indent + "  ";
        if (arrayLike) {
            Object[] values = new Object[max];
            for (Map.Entry entry : value.entrySet()) {
                values[((Number)entry.getKey()).intValue() - 1] = entry.getValue();
            }
            for (int i = 0; i < max; ++i) {
                if (i > 0) {
                    this.output.append(",");
                }
                this.output.append("\n").append(childIndent);
                this.write(values[i], childIndent);
            }
        } else {
            ArrayList entries = new ArrayList(value.entrySet());
            entries.sort((a, b) -> {
                Object ak = a.getKey();
                Object bk = b.getKey();
                if (ak instanceof String && bk instanceof String) {
                    return ((String)ak).compareTo((String)bk);
                }
                if (ak instanceof Number && bk instanceof Number) {
                    return Double.compare(((Number)ak).doubleValue(), ((Number)bk).doubleValue());
                }
                return Integer.compare(ak.hashCode(), bk.hashCode());
            });
            for (int i = 0; i < entries.size(); ++i) {
                Map.Entry entry = (Map.Entry)entries.get(i);
                if (i > 0) {
                    this.output.append(",");
                }
                this.output.append("\n").append(childIndent);
                Object key = entry.getKey();
                if (key instanceof String && ((String)key).matches("^[a-zA-Z_][0-9a-zA-Z_]*$")) {
                    this.output.append((String)key);
                } else {
                    this.output.append("[");
                    this.write(entry.getKey(), childIndent);
                    this.output.append("]");
                }
                this.output.append(" = ");
                this.write(entry.getValue(), childIndent);
            }
        }
        this.output.append("\n").append(indent);
    }

    protected void writeSpecial(String special) throws IOException {
        this.output.append('\u00ab').append(special).append('\u00bb');
    }

    protected void writeReference(Object target) throws IOException {
        this.writeSpecial("reference to " + target.getClass().getName());
    }

    protected void writeLuaObject(ILuaObject object) throws IOException {
        this.writeSpecial("object " + object.getClass().getName());
    }

    protected void writeMeta(TypedMeta<?, ?> meta, String indent) throws IOException {
        this.writeValue(meta, indent);
    }

    public final void write(Object value) throws IOException {
        this.write(value, "");
    }

    protected final void write(Object value, String indent) throws IOException {
        if (value instanceof String) {
            this.writeValue((String)value);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            if ((double)number.intValue() == number.doubleValue()) {
                this.writeValue(number.intValue());
            } else {
                this.writeValue(number.doubleValue());
            }
        } else if (value == null) {
            this.writeValue((Void)null);
        } else if (value instanceof Boolean) {
            this.writeValue((Boolean)value);
        } else if (value instanceof TypedMeta) {
            this.writeMeta((TypedMeta)value, indent);
        } else if (value instanceof Map) {
            this.writeValue((Map)value, indent);
        } else if (value instanceof MethodWrapperLuaObject) {
            Object target = null;
            try {
                target = ((PartialContext)((Object)((MethodWrapperLuaObject)value).getContext(0).safeBake())).getTarget();
            }
            catch (LuaException luaException) {
                // empty catch block
            }
            while (target instanceof MetaWrapper) {
                target = ((MetaWrapper)target).value();
            }
            if (target != null) {
                this.writeReference(target);
            } else {
                this.writeLuaObject((ILuaObject)value);
            }
        } else if (value instanceof ILuaObject) {
            this.writeLuaObject((ILuaObject)value);
        } else {
            this.writeSpecial("unknown " + value.getClass().getName());
        }
    }
}

