/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object2d;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ColourableObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.Scalable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object2d.MultiPoint2D;
import org.squiddev.plethora.utils.ByteBufUtils;
import org.squiddev.plethora.utils.Vec2d;

public class Line
extends ColourableObject
implements Scalable,
MultiPoint2D {
    private Vec2d start = Vec2d.ZERO;
    private Vec2d end = Vec2d.ZERO;
    private float thickness = 1.0f;

    public Line(int id, int parent) {
        super(id, parent, (byte)1);
    }

    @Override
    public float getScale() {
        return this.thickness;
    }

    @Override
    public void setScale(float scale) {
        if (this.thickness != scale) {
            this.thickness = scale;
            this.setDirty();
        }
    }

    @Override
    @Nonnull
    public Vec2d getPoint(int idx) {
        return idx == 0 ? this.start : this.end;
    }

    @Override
    public void setVertex(int idx, @Nonnull Vec2d point) {
        if (idx == 0) {
            if (!Objects.equal((Object)this.start, (Object)point)) {
                this.start = point;
                this.setDirty();
            }
        } else if (!Objects.equal((Object)this.end, (Object)point)) {
            this.end = point;
            this.setDirty();
        }
    }

    @Override
    public int getVertices() {
        return 2;
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        super.writeInitial(buf);
        ByteBufUtils.writeVec2d(buf, this.start);
        ByteBufUtils.writeVec2d(buf, this.end);
        buf.writeFloat(this.thickness);
    }

    @Override
    public void readInitial(ByteBuf buf) {
        super.readInitial(buf);
        this.start = ByteBufUtils.readVec2d(buf);
        this.end = ByteBufUtils.readVec2d(buf);
        this.thickness = buf.readFloat();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        Line.setupFlat();
        GlStateManager.func_187441_d((float)this.thickness);
        int red = this.getRed();
        int green = this.getGreen();
        int blue = this.getBlue();
        int alpha = this.getAlpha();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)((float)this.start.x), (double)((float)this.start.y), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b((double)((float)this.end.x), (double)((float)this.end.y), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_187441_d((float)1.0f);
    }
}

