/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.glasses.objects.object2d;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.squiddev.plethora.gameplay.modules.glasses.CanvasClient;
import org.squiddev.plethora.gameplay.modules.glasses.objects.ColourableObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.Scalable;
import org.squiddev.plethora.gameplay.modules.glasses.objects.TextObject;
import org.squiddev.plethora.gameplay.modules.glasses.objects.object2d.Positionable2D;
import org.squiddev.plethora.utils.ByteBufUtils;
import org.squiddev.plethora.utils.Vec2d;

public class Text
extends ColourableObject
implements Positionable2D,
Scalable,
TextObject {
    private static final String[][] EMPTY_LINES = new String[0][];
    private static final int TAB_WIDTH = 16;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\r\n|\n|\r");
    private Vec2d position = Vec2d.ZERO;
    private float size = 1.0f;
    private short lineHeight = (short)9;
    private boolean dropShadow = false;
    private String text = "";
    private String[][] lines = EMPTY_LINES;

    public Text(int id, int parent) {
        super(id, parent, (byte)3);
    }

    @Override
    @Nonnull
    public Vec2d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(@Nonnull Vec2d position) {
        if (!Objects.equal((Object)this.position, (Object)position)) {
            this.position = position;
            this.setDirty();
        }
    }

    @Override
    public float getScale() {
        return this.size;
    }

    @Override
    public void setScale(float scale) {
        if (this.size != scale) {
            this.size = scale;
            this.setDirty();
        }
    }

    @Override
    @Nonnull
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(@Nonnull String text) {
        if (!this.text.equals(text)) {
            this.text = text;
            this.lines = Text.splitText(text);
            this.setDirty();
        }
    }

    @Override
    public void setShadow(boolean dropShadow) {
        if (this.dropShadow != dropShadow) {
            this.dropShadow = dropShadow;
            this.setDirty();
        }
    }

    @Override
    public boolean hasShadow() {
        return this.dropShadow;
    }

    @Override
    public void setLineHeight(short lineHeight) {
        if (this.lineHeight == lineHeight) {
            return;
        }
        this.lineHeight = lineHeight;
        this.setDirty();
    }

    @Override
    public short getLineHeight() {
        return this.lineHeight;
    }

    @Override
    public void writeInitial(ByteBuf buf) {
        super.writeInitial(buf);
        ByteBufUtils.writeVec2d(buf, this.position);
        buf.writeFloat(this.size);
        buf.writeBoolean(this.dropShadow);
        buf.writeShort((int)this.lineHeight);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text);
    }

    @Override
    public void readInitial(ByteBuf buf) {
        super.readInitial(buf);
        this.position = ByteBufUtils.readVec2d(buf);
        this.size = buf.readFloat();
        this.dropShadow = buf.readBoolean();
        this.lineHeight = buf.readShort();
        this.text = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.lines = Text.splitText(this.text);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(CanvasClient canvas) {
        int colour = this.getColour();
        int alpha = colour & 0xFF;
        if (alpha == 0) {
            return;
        }
        if ((alpha & 0xFC) == 0) {
            colour |= 4;
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.position.x, (double)this.position.y, (double)0.0);
        GlStateManager.func_179152_a((float)this.size, (float)this.size, (float)1.0f);
        int y = 0;
        for (String[] fullLine : this.lines) {
            int x = 0;
            for (String tabSection : fullLine) {
                x = fontrenderer.func_175065_a(tabSection, (float)x, (float)y, Integer.rotateRight(colour, 8), this.dropShadow);
                x = x / 16 * 16 + 16;
            }
            y += this.lineHeight;
        }
        GlStateManager.func_179121_F();
    }

    private static String[][] splitText(String text) {
        String[] lines = SPLIT_PATTERN.split(text);
        String[][] splitLines = new String[lines.length][];
        StringBuilder format = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            splitLines[i] = lines[i].split("\t");
            String[] tabs = splitLines[i];
            for (int j = 0; j < tabs.length; ++j) {
                String tab = tabs[j];
                format.append(tab);
                tabs[j] = format.toString();
                Text.appendFormat(format, tabs[j]);
            }
        }
        return splitLines;
    }

    private static void appendFormat(StringBuilder builder, String text) {
        builder.setLength(0);
        int l = text.length();
        int i = -1;
        while ((i = text.indexOf(167, i + 1)) != -1) {
            if (i >= l - 1) continue;
            char c0 = text.charAt(i + 1);
            if (Text.isFormatColor(c0)) {
                builder.setLength(0);
                builder.append('\u00a7').append(c0);
                continue;
            }
            if (!Text.isFormatSpecial(c0)) continue;
            builder.append('\u00a7').append(c0);
        }
    }

    private static boolean isFormatColor(char colorChar) {
        return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
    }

    private static boolean isFormatSpecial(char formatChar) {
        return formatChar >= 'k' && formatChar <= 'o' || formatChar >= 'K' && formatChar <= 'O' || formatChar == 'r' || formatChar == 'R';
    }
}

