/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.reference.ConstantReference;

public class MetaWrapper<T>
implements ConstantReference<MetaWrapper<T>> {
    private final T value;

    public MetaWrapper(@Nonnull T value) {
        Objects.requireNonNull(value, "value cannot be null");
        this.value = value;
    }

    @Nonnull
    public T value() {
        return this.value;
    }

    public static <T> MetaWrapper<T> of(@Nonnull T value) {
        return new MetaWrapper<T>(value);
    }

    @Override
    @Nonnull
    public MetaWrapper<T> get() {
        return this;
    }

    @Override
    @Nonnull
    public MetaWrapper<T> safeGet() {
        return this;
    }

    @Injects
    public static final class MetaProvider
    extends BaseMetaProvider<MetaWrapper> {
        public MetaProvider() {
            super("Simply wraps an object and exposes metadata for that. You can happily ignore this.");
        }

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<MetaWrapper> context) {
            return context.makePartialChild(context.getTarget().value()).getMeta();
        }
    }
}

