/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.DuctUnitStructural;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.util.WorldGridList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class GridStructural
extends MultiBlockGrid<DuctUnitStructural> {
    public boolean signalsUpToDate;
    public MultiBlockGrid.RedstoneControl rs;

    public GridStructural(WorldGridList worldGrid) {
        super(worldGrid);
    }

    public GridStructural(World worldObj) {
        super(worldObj);
    }

    @Override
    public boolean canAddBlock(IGridTile aBlock) {
        return true;
    }

    @Override
    public void tickGrid() {
        if (this.rs != null) {
            this.rs.updateLevels();
            Iterator signallersOut = this.rs.relaysOut;
            if (signallersOut != null) {
                Iterator<Attachment> iterator = ((ArrayList)((Object)signallersOut)).iterator();
                while (iterator.hasNext()) {
                    Attachment output = iterator.next();
                    output.checkSignal();
                }
            }
        }
        if (this.signalsUpToDate) {
            return;
        }
        this.signalsUpToDate = true;
        if (this.rs == null || this.rs.relaysIn == null) {
            if (this.rs != null) {
                this.rs.relaysOut = null;
            }
            for (Object multiBlock : this.nodeSet) {
                ((DuctUnitStructural)multiBlock).addRelays();
            }
            for (Object multiBlock : this.idleSet) {
                ((DuctUnitStructural)multiBlock).addRelays();
            }
        }
        if (this.rs == null) {
            return;
        }
        if (this.rs.relaysIn == null) {
            if (this.rs.relaysOut == null) {
                this.rs = null;
                return;
            }
            this.rs.setNextLevels(0);
            return;
        }
        int[] powered = new int[16];
        for (Relay signaller : this.rs.relaysIn) {
            int power = Math.max(powered[signaller.color], signaller.getPowerLevel());
            if (power <= 0) continue;
            powered[signaller.color] = power;
        }
        for (int i = 0; i < 16; ++i) {
            this.rs.nextRedstoneLevel[i] = powered[i];
        }
    }

    public void addSignalInput(Relay signaller) {
        if (signaller.isInput()) {
            if (this.rs == null) {
                this.rs = new MultiBlockGrid.RedstoneControl();
            }
            if (this.rs.relaysIn == null) {
                this.rs.relaysIn = new ArrayList();
            }
            this.rs.relaysIn.add(signaller);
        }
    }

    public void addSignalOutput(Attachment attachment) {
        if (this.rs == null) {
            this.rs = new MultiBlockGrid.RedstoneControl();
        }
        if (this.rs.relaysOut == null) {
            this.rs.relaysOut = new ArrayList();
        }
        this.rs.relaysOut.add(attachment);
    }

    public void resetRelays() {
        if (this.rs != null) {
            this.rs.relaysIn = null;
            this.rs.relaysOut = null;
        }
        this.signalsUpToDate = false;
    }

    @Override
    public void onMinorGridChange() {
        this.resetRelays();
    }

    @Override
    public void onMajorGridChange() {
        this.resetRelays();
    }

    @Override
    public void addInfo(List<ITextComponent> info, EntityPlayer player, boolean debug) {
        if (this.rs != null) {
            for (int i = 0; i < 16; ++i) {
                int r = this.rs.redstoneLevels[i];
                if (this.rs.nextRedstoneLevel[i] != -128) {
                    r = this.rs.nextRedstoneLevel[i];
                }
                if (r <= 0) continue;
                this.addInfo(info, "redstone", StringHelper.localize((String)("info.thermaldynamics.relay.color." + i)) + " - " + r);
            }
        }
        super.addInfo(info, player, debug);
    }
}

