/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.event.ClientEventHandler;
import stevekung.mods.moreplanets.inventory.ContainerDarkEnergyReceiver;
import stevekung.mods.moreplanets.tileentity.TileEntityDarkEnergyReceiver;
import stevekung.mods.moreplanets.utils.client.gui.GuiContainerMP;
import stevekung.mods.moreplanets.utils.client.gui.GuiElementInfoRegionMP;
import stevekung.mods.stevekunglib.utils.LangUtils;

@SideOnly(value=Side.CLIENT)
public class GuiDarkEnergyReceiver
extends GuiContainerMP
implements GuiElementCheckbox.ICheckBoxCallback {
    private static final ResourceLocation TEXTURE = new ResourceLocation("moreplanets:textures/gui/dark_energy_receiver.png");
    private final TileEntityDarkEnergyReceiver tile;
    private GuiElementInfoRegionMP electricInfoRegion;
    private GuiButton buttonEnable;
    private GuiElementCheckbox checkboxRender;

    public GuiDarkEnergyReceiver(InventoryPlayer inv, TileEntityDarkEnergyReceiver tile) {
        super(new ContainerDarkEnergyReceiver(inv, tile));
        this.tile = tile;
        this.field_147000_g = 180;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, GCCoreUtil.getDimensionID((World)this.tile.func_145831_w()), new Object[]{this.tile.func_174877_v(), 0}));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.infoRegions.add(new GuiElementInfoRegionMP(x + 31, y + 26, 18, 18, Arrays.asList(LangUtils.translate((String)"gui.battery_slot.desc.0"), LangUtils.translate((String)"gui.battery_slot.desc.1")), this.field_146294_l, this));
        if (!this.tile.successful && !this.tile.activated) {
            this.infoRegions.add(new GuiElementInfoRegionMP(x + 155, y + 87, 13, 13, Collections.singletonList(LangUtils.translate((String)"gui.multiblock_guide.desc")), this.field_146294_l, this));
        }
        this.electricInfoRegion = new GuiElementInfoRegionMP(x + 107, y + 31, 56, 9, new ArrayList<String>(), this.field_146294_l, this);
        this.infoRegions.add(this.electricInfoRegion);
        this.buttonEnable = new GuiButton(0, this.field_146294_l / 2 - 36, this.field_146295_m / 2 - 19, 72, 20, !this.tile.getDisabled(0) ? LangUtils.translate((String)"gui.button.disable.name") : LangUtils.translate((String)"gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnable);
        this.buttonEnable.field_146124_l = this.tile.disableCooldown == 0 && !this.tile.successful;
        this.checkboxRender = new GuiElementCheckbox(1, (GuiElementCheckbox.ICheckBoxCallback)this, x + 155, y + 87, "");
        this.checkboxRender.field_146125_m = !this.tile.successful && !this.tile.activated;
        this.field_146292_n.add(this.checkboxRender);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.buttonEnable.field_146124_l = this.tile.disableCooldown == 0 && !this.tile.successful;
        this.buttonEnable.field_146126_j = !this.tile.getDisabled(0) ? LangUtils.translate((String)"gui.button.disable.name") : LangUtils.translate((String)"gui.button.enable.name");
        this.field_146289_q.func_78276_b(this.tile.func_70005_c_(), 8, 10, 0x404040);
        this.func_73732_a(this.field_146289_q, LangUtils.translate((String)"gui.message.status.name") + ": " + this.tile.getGUIStatus(), this.field_146999_f / 2, 50, 0x404040);
        this.func_73732_a(this.field_146289_q, LangUtils.translate((String)"gui.status.machine_status.name") + ": " + this.getStatus(), this.field_146999_f / 2, 60, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.translate((String)"container.inventory"), 8, this.field_147000_g - 90 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y + 5, 0, 0, this.field_146999_f, 181);
        int scale = this.tile.getScaledElecticalLevel(54);
        this.func_73729_b(x + 107, y + 31, 197, 0, Math.min(scale, 54), 7);
        if (this.tile.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(x + 93, y + 30, 176, 0, 11, 10);
        }
        if (this.tile.activated && !this.tile.successful) {
            this.func_73729_b(x + 64, y + 16, 176, 10, 16, 16);
        }
        ArrayList<String> desc = new ArrayList<String>(Arrays.asList(LangUtils.translate((String)"gui.energy_storage.desc.0")));
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tile.getEnergyStoredGC(), (float)this.tile.getMaxEnergyStoredGC(), desc);
        this.electricInfoRegion.tooltipStrings = desc;
        this.checkboxRender.isSelected = ClientEventHandler.RECEIVER_RENDER_POS.contains(this.tile.func_174877_v());
    }

    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        if (ClientEventHandler.RECEIVER_RENDER_POS.contains(this.tile.func_174877_v())) {
            this.tile.initMultiBlock = true;
            this.tile.multiTileClientLists.clear();
            this.tile.multiBlockClientLists.clear();
            ClientEventHandler.RECEIVER_RENDER_POS.remove(this.tile.func_174877_v());
        } else {
            ClientEventHandler.RECEIVER_RENDER_POS.add(this.tile.func_174877_v());
        }
    }

    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return true;
    }

    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        return ClientEventHandler.RECEIVER_RENDER_POS.contains(this.tile.func_174877_v());
    }

    public void onIntruderInteraction() {
    }

    public void func_73732_a(FontRenderer fontRenderer, String text, int x, int y, int color) {
        fontRenderer.func_175065_a(text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color, false);
    }

    private String getStatus() {
        if (this.tile.activated && !this.tile.successful && this.tile.activatedTick > 0 && this.tile.activatedTick < this.tile.getSuccessfulTick()) {
            return LangUtils.translate((String)"gui.status.dark_energy_percent0.name", (Object[])new Object[]{this.tile.activatedTick * 100 / this.tile.getSuccessfulTick()}) + LangUtils.translate((String)"gui.status.dark_energy_percent1.name");
        }
        if (this.tile.successful) {
            return TextFormatting.DARK_GREEN + LangUtils.translate((String)"gui.status.dark_energy_core_created.name");
        }
        return this.tile.getEnergyStoredGC() > 0.0f ? TextFormatting.DARK_GREEN + LangUtils.translate((String)"gui.status.ready.name") : TextFormatting.DARK_RED + LangUtils.translate((String)"gui.status.dark_energy_offline.name");
    }
}

