/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.tracking;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.mutable.MutableInt;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.tracking.CollectorMap;

public class ChunkEntry {
    public static final RegistryNamespaced<ResourceLocation, Class<? extends TileEntity>> registry = (RegistryNamespaced)ReflectionHelper.getPrivateValue(TileEntity.class, null, (int)1);
    int data;
    public int xPos;
    public int zPos;
    public Map<String, Integer> entityCount = new HashMap<String, Integer>();
    public Map<String, Integer> tileEntityCount = new HashMap<String, Integer>();
    public Map<Integer, Integer> biomeCount = new HashMap<Integer, Integer>();
    public int entities;
    public int entityTypes;
    public int tileEntities;
    public int tickableTileEntities;
    public int tileTypes;
    public int randomUpdateBlocks;

    public static void init() {
    }

    private ChunkEntry() {
    }

    public static ChunkEntry fromBuffer(IReadableBuffer buffer) {
        ChunkEntry entry = new ChunkEntry();
        entry.readFromBuffer(buffer);
        return entry;
    }

    /*
     * WARNING - void declaration
     */
    public static ChunkEntry fromChunk(Chunk chunk) {
        void var6_17;
        ChunkEntry data = new ChunkEntry();
        data.data = 16;
        data.xPos = chunk.field_76635_g;
        data.zPos = chunk.field_76647_h;
        CollectorMap<EntityPlayer> entityMap = new CollectorMap<EntityPlayer>();
        for (ClassInheritanceMultiMap classInheritanceMultiMap : chunk.func_177429_s()) {
            entityMap.addAll((Collection<EntityPlayer>)classInheritanceMultiMap);
        }
        entityMap.removeAll(EntityPlayer.class);
        data.entities = entityMap.size();
        data.entityTypes = entityMap.getTypeCount();
        for (Map.Entry entry : entityMap.entrySet()) {
            ResourceLocation res = EntityList.func_191306_a((Class)((Class)entry.getKey()));
            if (res == null) continue;
            data.addEntityType(res.toString(), ((Set)entry.getValue()).size());
        }
        int tickable = 0;
        CollectorMap<TileEntity> collectorMap = new CollectorMap<TileEntity>();
        for (TileEntity tileEntity : chunk.func_177434_r().values()) {
            if (tileEntity instanceof ITickable) {
                ++tickable;
            }
            collectorMap.addEntry(tileEntity);
        }
        data.tickableTileEntities = tickable;
        data.tileEntities = collectorMap.size();
        data.tileTypes = collectorMap.getTypeCount();
        for (Map.Entry entry : collectorMap.entrySet()) {
            ResourceLocation res = (ResourceLocation)registry.func_177774_c(entry.getKey());
            if (res == null) continue;
            data.addTileEntityType(res.toString(), ((Set)entry.getValue()).size());
        }
        ExtendedBlockStorage[] extendet = chunk.func_76587_i();
        boolean bl = false;
        while (var6_17 < 16 && extendet[var6_17] != null) {
            try {
                data.randomUpdateBlocks += ((Integer)ReflectionHelper.getPrivateValue(ExtendedBlockStorage.class, (Object)extendet[var6_17], (int)2)).intValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++var6_17;
        }
        LinkedHashMap<Integer, MutableInt> linkedHashMap = new LinkedHashMap<Integer, MutableInt>();
        for (byte biomeID : chunk.func_76605_m()) {
            Integer id = new Integer(biomeID);
            MutableInt counter = (MutableInt)linkedHashMap.get(id);
            if (counter == null) {
                counter = new MutableInt();
                linkedHashMap.put(id, counter);
            }
            counter.increment();
        }
        Object object = linkedHashMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            data.addBiomeType((Integer)entry.getKey(), ((MutableInt)entry.getValue()).intValue());
        }
        return data;
    }

    private void addEntityType(String s, int count) {
        if (s == null) {
            return;
        }
        this.entityCount.put(s, count);
        this.data += 6 + s.length() * 2;
    }

    private void addTileEntityType(String s, int count) {
        if (s == null) {
            return;
        }
        this.tileEntityCount.put(s, count);
        this.data += 6 + s.length() * 2;
    }

    private void addBiomeType(int id, int count) {
        this.biomeCount.put(id, count);
        this.data += 8;
    }

    public void writeToBuffer(IWriteableBuffer buffer) {
        buffer.writeInt(this.xPos);
        buffer.writeInt(this.zPos);
        buffer.writeInt(this.entityCount.size());
        for (Map.Entry<String, Integer> entry : this.entityCount.entrySet()) {
            ChunkEntry.writeString(entry.getKey(), buffer);
            buffer.writeInt(entry.getValue());
        }
        buffer.writeInt(this.tileEntityCount.size());
        for (Map.Entry<String, Integer> entry : this.tileEntityCount.entrySet()) {
            ChunkEntry.writeString(entry.getKey(), buffer);
            buffer.writeInt(entry.getValue());
        }
        buffer.writeInt(this.biomeCount.size());
        for (Map.Entry<Object, Integer> entry : this.biomeCount.entrySet()) {
            buffer.writeInt((Integer)entry.getKey());
            buffer.writeInt(entry.getValue());
        }
        buffer.writeInt(this.tickableTileEntities);
        buffer.writeInt(this.randomUpdateBlocks);
    }

    public static void writeString(String s, IWriteableBuffer buffer) {
        buffer.writeShort(s.length());
        for (int i = 0; i < s.length(); ++i) {
            buffer.writeChar(s.charAt(i));
        }
    }

    public void readFromBuffer(IReadableBuffer buffer) {
        int count;
        String s;
        int i;
        this.xPos = buffer.readInt();
        this.zPos = buffer.readInt();
        int expected = buffer.readInt();
        for (i = 0; i < expected; ++i) {
            s = ChunkEntry.readString(buffer);
            count = buffer.readInt();
            this.entityCount.put(s, count);
            this.entities += count;
        }
        this.entityTypes = this.entityCount.size();
        expected = buffer.readInt();
        for (i = 0; i < expected; ++i) {
            s = ChunkEntry.readString(buffer);
            count = buffer.readInt();
            this.tileEntityCount.put(s, count);
            this.tileEntities += count;
        }
        expected = buffer.readInt();
        for (i = 0; i < expected; ++i) {
            int id = buffer.readInt();
            count = buffer.readInt();
            this.biomeCount.put(id, count);
        }
        this.tileTypes = this.tileEntityCount.size();
        this.tickableTileEntities = buffer.readInt();
        this.randomUpdateBlocks = buffer.readInt();
    }

    public static String readString(IReadableBuffer buffer) {
        StringBuilder builder = new StringBuilder();
        int size = buffer.readShort();
        for (int i = 0; i < size; ++i) {
            builder.append(buffer.readChar());
        }
        return builder.toString();
    }

    public int getBytes() {
        return this.data;
    }

    public FilePos getPos() {
        return new FilePos(this.xPos, this.zPos);
    }
}

