/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;
import mekanism.common.recipe.GasConversionHandler;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.GasConversion")
@ZenRegister
public class GasConversion {
    public static final String NAME = "Mekanism Gas Conversion";

    @ZenMethod
    public static void register(IIngredient ingredient, IGasStack gas) {
        if (IngredientHelper.checkNotNull(NAME, ingredient, gas)) {
            CrafttweakerIntegration.LATE_ADDITIONS.add(new Add(ingredient, gas));
        }
    }

    @ZenMethod
    public static void unregister(IIngredient ingredient, IGasStack gas) {
        if (IngredientHelper.checkNotNull(NAME, ingredient, gas)) {
            CrafttweakerIntegration.LATE_REMOVALS.add(new Remove(ingredient, gas));
        }
    }

    @ZenMethod
    public static void unregisterAll() {
        CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            GasConversionHandler.removeAllGasMappings();
        }

        public String describe() {
            return "Removing all gas conversions.";
        }
    }

    private static class Remove
    implements IAction {
        private final IIngredient ingredient;
        private final IGasStack gas;

        private Remove(IIngredient ingredient, IGasStack gas) {
            this.ingredient = ingredient;
            this.gas = gas;
        }

        public void apply() {
            int count = GasConversionHandler.removeGasMapping(IngredientHelper.getMekanismIngredient(this.ingredient), GasHelper.toGas(this.gas));
            CraftTweakerAPI.logInfo((String)("Removing " + count + " gas conversion" + (count == 1 ? "" : "s") + " between: " + this.ingredient.toCommandString() + " and " + this.gas.toCommandString()));
        }

        public String describe() {
            return null;
        }
    }

    private static class Add
    implements IAction {
        private final IIngredient ingredient;
        private final IGasStack gas;

        private Add(IIngredient ingredient, IGasStack gas) {
            this.ingredient = ingredient;
            this.gas = gas;
        }

        public void apply() {
            boolean noOverride = GasConversionHandler.addGasMapping(IngredientHelper.getMekanismIngredient(this.ingredient), GasHelper.toGas(this.gas));
            if (!noOverride) {
                CraftTweakerAPI.logWarning((String)String.format("%s: %s overrides another conversion. It is recommended to manually call unregisterGasItem and then registerGasItem to override conversions as unexpected things may occur.", GasConversion.NAME, this.ingredient.toCommandString()));
            }
        }

        public String describe() {
            return "Adding gas conversion between: " + this.ingredient.toCommandString() + " to " + this.gas.toCommandString();
        }
    }
}

