/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.tile;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.item.ElectricItem;
import ic2.api.tile.IEnergyStorage;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorEUStorage;
import ic2.core.block.personal.base.TileEntityPersonalStorageBase;
import ic2.core.block.personal.base.misc.FilteredPersonalInventory;
import ic2.core.block.personal.base.misc.IPersonalEnergyStorage;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.personal.container.ContainerPersonalEnergyStorage;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IItemContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityPersonalEnergyStorage
extends TileEntityPersonalStorageBase
implements IPersonalEnergyStorage,
IEnergySink,
IEUStorage,
ITickable,
IItemContainer,
IEnergySource {
    @NetworkField(index=7)
    public EnergyStorage storage = new EnergyStorage(this);
    public PersonalInventory inventory = new FilteredPersonalInventory(2);
    private boolean addedToEnet = false;

    public TileEntityPersonalEnergyStorage() {
        this.addNetworkFields("storage");
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        manager.addComparatorMode(new ComparatorEUStorage(this));
    }

    @Override
    public boolean allowExtraction() {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return this.storage.getSubType();
    }

    @Override
    public int getStoredEU() {
        return this.allowView ? this.storage.stored : 0;
    }

    @Override
    public int getMaxEU() {
        return this.allowView ? this.storage.maxEnergy : 0;
    }

    @Override
    public void onChange(int type) {
        if (type == 1) {
            this.inventory.clear();
            this.storage.setStored(0);
        } else if (type == 2) {
            boolean enetResult;
            boolean bl = enetResult = this.allowInjection || this.allowExtraction;
            if (this.addedToEnet) {
                this.addedToEnet = false;
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            if (enetResult) {
                this.addedToEnet = true;
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
        } else if (type == 3) {
            boolean enetResult;
            boolean bl = enetResult = this.allowInjection || this.allowExtraction;
            if (this.addedToEnet) {
                this.addedToEnet = false;
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            if (enetResult) {
                this.addedToEnet = true;
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
        }
    }

    @Override
    public void setFacing(EnumFacing facing) {
        if (this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnet = false;
        super.setFacing(facing);
        if (this.allowExtraction || this.allowInjection) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void setType(int maxTier, int maxEnergy) {
        this.storage.setType(maxTier, maxEnergy);
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.storage.getDrop());
        return list;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.allowInjection && side != this.getFacing();
    }

    @Override
    public double getDemandedEnergy() {
        if (this.allowInjection) {
            return this.storage.getCapacity() - this.storage.getStored();
        }
        return 0.0;
    }

    @Override
    public int getSinkTier() {
        return 13;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (!this.allowInjection || amount > (double)this.storage.getMaxInput() || amount < 0.0) {
            return 0.0;
        }
        return this.storage.charge(amount);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return !this.allowExtraction && side == this.getFacing();
    }

    @Override
    public double getOfferedEnergy() {
        if (this.allowExtraction) {
            return Math.min(this.storage.getMaxInput(), this.storage.getStored());
        }
        return 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
        if (this.allowExtraction && amount > 0.0) {
            this.storage.discharge(amount);
        }
    }

    @Override
    public int getSourceTier() {
        return this.storage.getTier();
    }

    @Override
    public IEnergyStorage getStorage(UUID user) {
        if (this.canAccess(user)) {
            return this.storage;
        }
        return null;
    }

    public void updateStorage() {
        this.getNetwork().updateTileGuiField(this, "storage");
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        if (this.canAccess(player.func_110124_au())) {
            return new ContainerPersonalEnergyStorage(player.field_71071_by, this, false);
        }
        if (this.allowView) {
            return new ContainerPersonalEnergyStorage(player.field_71071_by, this, true);
        }
        return null;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        if (this.canAccess(player.func_110124_au()) || this.allowView) {
            return GuiComponentContainer.class;
        }
        return null;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.allowInjection && this.isSimulating() && !this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating() && this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return this.canAccess(player.func_110124_au()) && this.inventory.isInvEmpty();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory.readFromNBT(nbt.func_74775_l("Inventory"));
        this.storage.readFromNBT(nbt.func_74775_l("Storage"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.inventory.writeToNBT(this.getTag(nbt, "Inventory"));
        this.storage.writeToNBT(this.getTag(nbt, "Storage"));
        return nbt;
    }

    public void func_73660_a() {
        this.storage.update();
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    public static class EnergyStorage
    implements IEnergyStorage,
    INetworkFieldData {
        public int tier;
        public int maxEnergy;
        public int stored;
        public int maxIn = -1;
        public TileEntityPersonalEnergyStorage storage;

        public EnergyStorage(TileEntityPersonalEnergyStorage personal) {
            this.storage = personal;
        }

        public LocaleComp getSubType() {
            if (this.tier == 1 && this.maxEnergy == 30000) {
                return Ic2BlockLang.personalBatbox;
            }
            if (this.tier == 2 && this.maxEnergy == 600000) {
                return Ic2BlockLang.personalMFE;
            }
            if (this.tier == 3 && this.maxEnergy == 10000000) {
                return Ic2BlockLang.personalMFSU;
            }
            return Ic2BlockLang.personalEnergyStorage;
        }

        public ItemStack getDrop() {
            if (this.tier == 1 && this.maxEnergy == 30000) {
                return Ic2Items.personalEnergyStorageBatBox.func_77946_l();
            }
            if (this.tier == 2 && this.maxEnergy == 600000) {
                return Ic2Items.personalEnergyStorageMFE.func_77946_l();
            }
            if (this.tier == 3 && this.maxEnergy == 10000000) {
                return Ic2Items.personalEnergyStorageMFSU.func_77946_l();
            }
            return Ic2Items.personalEnergyStorage.func_77946_l();
        }

        public int getType() {
            if (this.tier == 1 && this.maxEnergy == 30000) {
                return 0;
            }
            if (this.tier == 2 && this.maxEnergy == 600000) {
                return 1;
            }
            if (this.tier == 3 && this.maxEnergy == 10000000) {
                return 2;
            }
            return 0;
        }

        public int getTier() {
            return this.tier;
        }

        public int getMaxInput() {
            if (this.maxIn == -1) {
                this.maxIn = (int)EnergyNet.instance.getPowerFromTier(this.tier);
            }
            return this.maxIn;
        }

        public void setType(int maxTier, int maxStorage) {
            this.tier = maxTier;
            this.maxEnergy = maxStorage;
            this.maxIn = -1;
            this.storage.updateStorage();
        }

        @Override
        public int getStored() {
            return this.stored;
        }

        @Override
        public void setStored(int energy) {
            this.stored = energy;
            this.storage.updateStorage();
        }

        @Override
        public int addEnergy(int amount) {
            this.stored += amount;
            this.storage.updateStorage();
            return this.stored;
        }

        public double charge(double amount) {
            this.stored = (int)((double)this.stored + amount);
            int left = 0;
            if (this.stored >= this.maxEnergy) {
                left = this.stored - this.maxEnergy;
                this.stored = this.maxEnergy;
            }
            this.storage.updateStorage();
            return left;
        }

        public void discharge(double amount) {
            this.stored = (int)((double)this.stored - amount);
            if (this.stored < 0) {
                this.stored = 0;
            }
            this.storage.updateStorage();
        }

        @Override
        public int getCapacity() {
            return this.maxEnergy;
        }

        @Override
        public int getOutput() {
            return 0;
        }

        @Override
        public double getOutputEnergyUnitsPerTick() {
            return 0.0;
        }

        @Override
        public boolean isTeleporterCompatible(EnumFacing side) {
            return false;
        }

        @Override
        public void read(IInputBuffer buffer) {
            this.tier = buffer.readByte();
            this.stored = buffer.readInt();
            this.maxEnergy = buffer.readInt();
        }

        @Override
        public void write(IOutputBuffer buffer) {
            buffer.writeByte((byte)this.tier);
            buffer.writeInt(this.stored);
            buffer.writeInt(this.maxEnergy);
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a("Tier", this.tier);
            tag.func_74768_a("Energy", this.stored);
            tag.func_74768_a("MaxEnergy", this.maxEnergy);
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.tier = tag.func_74762_e("Tier");
            this.stored = tag.func_74762_e("Energy");
            this.maxEnergy = tag.func_74762_e("MaxEnergy");
        }

        public float getChargeLevel() {
            float charge = (float)this.stored / (float)this.maxEnergy;
            if (charge > 1.0f) {
                charge = 1.0f;
            }
            return charge;
        }

        public void update() {
            PersonalInventory inv = this.storage.inventory;
            if (this.stored > 0 && inv.getStackInSlot(0) != null) {
                int removed = (int)ElectricItem.manager.charge(inv.getStackInSlot(0), this.stored, this.tier, false, false);
                this.stored -= removed;
                if (removed > 0) {
                    this.storage.updateStorage();
                }
            }
            if (this.maxEnergy - this.stored > 0 && inv.getStackInSlot(1) != null) {
                Item item = inv.getStackInSlot(1).func_77973_b();
                boolean removeItem = false;
                if (item == Items.field_151137_ax) {
                    this.stored += 500;
                    removeItem = true;
                } else if (item == Item.func_150898_a((Block)Blocks.field_150451_bX)) {
                    this.stored += 5000;
                    removeItem = true;
                } else if (item == Ic2Items.suBattery.func_77973_b()) {
                    this.stored += 1000;
                    removeItem = true;
                } else {
                    int added = (int)ElectricItem.manager.discharge(inv.getStackInSlot(1), this.maxEnergy - this.stored, this.tier, false, true, false);
                    this.stored += added;
                    if (added > 0) {
                        this.storage.updateStorage();
                    }
                }
                if (removeItem) {
                    inv.getStackInSlot(1).func_190918_g(1);
                    this.storage.updateStorage();
                }
            }
        }
    }
}

