/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.textures.ISolidWorldTexture;
import com.rwtema.extrautils2.textures.TextureComponent;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class XUBlockConnectedTextureBase
extends XUBlock {
    public final BoxModel worldModel;
    public HashMap<IBlockState, BoxModel> invModels = new HashMap();

    public XUBlockConnectedTextureBase(Material materialIn) {
        super(materialIn);
        this.worldModel = this.createBaseModel();
        if (!this.field_149764_J.func_76228_b()) {
            this.worldModel.renderAsNormalBlock = false;
        }
    }

    @Override
    public void clearCaches() {
        this.invModels.clear();
    }

    @Override
    public abstract boolean func_149662_c(IBlockState var1);

    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        IBlockState state = blockAccess.func_180495_p(pos.func_177972_a(side));
        return state != blockState && !state.doesSideBlockRendering(blockAccess, pos.func_177972_a(side), side.func_176734_d());
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ISolidWorldTexture getConnectedTexture(IBlockState var1, EnumFacing var2);

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        return this.worldModel;
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        XUBlockState state = this.xuBlockState.getStateFromItemStack(item);
        BoxModel model = this.invModels.get((Object)state);
        if (model == null) {
            model = this.createBaseModel();
            for (EnumFacing facing : EnumFacing.values()) {
                model.forEach(arg_0 -> this.lambda$getInventoryModel$0(facing, (IBlockState)state, arg_0));
            }
            this.invModels.put((IBlockState)state, model);
        }
        return model;
    }

    public BlockRenderLayer renderLayer(IBlockState state) {
        return this.func_180664_k();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        IBlockState state1 = state == null ? world.func_180495_p(pos) : state;
        BoxModel boxes = this.createBaseModel();
        boxes.clear();
        BlockRenderLayer layer = this.renderLayer(state);
        EnumFacing[] values = EnumFacing.values();
        for (int side_index = 0; side_index < 6; ++side_index) {
            EnumFacing side = values[side_index];
            boolean renderSide = this.func_176225_a(state1, world, pos, side);
            if (!renderSide) continue;
            ISolidWorldTexture texture = this.getConnectedTexture(state1, side);
            List<TextureComponent> composites = texture.getComposites(world, pos, side);
            for (TextureComponent composite : composites) {
                Box box;
                String texture1 = (String)Textures.spritesInverse.get((Object)composite.sprite);
                float[] tex = new float[]{composite.u0, composite.v1, composite.u1, composite.v0};
                switch (side) {
                    case DOWN: {
                        box = boxes.addBoxI(composite.u0, 0, composite.v0, composite.u1, 0, composite.v1, texture1);
                        break;
                    }
                    case UP: {
                        box = boxes.addBoxI(composite.u0, 16, composite.v0, composite.u1, 16, composite.v1, texture1);
                        break;
                    }
                    case NORTH: {
                        box = boxes.addBoxI(composite.u0, 16 - composite.v0, 0, composite.u1, 16 - composite.v1, 0, texture1);
                        break;
                    }
                    case SOUTH: {
                        box = boxes.addBoxI(composite.u0, 16 - composite.v0, 16, composite.u1, 16 - composite.v1, 16, texture1);
                        break;
                    }
                    case WEST: {
                        box = boxes.addBoxI(0, 16 - composite.v0, composite.u0, 0, 16 - composite.v1, composite.u1, texture1);
                        break;
                    }
                    case EAST: {
                        box = boxes.addBoxI(16, 16 - composite.v0, composite.u0, 16, 16 - composite.v1, composite.u1, texture1);
                        break;
                    }
                    default: {
                        box = new Box(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                    }
                }
                float[][] bbfloats = new float[][]{null, null, null, null, null, null};
                bbfloats[side_index] = tex;
                box.setTextureBounds(bbfloats);
                box.layer = layer;
                box.invisible[side_index ^ 1] = true;
            }
        }
        return boxes;
    }

    public boolean isDoubleSided(IBlockState state) {
        return false;
    }

    protected BoxModel createBaseModel() {
        return BoxModel.newStandardBlock();
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return super.shouldCheckWeakPower(state, world, pos, side);
    }

    private /* synthetic */ void lambda$getInventoryModel$0(EnumFacing facing, IBlockState state, Box box) {
        box.setTextureSides(facing, this.getConnectedTexture(state, facing).getItemTexture(facing));
    }
}

