/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.integrations.contenttweaker.traits;

import c4.conarm.integrations.contenttweaker.traits.ConArmTraitDataRepresentation;
import c4.conarm.lib.utils.RecipeMatchHolder;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.contenttweaker.conarm.ArmorTrait")
@ZenRegister
@ModOnly(value="contenttweaker")
public class ConArmTraitRepresentation {
    private final ITrait trait;

    public ConArmTraitRepresentation(ITrait trait) {
        this.trait = trait;
    }

    public static ConArmTraitRepresentation getFromString(String identifier) {
        ITrait trait = TinkerRegistry.getTrait((String)identifier);
        if (trait == null) {
            CraftTweakerAPI.logError((String)("Cannot identify trait <conarmtrait:" + identifier + ">"));
            return null;
        }
        return new ConArmTraitRepresentation(trait);
    }

    @ZenMethod
    public void addItem(IIngredient item, @Optional(valueLong=1L) int amountNeeded, @Optional(valueLong=1L) int amountMatched) {
        if (!(this.trait instanceof IModifier)) {
            CraftTweakerAPI.logError((String)("Cannot add item " + item.toCommandString() + " to trait " + this.toCommandString()));
            return;
        }
        IModifier trait = (IModifier)this.trait;
        if (item instanceof IItemStack) {
            RecipeMatchHolder.addItem(trait, CraftTweakerMC.getItemStack((IIngredient)item), amountNeeded, amountMatched);
        } else if (item instanceof IOreDictEntry) {
            RecipeMatchHolder.addItem(trait, ((IOreDictEntry)item).getName(), amountNeeded, amountMatched);
        } else {
            for (IItemStack itemStack : item.getItems()) {
                this.addItem((IIngredient)itemStack, amountNeeded, amountMatched);
            }
        }
    }

    @ZenGetter(value="identifier")
    public String getIdentifier() {
        return this.trait.getIdentifier();
    }

    @ZenGetter(value="commandString")
    public String toCommandString() {
        return "<conarmtrait:" + this.trait.getIdentifier() + ">";
    }

    @ZenMethod
    public ConArmTraitDataRepresentation getData(IItemStack itemStack) {
        if (this.trait instanceof ModifierTrait) {
            return new ConArmTraitDataRepresentation(((ModifierTrait)this.trait).getData(CraftTweakerMC.getItemStack((IItemStack)itemStack)));
        }
        CraftTweakerAPI.logError((String)("Trait " + this.trait.getIdentifier() + " is not applicable to the getData function!"));
        return null;
    }

    public ITrait getTrait() {
        return this.trait;
    }
}

