/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.dimension;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;

public class TeleportTypeAsteroids
implements ITeleportType {
    public boolean useParachute() {
        return false;
    }

    public Vector3 getPlayerSpawnLocation(WorldServer world, EntityPlayerMP player) {
        if (player != null) {
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            int x = MathHelper.func_76128_c((double)stats.getCoordsTeleportedFromX());
            int z = MathHelper.func_76128_c((double)stats.getCoordsTeleportedFromZ());
            int limit = ConfigManagerCore.otherPlanetWorldBorders - 2;
            if (limit > 20) {
                if (x > limit) {
                    z *= limit / x;
                    x = limit;
                } else if (x < -limit) {
                    z *= -limit / x;
                    x = -limit;
                }
                if (z > limit) {
                    x *= limit / z;
                    z = limit;
                } else if (z < -limit) {
                    x *= -limit / z;
                    z = -limit;
                }
            }
            int attemptCount = 0;
            this.preGenChunks((World)world, x >> 4, z >> 4);
            do {
                BlockVec3 bv3 = null;
                if (world.field_73011_w instanceof WorldProviderAsteroids) {
                    bv3 = ((WorldProviderAsteroids)world.field_73011_w).getClosestAsteroidXZ(x, 0, z, true);
                }
                if (bv3 == null) continue;
                if (bv3.distanceSquared(new BlockVec3(x, 128, z)) > 25600) break;
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info((String)("Testing asteroid at x" + bv3.x + " y" + bv3.y + " z" + bv3.z));
                }
                this.loadChunksAround(bv3.x, bv3.z, 2, world.func_72863_F());
                this.loadChunksAround(bv3.x, bv3.z, -3, world.func_72863_F());
                if (this.goodAsteroidEntry((World)world, bv3.x, bv3.y, bv3.z)) {
                    return new Vector3((double)bv3.x, 310.0, (double)bv3.z);
                }
                if (this.goodAsteroidEntry((World)world, bv3.x + 2, bv3.y, bv3.z + 2)) {
                    return new Vector3((double)(bv3.x + 2), 310.0, (double)(bv3.z + 2));
                }
                if (this.goodAsteroidEntry((World)world, bv3.x + 2, bv3.y, bv3.z - 2)) {
                    return new Vector3((double)(bv3.x + 2), 310.0, (double)(bv3.z - 2));
                }
                if (this.goodAsteroidEntry((World)world, bv3.x - 2, bv3.y, bv3.z - 2)) {
                    return new Vector3((double)(bv3.x - 2), 310.0, (double)(bv3.z - 2));
                }
                if (this.goodAsteroidEntry((World)world, bv3.x - 2, bv3.y, bv3.z + 2)) {
                    return new Vector3((double)(bv3.x - 2), 310.0, (double)(bv3.z + 2));
                }
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info((String)("Removing drilled out asteroid at x" + bv3.x + " z" + bv3.z));
                }
                ((WorldProviderAsteroids)world.field_73011_w).removeAsteroid(bv3.x, bv3.y, bv3.z);
            } while (++attemptCount < 5);
            GCLog.info((String)"Failed to find good large asteroid landing spot! Falling back to making a small one.");
            this.makeSmallLandingSpot((World)world, x, z);
            return new Vector3((double)x, 310.0, (double)z);
        }
        GCLog.severe((String)"Null player when teleporting to Asteroids!");
        return new Vector3(0.0, 310.0, 0.0);
    }

    private boolean goodAsteroidEntry(World world, int x, int yorig, int z) {
        for (int k = 208; k > 48; --k) {
            if (world.func_175623_d(new BlockPos(x, k, z)) || Math.abs(k - yorig) > 20) continue;
            for (int y = k + 2; y < 256; ++y) {
                if (world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == AsteroidBlocks.blockBasic) {
                    world.func_175698_g(new BlockPos(x, y, z));
                }
                if (world.func_180495_p(new BlockPos(x - 1, y, z)).func_177230_c() == AsteroidBlocks.blockBasic) {
                    world.func_175698_g(new BlockPos(x - 1, y, z));
                }
                if (world.func_180495_p(new BlockPos(x, y, z - 1)).func_177230_c() == AsteroidBlocks.blockBasic) {
                    world.func_175698_g(new BlockPos(x, y, z - 1));
                }
                if (world.func_180495_p(new BlockPos(x - 1, y, z - 1)).func_177230_c() != AsteroidBlocks.blockBasic) continue;
                world.func_175698_g(new BlockPos(x - 1, y, z - 1));
            }
            if (ConfigManagerCore.enableDebug) {
                GCLog.info((String)("Found asteroid at x" + x + " z" + z));
            }
            return true;
        }
        return false;
    }

    private void makeSmallLandingSpot(World world, int x, int z) {
        this.loadChunksAround(x, z, -1, (ChunkProviderServer)world.func_72863_F());
        for (int k = 255; k > 48; --k) {
            if (!world.func_175623_d(new BlockPos(x, k, z))) {
                this.makePlatform(world, x, k - 1, z);
                return;
            }
            if (!world.func_175623_d(new BlockPos(x - 1, k, z))) {
                this.makePlatform(world, x - 1, k - 1, z);
                return;
            }
            if (!world.func_175623_d(new BlockPos(x - 1, k, z - 1))) {
                this.makePlatform(world, x - 1, k - 1, z - 1);
                return;
            }
            if (world.func_175623_d(new BlockPos(x, k, z - 1))) continue;
            this.makePlatform(world, x, k - 1, z - 1);
            return;
        }
        this.makePlatform(world, x, 48 + world.field_73012_v.nextInt(128), z);
    }

    private void loadChunksAround(int x, int z, int i, ChunkProviderServer cp) {
        cp.func_186028_c(x >> 4, z >> 4);
        if (x + i >> 4 != x >> 4) {
            cp.func_186028_c(x + i >> 4, z >> 4);
            if (z + i >> 4 != z >> 4) {
                cp.func_186028_c(x >> 4, z + i >> 4);
                cp.func_186028_c(x + i >> 4, z + i >> 4);
            }
        } else if (z + i >> 4 != z >> 4) {
            cp.func_186028_c(x >> 4, z + i >> 4);
        }
    }

    private void makePlatform(World world, int x, int y, int z) {
        int zz;
        int xx;
        for (xx = -3; xx < 3; ++xx) {
            for (zz = -3; zz < 3; ++zz) {
                if (xx == -3 && (zz == -3 || zz == 2) || xx == 2 && (zz == -3 || zz == 2)) continue;
                this.doBlock(world, x + xx, y, z + zz);
            }
        }
        for (xx = -2; xx < 2; ++xx) {
            for (zz = -2; zz < 2; ++zz) {
                this.doBlock(world, x + xx, y - 1, z + zz);
            }
        }
        this.doBlock(world, x - 1, y - 2, z - 1);
        this.doBlock(world, x - 1, y - 2, z);
        this.doBlock(world, x, y - 2, z);
        this.doBlock(world, x, y - 2, z - 1);
    }

    private void doBlock(World world, int x, int y, int z) {
        int meta = (int)(world.field_73012_v.nextFloat() * 1.5f);
        if (world.func_175623_d(new BlockPos(x, y, z))) {
            world.func_180501_a(new BlockPos(x, y, z), AsteroidBlocks.blockBasic.func_176203_a(meta), 2);
        }
    }

    public Vector3 getEntitySpawnLocation(WorldServer world, Entity entity) {
        return new Vector3(entity.field_70165_t, ConfigManagerCore.disableLander ? 250.0 : 900.0, entity.field_70161_v);
    }

    public Vector3 getParaChestSpawnLocation(WorldServer world, EntityPlayerMP player, Random rand) {
        return null;
    }

    private void preGenChunks(World w, int cx, int cz) {
        this.preGenChunk(w, cx, cz);
        for (int r = 1; r < 3; ++r) {
            int xmin = cx - r;
            int xmax = cx + r;
            int zmin = cz - r;
            int zmax = cz + r;
            for (int i = -r; i < r; ++i) {
                this.preGenChunk(w, xmin, cz + i);
                this.preGenChunk(w, xmax, cz - i);
                this.preGenChunk(w, cx - i, zmin);
                this.preGenChunk(w, cx + i, zmax);
            }
        }
    }

    private void preGenChunk(World w, int chunkX, int chunkZ) {
        w.func_72964_e(chunkX, chunkZ);
    }

    public void onSpaceDimensionChanged(World newWorld, EntityPlayerMP player, boolean ridingAutoRocket) {
        GCPlayerStats stats;
        if (!ridingAutoRocket && player != null && (stats = GCPlayerStats.get((Entity)player)).getTeleportCooldown() <= 0) {
            if (player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = false;
            }
            if (!newWorld.field_72995_K) {
                EntityEntryPod entryPod = new EntityEntryPod(player);
                boolean previous = CompatibilityManager.forceLoadChunks((WorldServer)((WorldServer)newWorld));
                entryPod.field_98038_p = true;
                newWorld.func_72838_d((Entity)entryPod);
                CompatibilityManager.forceLoadChunksEnd((WorldServer)((WorldServer)newWorld), (boolean)previous);
            }
            stats.setTeleportCooldown(10);
        }
    }

    public void setupAdventureSpawn(EntityPlayerMP player) {
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(GCItems.schematic, 1, 1));
        SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(MarsItems.schematic, 1, 0));
        SchematicRegistry.unlockNewPage((EntityPlayerMP)player, (ItemStack)new ItemStack(MarsItems.schematic, 1, 2));
        NonNullList rocketStacks = NonNullList.func_191196_a();
        stats.setFuelLevel(1000);
        rocketStacks.add((Object)new ItemStack(GCItems.oxMask));
        rocketStacks.add((Object)new ItemStack(GCItems.oxygenGear));
        rocketStacks.add((Object)new ItemStack(GCItems.oxTankMedium));
        rocketStacks.add((Object)new ItemStack(GCItems.oxTankHeavy));
        rocketStacks.add((Object)new ItemStack(GCItems.oxTankHeavy));
        rocketStacks.add((Object)new ItemStack(AsteroidsItems.canisterLOX));
        rocketStacks.add((Object)new ItemStack(AsteroidsItems.canisterLOX));
        rocketStacks.add((Object)new ItemStack(AsteroidsItems.canisterLOX));
        rocketStacks.add((Object)new ItemStack(AsteroidsItems.basicItem, 32, 7));
        rocketStacks.add((Object)new ItemStack(Blocks.field_150410_aZ, 16));
        rocketStacks.add((Object)new ItemStack(Blocks.field_150344_f, 32, 2));
        rocketStacks.add((Object)new ItemStack(MarsItems.marsItemBasic, 16, 2));
        rocketStacks.add((Object)new ItemStack(GCItems.basicItem, 8, 13));
        rocketStacks.add((Object)new ItemStack(GCItems.basicItem, 2, 1));
        rocketStacks.add((Object)new ItemStack(GCItems.foodItem, 16, 0));
        rocketStacks.add((Object)new ItemStack(Items.field_151110_aK, 12));
        ItemStack spawnEgg = new ItemStack(Items.field_151063_bx, 2);
        ResourceLocation name = EntityList.func_191306_a(EntityCow.class);
        ItemMonsterPlacer.func_185078_a((ItemStack)spawnEgg, (ResourceLocation)name);
        rocketStacks.add((Object)spawnEgg);
        rocketStacks.add((Object)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn, 4), (PotionType)PotionTypes.field_185235_g));
        rocketStacks.add((Object)new ItemStack(MarsBlocks.machine, 1, 4));
        rocketStacks.add((Object)new ItemStack(MarsItems.rocketMars, 1, IRocketType.EnumRocketType.INVENTORY36.ordinal()));
        stats.setRocketStacks(rocketStacks);
    }
}

