/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.subtile.ISpecialFlower;
import vazkii.botania.common.Botania;
import vazkii.botania.common.item.ItemMod;

public class ItemTerraformRod
extends ItemMod
implements IManaUsingItem,
IBlockProvider {
    private static final int COST_PER = 55;
    private static final List<String> validBlocks = ImmutableList.of((Object)"stone", (Object)"dirt", (Object)"grass", (Object)"sand", (Object)"gravel", (Object)"hardenedClay", (Object)"snowLayer", (Object)"mycelium", (Object)"podzol", (Object)"sandstone", (Object)"blockDiorite", (Object)"stoneDiorite", (Object[])new String[]{"blockGranite", "stoneGranite", "blockAndesite", "stoneAndesite", "marble", "blockMarble", "limestone", "blockLimestone"});

    public ItemTerraformRod() {
        super("terraformRod");
        this.func_77625_d(1);
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        if (count != this.func_77626_a(stack) && count % 10 == 0 && living instanceof EntityPlayer) {
            this.terraform(stack, living.field_70170_p, (EntityPlayer)living);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private void terraform(ItemStack par1ItemStack, World world, EntityPlayer player) {
        int range = IManaProficiencyArmor.Helper.hasProficiency(player, par1ItemStack) ? 22 : 16;
        BlockPos startCenter = new BlockPos((Entity)player).func_177977_b();
        if (startCenter.func_177956_o() < world.func_181545_F()) {
            return;
        }
        ArrayList<CoordsWithBlock> blocks = new ArrayList<CoordsWithBlock>();
        block0: for (Object pos : BlockPos.func_177975_b((BlockPos)startCenter.func_177982_a(-range, -range, -range), (BlockPos)startCenter.func_177982_a(range, range, range))) {
            int[] ids;
            IBlockState state = world.func_180495_p((BlockPos)pos);
            if (state.func_177230_c() == Blocks.field_150350_a || Item.func_150898_a((Block)state.func_177230_c()) == Items.field_190931_a) continue;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)))) {
                if (!validBlocks.contains(OreDictionary.getOreName((int)id))) continue;
                ArrayList<BlockPos> airBlocks = new ArrayList<BlockPos>();
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    BlockPos pos_ = pos.func_177972_a(dir);
                    Block block_ = world.func_180495_p(pos_).func_177230_c();
                    if (!block_.isAir(world.func_180495_p(pos_), (IBlockAccess)world, pos_) && !block_.func_176200_f((IBlockAccess)world, pos_) && (!(block_ instanceof BlockFlower) || block_ instanceof ISpecialFlower) && block_ != Blocks.field_150398_cm) continue;
                    airBlocks.add(pos_);
                }
                if (airBlocks.isEmpty()) continue block0;
                if (pos.func_177956_o() > startCenter.func_177956_o()) {
                    blocks.add(new CoordsWithBlock((BlockPos)pos, Blocks.field_150350_a));
                    continue block0;
                }
                for (BlockPos coords : airBlocks) {
                    if (world.func_180495_p(coords.func_177977_b()).func_177230_c() == Blocks.field_150350_a) continue;
                    blocks.add(new CoordsWithBlock(coords, Blocks.field_150346_d));
                }
                continue block0;
            }
        }
        int cost = 55 * blocks.size();
        if (world.field_72995_K || ManaItemHandler.requestManaExactForTool(par1ItemStack, player, cost, true)) {
            if (!world.field_72995_K) {
                for (CoordsWithBlock block : blocks) {
                    world.func_175656_a((BlockPos)block, block.block.func_176223_P());
                }
            }
            if (!blocks.isEmpty()) {
                int i;
                for (i = 0; i < 10; ++i) {
                    world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187755_eF, SoundCategory.BLOCKS, 1.0f, 0.4f);
                }
                for (i = 0; i < 120; ++i) {
                    Botania.proxy.sparkleFX((double)(startCenter.func_177958_n() - range) + (double)(range * 2) * Math.random(), (double)(startCenter.func_177956_o() + 2) + (Math.random() - 0.5) * 2.0, (double)(startCenter.func_177952_p() - range) + (double)(range * 2) * Math.random(), 0.35f, 0.2f, 0.05f, 2.0f, 5);
                }
            }
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public boolean provideBlock(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta, boolean doit) {
        if (block == Blocks.field_150346_d && meta == 0) {
            return !doit || ManaItemHandler.requestManaExactForTool(requestor, player, 75, true);
        }
        return false;
    }

    @Override
    public int getBlockCount(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta) {
        if (block == Blocks.field_150346_d && meta == 0) {
            return -1;
        }
        return 0;
    }

    private static class CoordsWithBlock
    extends BlockPos {
        private final Block block;

        private CoordsWithBlock(BlockPos pos, Block block) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.block = block;
        }
    }
}

