/*
 * Decompiled with CFR 0.152.
 */
package nc.capability.radiation.entity;

import nc.capability.radiation.entity.IEntityRads;
import nc.config.NCConfig;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class PlayerRads
implements IEntityRads {
    protected double maxRads = NCConfig.max_player_rads;
    private double totalRads = 0.0;
    private double radiationLevel = 0.0;
    private double internalRadiationResistance = 0.0;
    private double externalRadiationResistance = 0.0;
    private boolean radXUsed = false;
    private boolean radXWoreOff = false;
    private double radawayBuffer = 0.0;
    private double radawayBufferSlow = 0.0;
    private double poisonBuffer = 0.0;
    private boolean consumed = false;
    private double radawayCooldown = 0.0;
    private double recentRadawayAddition = 0.0;
    private double radXCooldown = 0.0;
    private double recentRadXAddition = 0.0;
    private double recentPoisonAddition = 0.0;
    private double radiationImmunityTime = 0.0;
    private boolean radiationImmunityStage = false;
    private boolean shouldWarn = false;

    @Override
    public NBTTagCompound writeNBT(IEntityRads instance, EnumFacing side, NBTTagCompound nbt) {
        nbt.func_74780_a("totalRads", this.totalRads);
        nbt.func_74780_a("radiationLevel", this.radiationLevel);
        nbt.func_74780_a("internalRadiationResistance", this.internalRadiationResistance);
        nbt.func_74780_a("externalRadiationResistance", this.externalRadiationResistance);
        nbt.func_74757_a("radXUsed", this.radXUsed);
        nbt.func_74757_a("radXWoreOff", this.radXWoreOff);
        nbt.func_74780_a("radawayBuffer", this.radawayBuffer);
        nbt.func_74780_a("radawayBufferSlow", this.radawayBufferSlow);
        nbt.func_74780_a("poisonBuffer", this.poisonBuffer);
        nbt.func_74757_a("consumed", this.consumed);
        nbt.func_74780_a("radawayCooldown", this.radawayCooldown);
        nbt.func_74780_a("recentRadawayAddition", this.recentRadawayAddition);
        nbt.func_74780_a("radXCooldown", this.radXCooldown);
        nbt.func_74780_a("recentRadXAddition", this.recentRadXAddition);
        nbt.func_74780_a("recentPoisonAddition", this.recentPoisonAddition);
        nbt.func_74780_a("radiationImmunityTime", this.radiationImmunityTime);
        nbt.func_74757_a("radiationImmunityStage", this.radiationImmunityStage);
        nbt.func_74757_a("shouldWarn", this.shouldWarn);
        return nbt;
    }

    @Override
    public void readNBT(IEntityRads instance, EnumFacing side, NBTTagCompound nbt) {
        this.totalRads = nbt.func_74769_h("totalRads");
        this.radiationLevel = nbt.func_74769_h("radiationLevel");
        this.internalRadiationResistance = nbt.func_74769_h("internalRadiationResistance");
        this.externalRadiationResistance = nbt.func_74769_h("externalRadiationResistance");
        this.radXUsed = nbt.func_74767_n("radXUsed");
        this.radXWoreOff = nbt.func_74767_n("radXWoreOff");
        this.radawayBuffer = nbt.func_74769_h("radawayBuffer");
        this.radawayBufferSlow = nbt.func_74769_h("radawayBufferSlow");
        this.poisonBuffer = nbt.func_74769_h("poisonBuffer");
        this.consumed = nbt.func_74767_n("consumed");
        this.radawayCooldown = nbt.func_74769_h("radawayCooldown");
        this.recentRadawayAddition = nbt.func_74769_h("recentRadawayAddition");
        this.radXCooldown = nbt.func_74769_h("radXCooldown");
        this.recentRadXAddition = nbt.func_74769_h("recentRadXAddition");
        this.recentPoisonAddition = nbt.func_74769_h("recentPoisonAddition");
        this.radiationImmunityTime = nbt.func_74769_h("radiationImmunityTime");
        this.radiationImmunityStage = nbt.func_74767_n("radiationImmunityStage");
        this.shouldWarn = nbt.func_74767_n("shouldWarn");
    }

    @Override
    public double getTotalRads() {
        return this.totalRads;
    }

    @Override
    public void setTotalRads(double newTotalRads, boolean useImmunity) {
        if (!useImmunity || !this.isImmune()) {
            this.totalRads = MathHelper.func_151237_a((double)newTotalRads, (double)0.0, (double)this.maxRads);
        }
    }

    @Override
    public double getMaxRads() {
        return this.maxRads;
    }

    @Override
    public double getRadiationLevel() {
        return this.radiationLevel;
    }

    @Override
    public void setRadiationLevel(double newRadiationLevel) {
        this.radiationLevel = Math.max(newRadiationLevel, 0.0);
    }

    @Override
    public double getInternalRadiationResistance() {
        return this.internalRadiationResistance;
    }

    @Override
    public void setInternalRadiationResistance(double newInternalRadiationResistance) {
        this.internalRadiationResistance = newInternalRadiationResistance;
    }

    @Override
    public double getExternalRadiationResistance() {
        return this.externalRadiationResistance;
    }

    @Override
    public void setExternalRadiationResistance(double newExternalRadiationResistance) {
        this.externalRadiationResistance = Math.max(newExternalRadiationResistance, 0.0);
    }

    @Override
    public boolean getRadXUsed() {
        return this.radXUsed;
    }

    @Override
    public void setRadXUsed(boolean radXUsed) {
        this.radXUsed = radXUsed;
    }

    @Override
    public boolean getRadXWoreOff() {
        return this.radXWoreOff;
    }

    @Override
    public void setRadXWoreOff(boolean radXWoreOff) {
        this.radXWoreOff = radXWoreOff;
    }

    @Override
    public double getRadawayBuffer(boolean slow) {
        return slow ? this.radawayBufferSlow : this.radawayBuffer;
    }

    @Override
    public void setRadawayBuffer(boolean slow, double newBuffer) {
        if (slow) {
            this.radawayBufferSlow = Math.max(newBuffer, 0.0);
        } else {
            this.radawayBuffer = Math.max(newBuffer, 0.0);
        }
    }

    @Override
    public double getPoisonBuffer() {
        return this.poisonBuffer;
    }

    @Override
    public void setPoisonBuffer(double newBuffer) {
        this.poisonBuffer = Math.max(newBuffer, 0.0);
    }

    @Override
    public boolean getConsumedMedicine() {
        return this.consumed;
    }

    @Override
    public void setConsumedMedicine(boolean consumed) {
        this.consumed = consumed;
    }

    @Override
    public double getRadawayCooldown() {
        return this.radawayCooldown;
    }

    @Override
    public void setRadawayCooldown(double cooldown) {
        this.radawayCooldown = Math.max(cooldown, 0.0);
    }

    @Override
    public boolean canConsumeRadaway() {
        return !this.consumed && this.radawayCooldown <= 0.0;
    }

    @Override
    public double getRecentRadawayAddition() {
        return this.recentRadawayAddition;
    }

    @Override
    public void setRecentRadawayAddition(double newRecentRadawayAddition) {
        this.recentRadawayAddition = Math.max(this.recentRadawayAddition, newRecentRadawayAddition);
    }

    @Override
    public void resetRecentRadawayAddition() {
        this.recentRadawayAddition = 0.0;
    }

    @Override
    public double getRadXCooldown() {
        return this.radXCooldown;
    }

    @Override
    public void setRadXCooldown(double cooldown) {
        this.radXCooldown = Math.max(cooldown, 0.0);
    }

    @Override
    public boolean canConsumeRadX() {
        return !this.consumed && this.radXCooldown <= 0.0;
    }

    @Override
    public double getRecentRadXAddition() {
        return this.recentRadXAddition;
    }

    @Override
    public void setRecentRadXAddition(double newRecentRadXAddition) {
        this.recentRadXAddition = Math.max(this.recentRadXAddition, newRecentRadXAddition);
    }

    @Override
    public void resetRecentRadXAddition() {
        this.recentRadXAddition = 0.0;
    }

    @Override
    public double getRecentPoisonAddition() {
        return this.recentPoisonAddition;
    }

    @Override
    public void setRecentPoisonAddition(double newRecentPoisonAddition) {
        this.recentPoisonAddition = Math.max(this.recentPoisonAddition, newRecentPoisonAddition);
    }

    @Override
    public void resetRecentPoisonAddition() {
        this.recentPoisonAddition = 0.0;
    }

    @Override
    public double getRadiationImmunityTime() {
        return this.radiationImmunityTime;
    }

    @Override
    public void setRadiationImmunityTime(double newRadiationImmunityTime) {
        this.radiationImmunityTime = Math.max(newRadiationImmunityTime, 0.0);
    }

    @Override
    public boolean getRadiationImmunityStage() {
        return this.radiationImmunityStage;
    }

    @Override
    public void setRadiationImmunityStage(boolean newRadiationImmunityStage) {
        this.radiationImmunityStage = newRadiationImmunityStage;
    }

    @Override
    public boolean getShouldWarn() {
        return this.shouldWarn;
    }

    @Override
    public void setShouldWarn(boolean shouldWarn) {
        this.shouldWarn = shouldWarn;
    }
}

