/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Maps;
import cubex2.cs4.api.ContentHelper;
import cubex2.cs4.api.InitPhase;
import cubex2.cs4.api.RecipeInput;
import cubex2.cs4.api.WrappedItemStack;
import cubex2.cs4.data.SimpleContent;
import cubex2.cs4.plugins.jei.JEICompatRegistry;
import cubex2.cs4.plugins.vanilla.DamageableShapedOreRecipe;
import cubex2.cs4.plugins.vanilla.crafting.CraftingManagerCS4;
import cubex2.cs4.util.ItemHelper;
import cubex2.cs4.util.ReflectionHelper;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

class ShapedRecipe
extends SimpleContent {
    String[] shape;
    Map<Character, RecipeInput> items = Maps.newHashMap();
    WrappedItemStack result;
    boolean mirrored = true;
    boolean remove = false;
    ResourceLocation recipeList = new ResourceLocation("minecraft", "vanilla");
    Map<Character, Integer> damage = Maps.newHashMap();

    ShapedRecipe() {
    }

    @Override
    protected void doInit(InitPhase phase, ContentHelper helper) {
        if (this.remove) {
            if (!this.recipeList.toString().equals("minecraft:vanilla")) {
                this.removeRecipe(CraftingManagerCS4.getRecipes(this.recipeList));
            }
        } else {
            this.addRecipe();
        }
    }

    @Override
    protected boolean isReady() {
        if (this.result != null && !this.result.isItemLoaded()) {
            return false;
        }
        return this.items.values().stream().allMatch(input -> input.isOreClass() || input.isItemStack() && input.getStack().isItemLoaded());
    }

    void addRecipe() {
        Class<DamageableShapedOreRecipe> recipeClass = JEICompatRegistry.getShapedCraftingRecipeClass(this.recipeList);
        Constructor<DamageableShapedOreRecipe> constructor = ReflectionHelper.getConstructor(recipeClass, ResourceLocation.class, int[].class, ItemStack.class, Object[].class);
        int[] damageAmounts = ShapedRecipe.createDamageAmounts(this.getRecipeWidth(), this.getRecipeHeight(), this.shape, this.damage);
        DamageableShapedOreRecipe recipe = ReflectionHelper.newInstance(constructor, null, damageAmounts, this.result.getItemStack(), this.getInputForRecipe());
        if (recipe != null) {
            recipe.setMirrored(this.mirrored);
            CraftingManagerCS4.addRecipe(this.recipeList, (IRecipe)recipe);
        }
    }

    boolean removeRecipe(Collection<IRecipe> from) {
        if (this.items.size() == 0) {
            return this.removeWithResult(from);
        }
        if (this.result == null) {
            return this.removeWithInput(from);
        }
        return this.removeWithBoth(from);
    }

    private boolean removeWithResult(Collection<IRecipe> from) {
        return from.removeIf(this::matchesOutput);
    }

    private boolean removeWithInput(Collection<IRecipe> from) {
        List recipes = from.stream().filter(this::matchesInput).collect(Collectors.toList());
        return from.removeAll(recipes);
    }

    private boolean removeWithBoth(Collection<IRecipe> from) {
        List recipes = from.stream().filter(this::matchesOutput).filter(this::matchesInput).collect(Collectors.toList());
        return from.removeAll(recipes);
    }

    private boolean matchesOutput(IRecipe recipe) {
        return OreDictionary.itemMatches((ItemStack)recipe.func_77571_b(), (ItemStack)this.result.getItemStack(), (boolean)false);
    }

    private boolean matchesInput(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            return this.matchesInput((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return this.matchesInput((ShapedOreRecipe)recipe);
        }
        return false;
    }

    private boolean matchesInput(ShapedRecipes recipe) {
        if (this.isOreRecipe()) {
            return false;
        }
        if (recipe.field_77576_b != this.getRecipeWidth()) {
            return false;
        }
        if (recipe.field_77577_c != this.getRecipeHeight()) {
            return false;
        }
        return this.isSameInputs((NonNullList<Ingredient>)recipe.field_77574_d);
    }

    private boolean matchesInput(ShapedOreRecipe recipe) {
        if (recipe.getWidth() != this.getRecipeWidth()) {
            return false;
        }
        if (recipe.getHeight() != this.getRecipeHeight()) {
            return false;
        }
        return this.isSameInputs((NonNullList<Ingredient>)recipe.func_192400_c());
    }

    private boolean isSameInputs(NonNullList<Ingredient> targetInput) {
        Object[] sourceInput = this.getRecipeInput();
        for (int i = 0; i < targetInput.size(); ++i) {
            Object source;
            Ingredient target = (Ingredient)targetInput.get(i);
            if (ItemHelper.isSameRecipeInput(target, source = sourceInput[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isOreRecipe() {
        return this.items.values().stream().anyMatch(RecipeInput::isOreClass);
    }

    private int getRecipeWidth() {
        return this.shape[0].length();
    }

    private int getRecipeHeight() {
        return this.shape.length;
    }

    Object[] getInputForRecipe() {
        Object[] result = new Object[this.shape.length + this.items.size() * 2];
        System.arraycopy(this.shape, 0, result, 0, this.shape.length);
        int i = this.shape.length;
        for (Map.Entry<Character, RecipeInput> entry : this.items.entrySet()) {
            RecipeInput input = entry.getValue();
            result[i] = entry.getKey();
            result[i + 1] = input.isOreClass() ? input.getOreClass().getOreName() : input.getStack().getItemStack();
            i += 2;
        }
        return result;
    }

    Object[] getRecipeInput() {
        Object[] result = new Object[this.getRecipeWidth() * this.getRecipeHeight()];
        for (int row = 0; row < this.shape.length; ++row) {
            for (int col = 0; col < this.shape[0].length(); ++col) {
                RecipeInput input = this.items.get(Character.valueOf(this.shape[row].charAt(col)));
                int index = col + row * this.shape[0].length();
                result[index] = input != null ? (input.isOreClass() ? OreDictionary.getOres((String)input.getOreClass().getOreName()) : input.getStack().getItemStack()) : ItemStack.field_190927_a;
            }
        }
        return result;
    }

    static int[] createDamageAmounts(int width, int height, String[] shape, Map<Character, Integer> damage) {
        int[] result = new int[width * height];
        for (int row = 0; row < shape.length; ++row) {
            for (int col = 0; col < shape[0].length(); ++col) {
                int amount = damage.getOrDefault(Character.valueOf(shape[row].charAt(col)), 0);
                int index = col + row * shape[0].length();
                result[index] = amount;
            }
        }
        return result;
    }
}

