/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.util;

import cofh.thermaldynamics.init.TDItems;
import com.google.gson.JsonObject;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CoverBlacklistCommand
implements ICommand {
    public String func_71517_b() {
        return "td_blacklist_cover";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Gets the json object to blacklist the cover in hand.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        ItemStack stack;
        boolean wild = false;
        if (args.length >= 1) {
            if (args[0].equalsIgnoreCase("true")) {
                wild = true;
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /td_blacklist_cover [true]"));
                sender.func_145747_a((ITextComponent)new TextComponentString("True specifies to ignore metadata."));
                return;
            }
        }
        if ((stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca()).func_190926_b() || stack.func_77973_b() != TDItems.itemCover) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You need to be holding a cover in your main hand to use this command."));
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Meta", 1) || !nbt.func_150297_b("Block", 8)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid cover."));
            return;
        }
        byte meta = nbt.func_74771_c("Meta");
        Block block = Block.func_149684_b((String)nbt.func_74779_i("Block"));
        if (block == Blocks.field_150350_a) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid cover."));
            return;
        }
        IBlockState state = block.func_176203_a((int)meta);
        JsonObject object = new JsonObject();
        object.addProperty("block", block.getRegistryName().toString());
        if (wild) {
            object.addProperty("meta", Boolean.valueOf(false));
        } else {
            object.addProperty("meta", (Number)state.func_177230_c().func_176201_c(state));
        }
        String json = object.toString();
        sender.func_145747_a((ITextComponent)new TextComponentString("Config entry json: " + json));
        StringSelection sel = new StringSelection(json);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
        sender.func_145747_a((ITextComponent)new TextComponentString("Copied json to clipboard."));
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }
}

