/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32;
import p455w0rdslib.util.EasyMappings;
import p455w0rdslib.util.EntityUtils;
import p455w0rdslib.util.ImageUtils;
import p455w0rdslib.util.MCUtils;
import p455w0rdslib.util.MathUtils;
import p455w0rdslib.util.PlayerUtils;
import p455w0rdslib.util.Quat;
import p455w0rdslib.util.Vector3;

@SideOnly(value=Side.CLIENT)
public class RenderUtils {
    public static int highlightTextTime = 0;
    public static int highlightTextYOffset = 0;
    public static String highlightText = "";
    public static float highlightTextScale = 1.0f;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    public static Vector3[] sideVec = new Vector3[]{new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
    public static Vector3[] sidePos = new Vector3[]{new Vector3(0.5, 0.0, 0.5), new Vector3(0.5, 1.0, 0.5), new Vector3(0.5, 0.5, 0.0), new Vector3(0.5, 0.5, 1.0), new Vector3(0.0, 0.5, 0.5), new Vector3(1.0, 0.5, 0.5)};
    public static int renderTextureSize = 128;
    public static int framebufferID = -1;
    public static int depthbufferID = -1;
    public static int textureID = -1;
    private static IntBuffer lastViewport;
    private static int lastTexture;
    private static int lastFramebuffer;

    public static ItemModelMesher getMesher() {
        return RenderUtils.getRenderItem().func_175037_a();
    }

    public static Minecraft mc() {
        return MCUtils.mc();
    }

    public static BlockModelShapes getBlockModelShapes() {
        return RenderUtils.getBlockRendererDispatcher().func_175023_a();
    }

    public static ItemRenderer getItemRenderer() {
        return RenderUtils.mc().func_175597_ag();
    }

    public static RenderPlayer getRenderPlayer(AbstractClientPlayer player) {
        return (RenderPlayer)RenderUtils.getRenderManager().func_78713_a((Entity)player);
    }

    public static RenderItem getRenderItem() {
        return RenderUtils.mc().func_175599_af();
    }

    public static BlockRendererDispatcher getBlockRendererDispatcher() {
        return RenderUtils.mc().func_175602_ab();
    }

    public static RenderManager getRenderManager() {
        return RenderUtils.mc().func_175598_ae();
    }

    public static TextureManager getTextureManager() {
        return RenderUtils.mc().func_110434_K();
    }

    public static FontRenderer getFontRenderer() {
        return RenderUtils.mc().field_71466_p;
    }

    public static TextureManager getRenderEngine() {
        return RenderUtils.mc().field_71446_o;
    }

    public static TextureMap getBlocksTextureMap() {
        return RenderUtils.mc().func_147117_R();
    }

    public static IReloadableResourceManager getResourceManager() {
        return (IReloadableResourceManager)RenderUtils.mc().func_110442_L();
    }

    public static TextureAtlasSprite getSprite(String spritePath) {
        return RenderUtils.getBlocksTextureMap().func_110572_b(spritePath);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation location) {
        return RenderUtils.getSprite(location.toString());
    }

    public static float getPartialTicks() {
        return RenderUtils.mc().func_184121_ak();
    }

    public static void bindTexture(ResourceLocation location) {
        RenderUtils.getRenderEngine().func_110577_a(location);
    }

    public static void renderHighlightText(int yOffset, String text) {
        RenderUtils.renderHighlightText(yOffset, text, 1.0f);
    }

    public static void renderHighlightText(int yOffset, String text, float scale) {
        ScaledResolution scaledRes = new ScaledResolution(RenderUtils.mc());
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71442_b == null) {
            return;
        }
        String s = TextFormatting.ITALIC + "" + text;
        int j = scaledRes.func_78328_b() - yOffset;
        if (!mc.field_71442_b.func_78755_b()) {
            j += 14;
        }
        int k = 255;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        float i = ((float)scaledRes.func_78326_a() - (float)RenderUtils.getFontRenderer().func_78256_a(text) * scale) / 2.0f;
        RenderUtils.getFontRenderer().func_175065_a(s, i / scale, (float)j / scale, -1, true);
        GlStateManager.func_179121_F();
    }

    public static void renderHighlightTextTimed(int yOffset, String text, float scale, int ticks) {
        if (highlightTextTime <= 0) {
            highlightTextTime = ticks;
            highlightText = text;
            highlightTextScale = scale;
            highlightTextYOffset = yOffset;
        }
    }

    public static void renderHighlightTextTimed() {
        if (highlightTextTime > 0 && !highlightText.isEmpty()) {
            RenderUtils.renderHighlightText(highlightTextYOffset, highlightText, highlightTextScale);
            --highlightTextTime;
        } else {
            highlightTextTime = 0;
            highlightTextYOffset = 0;
            highlightText = "";
            highlightTextScale = 1.0f;
        }
    }

    public static void renderBeamHit(@Nonnull ResourceLocation texture, Vector3 pos, float partialTicks, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
        GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179129_p();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        RenderUtils.bindTexture(texture);
        double iX = pos.x;
        double iY = pos.y;
        double iZ = pos.z;
        RenderUtils.renderFacingQuad(iX, iY, iZ, partialTicks, scale, 0.0f, 0.0, 0.0, 1.0, 1.0);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    public static void renderFacingQuad(double px, double py, double pz, float partialTicks, float scale, float angle, double u, double v, double uLength, double vLength) {
        float arX = ActiveRenderInfo.func_178808_b();
        float arZ = ActiveRenderInfo.func_178803_d();
        float arYZ = ActiveRenderInfo.func_178805_e();
        float arXY = ActiveRenderInfo.func_178807_f();
        float arXZ = ActiveRenderInfo.func_178809_c();
        Entity e = EntityUtils.getRenderViewEntity();
        if (e == null) {
            e = PlayerUtils.getPlayer();
        }
        double iPX = e.field_70169_q + (e.field_70165_t - e.field_70169_q) * (double)partialTicks;
        double iPY = e.field_70167_r + (e.field_70163_u - e.field_70167_r) * (double)partialTicks;
        double iPZ = e.field_70166_s + (e.field_70161_v - e.field_70166_s) * (double)partialTicks;
        Vector3 v1 = new Vector3(-arX * scale - arYZ * scale, -arXZ * scale, -arZ * scale - arXY * scale);
        Vector3 v2 = new Vector3(-arX * scale + arYZ * scale, arXZ * scale, -arZ * scale + arXY * scale);
        Vector3 v3 = new Vector3(arX * scale + arYZ * scale, arXZ * scale, arZ * scale + arXY * scale);
        Vector3 v4 = new Vector3(arX * scale - arYZ * scale, -arXZ * scale, arZ * scale - arXY * scale);
        if (angle != 0.0f) {
            Vector3 pvec = new Vector3(iPX, iPY, iPZ);
            Vector3 tvec = new Vector3(px, py, pz);
            Vector3 qvec = pvec.subtract(tvec).normalize();
            Vector3.Quat q = Vector3.Quat.buildQuatFrom3DVector(qvec, angle);
            q.rotateWithMagnitude(v1);
            q.rotateWithMagnitude(v2);
            q.rotateWithMagnitude(v3);
            q.rotateWithMagnitude(v4);
        }
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(px + v1.getX() - iPX, py + v1.getY() - iPY, pz + v1.getZ() - iPZ).func_187315_a(u, v + vLength).func_181675_d();
        vb.func_181662_b(px + v2.getX() - iPX, py + v2.getY() - iPY, pz + v2.getZ() - iPZ).func_187315_a(u + uLength, v + vLength).func_181675_d();
        vb.func_181662_b(px + v3.getX() - iPX, py + v3.getY() - iPY, pz + v3.getZ() - iPZ).func_187315_a(u + uLength, v).func_181675_d();
        vb.func_181662_b(px + v4.getX() - iPX, py + v4.getY() - iPY, pz + v4.getZ() - iPZ).func_187315_a(u, v).func_181675_d();
        t.func_78381_a();
    }

    public static double interpolate(double oldP, double newP, float partialTicks) {
        if (oldP == newP) {
            return oldP;
        }
        return oldP + (newP - oldP) * (double)partialTicks;
    }

    public static void renderCircleBeamPoint2Point(Vector3 sourcePos, Vector3 destPos, float partialTicks, @Nonnull int red, @Nonnull int green, @Nonnull int blue, @Nonnull int alpha, double size, @Nullable ResourceLocation texture) {
        Entity entity = EntityUtils.getRenderViewEntity();
        if (entity == null) {
            entity = PlayerUtils.getPlayer();
        }
        float[] colors = new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f};
        float tr = 1.0f;
        tr = (float)((double)tr * 0.6);
        tr *= colors[3];
        GlStateManager.func_179094_E();
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)(colors[0] * tr), (float)(colors[1] * tr), (float)(colors[2] * tr), (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
        RenderUtils.bindTexture(texture == null ? TileEntityBeaconRenderer.field_147523_b : texture);
        for (int i = 0; i < 180; ++i) {
            RenderUtils.renderCurrentTextureAroundAxis(Math.toRadians(i), sourcePos, destPos, size);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static void renderCurrentTextureAroundAxis(double angle, Vector3 sourcePos, Vector3 destPos, double size) {
        Vector3 aim = destPos.copy().subtract(sourcePos);
        Vector3 aimPerp = aim.copy().perpendicular().normalize();
        Vector3 perp = aimPerp.copy().rotate(angle, aim).normalize();
        Vector3 perpFrom = perp.copy().multiply(size);
        Vector3 perpTo = perp.multiply(size);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double u = 0.0;
        double v = 0.0;
        double uWidth = 1.0;
        double vHeight = 16.0;
        Vector3 vec = sourcePos.copy().add(perpFrom.copy().multiply(-1.0));
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(0.0, 16.0).func_181675_d();
        vec = sourcePos.copy().add(perpFrom);
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(1.0, 16.0).func_181675_d();
        vec = destPos.copy().add(perpTo);
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(1.0, 16.0).func_181675_d();
        vec = destPos.copy().add(perpTo.copy().multiply(-1.0));
        buf.func_181662_b(vec.getX(), vec.getY(), vec.getZ()).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_78381_a();
    }

    public static void renderSpiral(TextureAtlasSprite tex, int src, int dst, double start, double end, double time, double theta0, double x, double y, double z) {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tes.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_178969_c(x, y, z);
        Vector3[] last = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        Vector3[] next = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        double tess = 0.05;
        Vector3 a = RenderUtils.getPerp(src, dst);
        boolean rev = RenderUtils.sum(a.copy().crossProduct(RenderUtils.getPathNormal(src, dst, 0.0))) != RenderUtils.sum(sideVec[src]);
        for (double di = end; di <= start; di += 0.05) {
            Vector3 b = RenderUtils.getPathNormal(src, dst, di);
            Vector3 c = RenderUtils.getPath(src, dst, di);
            if (rev) {
                b.negate();
            }
            double r = (2.0 * di - time / 10.0 + theta0 + (double)(dst / 6)) * 2.0 * Math.PI;
            double sz = 0.1;
            Vector3 p = c.add(a.copy().multiply((double)MathUtils.sin((float)r) * 0.1)).add(b.copy().multiply((double)MathUtils.cos((float)r) * 0.1));
            double s1 = 0.02;
            double s2 = -0.02;
            next[0].set(p).add(a.x * 0.02 + b.x * 0.02, a.y * 0.02 + b.y * 0.02, a.z * 0.02 + b.z * 0.02);
            next[1].set(p).add(a.x * -0.02 + b.x * 0.02, a.y * -0.02 + b.y * 0.02, a.z * -0.02 + b.z * 0.02);
            next[2].set(p).add(a.x * -0.02 + b.x * -0.02, a.y * -0.02 + b.y * -0.02, a.z * -0.02 + b.z * -0.02);
            next[3].set(p).add(a.x * 0.02 + b.x * -0.02, a.y * 0.02 + b.y * -0.02, a.z * 0.02 + b.z * -0.02);
            if (di > end) {
                double u1 = tex.func_94214_a(Math.abs(di) * 16.0);
                double u2 = tex.func_94214_a(Math.abs(di - 0.05) * 16.0);
                for (int i = 0; i < 4; ++i) {
                    int j = (i + 1) % 4;
                    Vector3 axis = next[j].copy().subtract(next[i]);
                    double v1 = tex.func_94207_b(Math.abs(next[i].scalarProject(axis)) * 16.0);
                    double v2 = tex.func_94207_b(Math.abs(next[j].scalarProject(axis)) * 16.0);
                    vertexBuffer.func_181662_b(next[i].x, next[i].y, next[i].z).func_187315_a(u1, v1).func_181675_d();
                    vertexBuffer.func_181662_b(next[j].x, next[j].y, next[j].z).func_187315_a(u1, v2).func_181675_d();
                    vertexBuffer.func_181662_b(last[j].x, last[j].y, last[j].z).func_187315_a(u2, v2).func_181675_d();
                    vertexBuffer.func_181662_b(last[i].x, last[i].y, last[i].z).func_187315_a(u2, v1).func_181675_d();
                }
            }
            Vector3[] tmp = last;
            last = next;
            next = tmp;
        }
        tes.func_78381_a();
        vertexBuffer.func_178969_c(0.0, 0.0, 0.0);
    }

    private static double sum(Vector3 v) {
        return v.x + v.y + v.z;
    }

    public static Vector3 getPerp(int src, int dst) {
        if ((src ^ 1) == dst) {
            return sideVec[(src + 2) % 6].copy();
        }
        for (int i = 0; i < 3; ++i) {
            if (i == src / 2 || i == dst / 2) continue;
            return sideVec[i * 2].copy();
        }
        return null;
    }

    public static Vector3 getPath(int src, int dst, double d) {
        Vector3 v;
        if ((src ^ 1) == dst) {
            v = sideVec[src ^ 1].copy().multiply(d);
        } else {
            Vector3 vsrc = sideVec[src ^ 1];
            Vector3 vdst = sideVec[dst ^ 1];
            Vector3 a = vsrc.copy().multiply(0.3125);
            Vector3 b = vdst.copy().multiply(0.375);
            double sind = MathUtils.sin((float)(d * Math.PI / 2.0));
            double cosd = MathUtils.cos((float)(d * Math.PI / 2.0));
            v = a.multiply(sind).add(b.multiply(cosd - 1.0)).add(vsrc.copy().multiply(0.1875));
        }
        return v.add(sidePos[src]);
    }

    private static Vector3 getPathNormal(int srcSide, int dstSide, double d) {
        if ((srcSide ^ 1) == dstSide) {
            return sideVec[(srcSide + 4) % 6].copy();
        }
        double sind = MathUtils.sin((float)(d * Math.PI / 2.0));
        double cosd = MathUtils.cos((float)(d * Math.PI / 2.0));
        Vector3 vsrc = sideVec[srcSide ^ 1].copy();
        Vector3 vdst = sideVec[dstSide ^ 1].copy();
        return vsrc.multiply(sind).add(vdst.multiply(cosd)).normalize();
    }

    public static void renderBeam(TileEntity tileEntity, float partialTicks, double length, @Nonnull int red, @Nonnull int blue, @Nonnull int green, double beamRadius, double glowRadius, EnumFacing ... sides) {
        if (tileEntity == null || tileEntity.func_145831_w() == null) {
            return;
        }
        length = length < 1.0 ? 1.0 : length;
        List<EnumFacing> sideList = Arrays.asList(sides);
        double height = length;
        float[] colors = new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
        float a = 1.0f;
        double yOffset = 0.5;
        BlockPos pos = tileEntity.func_174877_v();
        double x = (double)pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b;
        double y = (double)pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c;
        double z = (double)pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d;
        double totalWorldTime = tileEntity.func_145831_w().func_82737_E();
        double textureScale = 1.0;
        double i = 0.5 + height;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TileEntityBeaconRenderer.field_147523_b);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179140_f();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179106_n();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        double d0 = totalWorldTime + (double)partialTicks;
        double d1 = height < 0.0 ? d0 : -d0;
        double d2 = MathHelper.func_181162_h((double)(d1 * 0.2 - (double)MathUtils.floor(d1 * 0.1)));
        float f = colors[0];
        float f1 = colors[1];
        float f2 = colors[2];
        double d3 = d0 * 0.025 * -1.5;
        double d4 = 0.5 + Math.cos(d3 + 2.356194490192345) * beamRadius;
        double d5 = 0.5 + Math.sin(d3 + 2.356194490192345) * beamRadius;
        double d6 = 0.5 + Math.cos(d3 + 0.7853981633974483) * beamRadius;
        double d7 = 0.5 + Math.sin(d3 + 0.7853981633974483) * beamRadius;
        double d8 = 0.5 + Math.cos(d3 + 3.9269908169872414) * beamRadius;
        double d9 = 0.5 + Math.sin(d3 + 3.9269908169872414) * beamRadius;
        double d10 = 0.5 + Math.cos(d3 + 5.497787143782138) * beamRadius;
        double d11 = 0.5 + Math.sin(d3 + 5.497787143782138) * beamRadius;
        double d13 = 1.0;
        double d14 = -1.0 + d2;
        double d15 = height * 1.0 * (0.5 / beamRadius) + d14;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        if (sideList.contains(EnumFacing.UP)) {
            vertexbuffer.func_181662_b(x + d4, y + i, z + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + 0.5, z + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + 0.5, z + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + i, z + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + i, z + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + 0.5, z + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + 0.5, z + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + i, z + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + i, z + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + 0.5, z + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + 0.5, z + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + i, z + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + i, z + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + 0.5, z + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + 0.5, z + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + i, z + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        }
        if (sideList.contains(EnumFacing.SOUTH)) {
            vertexbuffer.func_181662_b(x + d4, y + d5, z + i).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z + 0.5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z + 0.5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z + i).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z + i).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z + 0.5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z + 0.5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z + i).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z + i).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z + 0.5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z + 0.5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z + i).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z + i).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z + 0.5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z + 0.5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z + i).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        }
        if (sideList.contains(EnumFacing.EAST)) {
            vertexbuffer.func_181662_b(x + i, y + d4, z + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d4, z + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d6, z + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d6, z + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d10, z + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d10, z + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d8, z + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d8, z + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d6, z + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d6, z + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d10, z + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d10, z + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d8, z + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d8, z + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d4, z + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d4, z + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        }
        if (sideList.contains(EnumFacing.DOWN)) {
            vertexbuffer.func_181662_b(x + d4, y - i + 1.0, z + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y - 0.5 + 1.0, z + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y - 0.5 + 1.0, z + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y - i + 1.0, z + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y - i + 1.0, z + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y - 0.5 + 1.0, z + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y - 0.5 + 1.0, z + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y - i + 1.0, z + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y - i + 1.0, z + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y - 0.5 + 1.0, z + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y - 0.5 + 1.0, z + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y - i + 1.0, z + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y - i + 1.0, z + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y - 0.5 + 1.0, z + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y - 0.5 + 1.0, z + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y - i + 1.0, z + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        }
        if (sideList.contains(EnumFacing.NORTH)) {
            vertexbuffer.func_181662_b(x + d4, y + d5, z - i + 1.0).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z - 0.5 + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z - 0.5 + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z - i + 1.0).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z - i + 1.0).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z - 0.5 + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z - 0.5 + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z - i + 1.0).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z - i + 1.0).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z - 0.5 + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z - 0.5 + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z - i + 1.0).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z - i + 1.0).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z - 0.5 + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z - 0.5 + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z - i + 1.0).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        }
        if (sideList.contains(EnumFacing.WEST)) {
            vertexbuffer.func_181662_b(x - i + 1.0, y + d4, z + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d4, z + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d6, z + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d6, z + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d10, z + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d10, z + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d8, z + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d8, z + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d6, z + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d6, z + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d10, z + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d10, z + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d8, z + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d8, z + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d4, z + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d4, z + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179132_a((boolean)false);
        d3 = 0.5 - glowRadius;
        d4 = 0.5 - glowRadius;
        d5 = 0.5 + glowRadius;
        d6 = 0.5 - glowRadius;
        d7 = 0.5 - glowRadius;
        d8 = 0.5 + glowRadius;
        d9 = 0.5 + glowRadius;
        d10 = 0.5 + glowRadius;
        d11 = 0.0;
        d13 = -1.0 + d2;
        d14 = height * 1.0 + d13;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        if (sideList.contains(EnumFacing.UP)) {
            vertexbuffer.func_181662_b(x + d3, y + i, z + d4).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y + 0.5, z + d4).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + 0.5, z + d6).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + i, z + d6).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + i, z + d10).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + 0.5, z + d10).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + 0.5, z + d8).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + i, z + d8).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + i, z + d6).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + 0.5, z + d6).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + 0.5, z + d10).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + i, z + d10).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + i, z + d8).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + 0.5, z + d8).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y + 0.5, z + d4).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y + i, z + d4).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        }
        if (sideList.contains(EnumFacing.SOUTH)) {
            vertexbuffer.func_181662_b(x + d3, y + d4, z + i).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y + d4, z + 0.5).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + d6, z + 0.5).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + d6, z + i).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + d10, z + i).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + d10, z + 0.5).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + d8, z + 0.5).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + d8, z + i).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + d6, z + i).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + d6, z + 0.5).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + d10, z + 0.5).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + d10, z + i).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + d8, z + i).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + d8, z + 0.5).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y + d4, z + 0.5).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y + d4, z + i).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        }
        if (sideList.contains(EnumFacing.EAST)) {
            vertexbuffer.func_181662_b(x + i, y + d3, z + d4).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d3, z + d4).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d5, z + d6).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d5, z + d6).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d9, z + d10).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d9, z + d10).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d7, z + d8).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d7, z + d8).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d5, z + d6).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d5, z + d6).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d9, z + d10).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d9, z + d10).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d7, z + d8).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d7, z + d8).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d3, z + d4).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d3, z + d4).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        }
        if (sideList.contains(EnumFacing.DOWN)) {
            vertexbuffer.func_181662_b(x + d3, y - i + 1.0, z + d4).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y - 0.5 + 1.0, z + d4).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y - 0.5 + 1.0, z + d6).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y - i + 1.0, z + d6).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y - i + 1.0, z + d10).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y - 0.5 + 1.0, z + d10).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y - 0.5 + 1.0, z + d8).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y - i + 1.0, z + d8).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y - i + 1.0, z + d6).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y - 0.5 + 1.0, z + d6).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y - 0.5 + 1.0, z + d10).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y - i + 1.0, z + d10).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y - i + 1.0, z + d8).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y - 0.5 + 1.0, z + d8).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y - 0.5 + 1.0, z + d4).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y - i + 1.0, z + d4).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        }
        if (sideList.contains(EnumFacing.NORTH)) {
            vertexbuffer.func_181662_b(x + d3, y + d4, z - i + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y + d4, z - 0.5 + 1.0).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + d6, z - 0.5 + 1.0).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + d6, z - i + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + d10, z - i + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + d10, z - 0.5 + 1.0).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + d8, z - 0.5 + 1.0).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + d8, z - i + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + d6, z - i + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d5, y + d6, z - 0.5 + 1.0).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + d10, z - 0.5 + 1.0).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d9, y + d10, z - i + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + d8, z - i + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d7, y + d8, z - 0.5 + 1.0).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y + d4, z - 0.5 + 1.0).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x + d3, y + d4, z - i + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        }
        if (sideList.contains(EnumFacing.WEST)) {
            vertexbuffer.func_181662_b(x - i + 1.0, y + d3, z + d4).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d3, z + d4).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d5, z + d6).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d5, z + d6).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d9, z + d10).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d9, z + d10).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d7, z + d8).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d7, z + d8).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d5, z + d6).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d5, z + d6).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d9, z + d10).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d9, z + d10).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d7, z + d8).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d7, z + d8).func_187315_a(1.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d3, z + d4).func_187315_a(0.0, d13).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d3, z + d4).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, 0.125f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179127_m();
    }

    public static void renderBeamNoGlow(TileEntity tileEntity, float partialTicks, int length, @Nonnull int red, @Nonnull int blue, @Nonnull int green, @Nonnull int beamAlpha, double beamRadius, EnumFacing ... sides) {
        if (tileEntity == null || tileEntity.func_145831_w() == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("textures/entity/beacon_beam.png"));
        List<EnumFacing> sideList = Arrays.asList(sides);
        int height = length = length < 1 ? 1 : length;
        float[] colors = new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
        float a = (float)beamAlpha / 255.0f;
        double yOffset = 0.5;
        BlockPos pos = tileEntity.func_174877_v();
        double x = (double)pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b;
        double y = (double)pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c;
        double z = (double)pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d;
        double totalWorldTime = tileEntity.func_145831_w().func_82737_E();
        double textureScale = 1.0;
        double i = 0.5 + (double)height;
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179106_n();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        double d0 = totalWorldTime + (double)partialTicks;
        double d1 = height < 0 ? d0 : -d0;
        double d2 = MathHelper.func_181162_h((double)(d1 * 0.2 - (double)MathUtils.floor(d1 * 0.1)));
        float f = colors[0];
        float f1 = colors[1];
        float f2 = colors[2];
        double d3 = d0 * 0.025 * -1.5;
        double d4 = 0.5 + Math.cos(d3 + 2.356194490192345) * beamRadius;
        double d5 = 0.5 + Math.sin(d3 + 2.356194490192345) * beamRadius;
        double d6 = 0.5 + Math.cos(d3 + 0.7853981633974483) * beamRadius;
        double d7 = 0.5 + Math.sin(d3 + 0.7853981633974483) * beamRadius;
        double d8 = 0.5 + Math.cos(d3 + 3.9269908169872414) * beamRadius;
        double d9 = 0.5 + Math.sin(d3 + 3.9269908169872414) * beamRadius;
        double d10 = 0.5 + Math.cos(d3 + 5.497787143782138) * beamRadius;
        double d11 = 0.5 + Math.sin(d3 + 5.497787143782138) * beamRadius;
        double d14 = -1.0 + d2;
        double d15 = (double)height * 1.0 * (0.5 / beamRadius) + d14;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        if (sideList.contains(EnumFacing.UP)) {
            vertexbuffer.func_181662_b(x + d4, y + i, z + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + 0.5, z + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + 0.5, z + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + i, z + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + i, z + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + 0.5, z + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + 0.5, z + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + i, z + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + i, z + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + 0.5, z + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + 0.5, z + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + i, z + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + i, z + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + 0.5, z + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + 0.5, z + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + i, z + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
        }
        if (sideList.contains(EnumFacing.SOUTH)) {
            vertexbuffer.func_181662_b(x + d4, y + d5, z + i).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z + 0.5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z + 0.5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z + i).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z + i).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z + 0.5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z + 0.5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z + i).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z + i).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z + 0.5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z + 0.5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z + i).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z + i).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z + 0.5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z + 0.5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z + i).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
        }
        if (sideList.contains(EnumFacing.EAST)) {
            vertexbuffer.func_181662_b(x + i, y + d4, z + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d4, z + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d6, z + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d6, z + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d10, z + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d10, z + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d8, z + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d8, z + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d6, z + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d6, z + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d10, z + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d10, z + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d8, z + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d8, z + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + 0.5, y + d4, z + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + i, y + d4, z + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
        }
        if (sideList.contains(EnumFacing.DOWN)) {
            vertexbuffer.func_181662_b(x + d4, y - i + 1.0, z + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y - 0.5 + 1.0, z + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y - 0.5 + 1.0, z + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y - i + 1.0, z + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y - i + 1.0, z + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y - 0.5 + 1.0, z + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y - 0.5 + 1.0, z + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y - i + 1.0, z + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y - i + 1.0, z + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y - 0.5 + 1.0, z + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y - 0.5 + 1.0, z + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y - i + 1.0, z + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y - i + 1.0, z + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y - 0.5 + 1.0, z + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y - 0.5 + 1.0, z + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y - i + 1.0, z + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
        }
        if (sideList.contains(EnumFacing.NORTH)) {
            vertexbuffer.func_181662_b(x + d4, y + d5, z - i + 1.0).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z - 0.5 + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z - 0.5 + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z - i + 1.0).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z - i + 1.0).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z - 0.5 + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z - 0.5 + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z - i + 1.0).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z - i + 1.0).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d6, y + d7, z - 0.5 + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z - 0.5 + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d10, y + d11, z - i + 1.0).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z - i + 1.0).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d8, y + d9, z - 0.5 + 1.0).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z - 0.5 + 1.0).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x + d4, y + d5, z - i + 1.0).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
        }
        if (sideList.contains(EnumFacing.WEST)) {
            vertexbuffer.func_181662_b(x - i + 1.0, y + d4, z + d5).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d4, z + d5).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d6, z + d7).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d6, z + d7).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d10, z + d11).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d10, z + d11).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d8, z + d9).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d8, z + d9).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d6, z + d7).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d6, z + d7).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d10, z + d11).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d10, z + d11).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d8, z + d9).func_187315_a(1.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d8, z + d9).func_187315_a(1.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - 0.5 + 1.0, y + d4, z + d5).func_187315_a(0.0, d14).func_181666_a(f, f1, f2, a).func_181675_d();
            vertexbuffer.func_181662_b(x - i + 1.0, y + d4, z + d5).func_187315_a(0.0, d15).func_181666_a(f, f1, f2, a).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179147_l();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179127_m();
    }

    public static void pushFBO() {
        RenderUtils.pushFBO(512);
    }

    public static void pushFBO(int size) {
        renderTextureSize = size;
        GL30.glDeleteFramebuffers((int)framebufferID);
        GL11.glDeleteTextures((int)textureID);
        GL30.glDeleteRenderbuffers((int)depthbufferID);
        framebufferID = GL30.glGenFramebuffers();
        textureID = GL11.glGenTextures();
        int currentFramebuffer = GL11.glGetInteger((int)36006);
        int currentTexture = GL11.glGetInteger((int)32873);
        GL30.glBindFramebuffer((int)36160, (int)framebufferID);
        GL11.glBindTexture((int)3553, (int)textureID);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderTextureSize, (int)renderTextureSize, (int)0, (int)32993, (int)5121, (ByteBuffer)null);
        GL11.glBindTexture((int)3553, (int)currentTexture);
        depthbufferID = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)depthbufferID);
        GL30.glRenderbufferStorage((int)36161, (int)6402, (int)renderTextureSize, (int)renderTextureSize);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)depthbufferID);
        GL32.glFramebufferTexture((int)36160, (int)36064, (int)textureID, (int)0);
        GL30.glBindFramebuffer((int)36160, (int)currentFramebuffer);
        lastFramebuffer = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36160, (int)framebufferID);
        lastViewport = GLAllocation.func_74527_f((int)16);
        GL11.glGetInteger((int)2978, (IntBuffer)lastViewport);
        GL11.glViewport((int)0, (int)0, (int)renderTextureSize, (int)renderTextureSize);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        lastTexture = GL11.glGetInteger((int)32873);
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179086_m((int)16640);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
    }

    public static void popFBO() {
        GlStateManager.func_179097_i();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GL11.glViewport((int)lastViewport.get(0), (int)lastViewport.get(1), (int)lastViewport.get(2), (int)lastViewport.get(3));
        GL30.glBindFramebuffer((int)36160, (int)lastFramebuffer);
        GlStateManager.func_179144_i((int)lastTexture);
    }

    public static void saveImage() {
        try {
            ImageUtils.IMAGE_DIR.mkdir();
            File imageFile = RenderUtils.getTimestampedPNGFile(ImageUtils.IMAGE_DIR);
            GlStateManager.func_179144_i((int)textureID);
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            IntBuffer texture = BufferUtils.createIntBuffer((int)(width * height));
            GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)texture);
            int[] texture_array = new int[width * height];
            texture.get(texture_array);
            BufferedImage image = new BufferedImage(renderTextureSize, renderTextureSize, 2);
            image.setRGB(0, 0, renderTextureSize, renderTextureSize, texture_array, 0, width);
            AffineTransform flip = AffineTransform.getScaleInstance(1.0, -1.0);
            flip.translate(0.0, -renderTextureSize);
            BufferedImage flipped = new AffineTransformOp(flip, null).filter(image, null);
            ImageIO.write((RenderedImage)flipped, "png", imageFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File getTimestampedPNGFile(File saveDir) {
        String s = DATE_FORMAT.format(new Date()).toString();
        int i = 1;
        File file1;
        while ((file1 = new File(saveDir, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }

    public static void renderEntity(String entityName, NBTTagCompound entityNBT, int x, int y) {
        if (entityName != null && !entityName.isEmpty()) {
            Entity entity = null;
            if (entityNBT != null) {
                entity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)EasyMappings.world());
            } else {
                int id = EntityList.getID((Class)EntityList.getClass((ResourceLocation)new ResourceLocation(entityName)));
                Class clazz = EntityList.func_90035_a((int)id);
                try {
                    entity = (Entity)clazz.getConstructor(World.class).newInstance(EasyMappings.world());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            if (entity != null) {
                RenderUtils.renderEntity(x, y, entity);
            }
        }
    }

    private static void renderEntity(int x, int y, Entity entity) {
        RenderUtils.renderEntity(entity, x, y, entity.field_70131_O);
    }

    public static void renderEntity(Entity entity, int xPos, int yPos, float scale) {
        RenderUtils.renderEntity(entity, xPos, yPos, scale, 0.0f);
    }

    public static void renderLivingEntity(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        RenderUtils.renderLivingEntity(posX, posY, scale, mouseX, mouseY, ent, false);
    }

    public static void renderLivingEntity(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent, boolean useMouseRot) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (useMouseRot) {
            GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
            ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
            ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        } else {
            GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            ent.field_70761_aq = mouseX;
            ent.field_70177_z = mouseX;
            ent.field_70125_A = 0.0f;
        }
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static void renderEntity(Entity entity, int xPos, int yPos, float scale, float rot) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(xPos + 8), (float)(yPos + 24), (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        entity.field_70125_A = 0.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)((float)entity.func_70033_W()), (float)0.0f);
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        try {
            Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        GlStateManager.func_179119_h();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static void renderScaledItemStack(ItemStack stack, int x, int y, float scale) {
        RenderUtils.renderScaledItemStack(stack, x, y, scale);
    }

    public static void renderScaledItemStack(ItemStack stack, int x, int y, float scale, float rotation) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179137_b((double)((float)(x * -5) / scale), (double)((float)(y * -5) / scale), (double)0.0);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        RenderUtils.getRenderItem().func_180450_b(stack, 0, 0);
        GlStateManager.func_179114_b((float)(rotation -= 1.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    public static void drawTextRGBA(FontRenderer font, String s, int x, int y, int r, int g, int b, int a) {
        font.func_78276_b(s, x, y, (a << 24) + (r << 16) + (g << 8) + b);
    }

    public static Vec3i hexToRGB(int hex) {
        return new Vec3i(hex >> 16 & 0xFF, hex >> 8 & 0xFF, hex >> 0 & 0xFF);
    }

    public static Quat hexToRGBA(int hex) {
        Color c = new Color(hex);
        return new Quat(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }
}

