/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.XUItemBlock;
import com.rwtema.extrautils2.backend.entries.BlockEntry;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.MutableModel;
import com.rwtema.extrautils2.backend.model.PassthruModelItem;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.backend.model.Transforms;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.Validate;

public abstract class XUTree
extends Entry<TreeBlocks> {
    @Nullable
    private static XUTree curXUTreeIniting = null;
    private final Map<Map<IProperty<?>, Comparable<?>>, TreeModel> models;

    protected XUTree(String name, Map<Map<IProperty<?>, Comparable<?>>, TreeModel> models) {
        super(name);
        this.models = models;
    }

    public static Map<IProperty<?>, Comparable<?>> getStripKey(IBlockState state) {
        return state.func_177228_b().entrySet().stream().filter(e -> {
            IProperty key = (IProperty)e.getKey();
            return key != BlockLog.field_176299_a && key != BlockLeaves.field_176237_a && key != BlockLeaves.field_176236_b && key != BlockSapling.field_176479_b;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nullable
    public static IBlockState getEquivalentState(IBlockState state, IBlockState blockState) {
        for (Map.Entry entry2 : state.func_177228_b().entrySet()) {
            if (!blockState.func_177228_b().containsKey(entry2.getKey())) continue;
            blockState = blockState.func_177226_a((IProperty)entry2.getKey(), (Comparable)entry2.getValue());
        }
        return blockState;
    }

    @SideOnly(value=Side.CLIENT)
    private void addSaplingInvQuads(PassthruModelItem.ModelLayer layer, XUBlockState stateFromItemStack) {
        this.getModel((IBlockState)stateFromItemStack).createSaplingInvModel(layer);
    }

    protected abstract XUBlockStateCreator.Builder getBuilder(XUBlock var1);

    protected BoxModel createLogModel(IBlockState state) {
        return this.getModel(state).createLogModel();
    }

    protected BoxModel createBlankLogModel(IBlockState state) {
        return this.getModel(state).createBlankLogModel();
    }

    protected TreeModel getModel(IBlockState state) {
        return this.models.get(XUTree.getStripKey(state));
    }

    private BoxModel getSaplingWorldModel(IBlockState state) {
        return this.getModel(state).createSaplingWorldModel();
    }

    private BoxModel createLeavesModel(IBlockState state) {
        return this.getModel(state).createLeavesModel();
    }

    @Override
    protected TreeBlocks initValue() {
        curXUTreeIniting = this;
        XUTreeLeaves leaves = this.getXuTreeLeaves();
        XUTreeLog log = this.getXuTreeLog();
        XUTreeSapling sapling = this.getXuTreeSapling();
        XUTreePlanks planks = this.getXuTreePlanks();
        curXUTreeIniting = null;
        return new TreeBlocks(leaves, log, sapling, planks);
    }

    public XUTreePlanks getXuTreePlanks() {
        return new XUTreePlanks();
    }

    public XUTreeSapling getXuTreeSapling() {
        return new XUTreeSapling();
    }

    public XUTreeLog getXuTreeLog() {
        return new XUTreeLog();
    }

    public XUTreeLeaves getXuTreeLeaves() {
        return new XUTreeLeaves();
    }

    @Override
    public void preInitRegister() {
        ((TreeBlocks)this.value).getBlocksAndNames().forEach((n, b) -> {
            b.setBlockName("extrautils2:" + this.name.toLowerCase(Locale.ENGLISH) + "_" + n);
            BlockEntry.registerBlockItemCombo(b, XUItemBlock.class, this.name + "_" + n);
        });
    }

    @Override
    public void addRecipes() {
        XUBlockState[] logDropStates;
        for (XUBlockState logDropState : logDropStates = ((TreeBlocks)this.value).log.xuBlockState.dropmeta2state) {
            StringBuilder suffix = new StringBuilder();
            IBlockState state = ((TreeBlocks)this.value).leaves.func_176223_P();
            for (Map.Entry entry2 : logDropState.func_177228_b().entrySet()) {
                if (!state.func_177228_b().containsKey(entry2.getKey())) continue;
                IProperty key = (IProperty)entry2.getKey();
                Comparable value = (Comparable)entry2.getValue();
                state = state.func_177226_a(key, value);
                suffix.append("_").append(key.func_177702_a(value).toLowerCase(Locale.ENGLISH));
            }
            CraftingHelper.addShapeless(this.name.toLowerCase(Locale.ENGLISH) + "_log_to_planks" + suffix, new ItemStack((Block)((TreeBlocks)this.value).planks, 4, ((TreeBlocks)this.value).leaves.xuBlockState.getDropMetaFromState(state)), new ItemStack((Block)((TreeBlocks)this.value).log, 1, ((TreeBlocks)this.value).log.xuBlockState.getDropMetaFromState((IBlockState)logDropState)));
        }
        FurnaceRecipes.func_77602_a().func_151396_a((Item)((TreeBlocks)this.value).log.itemBlock, new ItemStack(Items.field_151044_h, 1, 1), 0.0f);
    }

    @Override
    public void registerOres() {
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack((Block)((TreeBlocks)this.value).sapling, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)((TreeBlocks)this.value).leaves, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack((Block)((TreeBlocks)this.value).log, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)((TreeBlocks)this.value).planks, 1, Short.MAX_VALUE));
    }

    public abstract int getHeight(World var1, Random var2, IBlockState var3, BlockPos var4);

    protected int getLeavesColour(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        return worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
    }

    protected int getLeavesStackColour(ItemStack stack, int tintIndex) {
        return this.getLeavesColour((IBlockState)((TreeBlocks)this.value).leaves.xuBlockState.getStateFromItemStack(stack), null, null, tintIndex);
    }

    public static class XUTreePlanks
    extends XUBlockStatic {
        XUTree tree = (XUTree)Validate.notNull((Object)XUTree.access$000());

        public XUTreePlanks() {
            super(Material.field_151575_d);
            this.func_149711_c(2.0f);
            this.func_149752_b(5.0f);
            this.func_149672_a(SoundType.field_185848_a);
        }

        @Override
        @Nonnull
        protected XUBlockStateCreator createBlockState() {
            return ((XUTree)Validate.notNull((Object)curXUTreeIniting)).getBuilder(this).build();
        }

        @Override
        public BoxModel getModel(IBlockState state) {
            return this.tree.getModel(state).createPlanksModel();
        }
    }

    public static class XUTreeLeaves
    extends XUBlockStatic
    implements IShearable {
        int[] surroundings;
        @Nonnull
        XUTree xuTree = (XUTree)Validate.notNull((Object)XUTree.access$000());

        public XUTreeLeaves() {
            super(Material.field_151584_j);
            this.func_149675_a(true);
            this.func_149647_a(CreativeTabs.field_78031_c);
            this.func_149711_c(0.2f);
            this.func_149713_g(1);
            this.func_149672_a(SoundType.field_185850_c);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addItemColors(ItemColors itemColors, BlockColors blockColors) {
            blockColors.func_186722_a(this.xuTree::getLeavesColour, new Block[]{this});
            itemColors.func_186731_a(this.xuTree::getLeavesStackColour, new Block[]{this});
        }

        public boolean isLeavesFancy() {
            return !Blocks.field_150362_t.func_149662_c(Blocks.field_150362_t.func_176223_P());
        }

        @Override
        public BoxModel getModel(IBlockState state) {
            return this.xuTree.createLeavesModel(state);
        }

        @Override
        @Nonnull
        protected XUBlockStateCreator createBlockState() {
            return ((XUTree)Validate.notNull((Object)curXUTreeIniting)).getBuilder(this).addWorldPropertyWithDefault(BlockLeaves.field_176236_b, false).addWorldPropertyWithDefault(BlockLeaves.field_176237_a, false).build();
        }

        @Override
        public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            int i1;
            int l;
            int k = pos.func_177958_n();
            if (worldIn.func_175707_a(new BlockPos(k - 2, (l = pos.func_177956_o()) - 2, (i1 = pos.func_177952_p()) - 2), new BlockPos(k + 2, l + 2, i1 + 2))) {
                for (int j1 = -1; j1 <= 1; ++j1) {
                    for (int k1 = -1; k1 <= 1; ++k1) {
                        for (int l1 = -1; l1 <= 1; ++l1) {
                            BlockPos blockpos = pos.func_177982_a(j1, k1, l1);
                            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                            if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                            iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
                        }
                    }
                }
            }
        }

        public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
                int l2;
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                if (this.surroundings == null) {
                    this.surroundings = new int[32768];
                }
                if (worldIn.func_175707_a(new BlockPos(x - 5, y - 5, z - 5), new BlockPos(x + 5, y + 5, z + 5))) {
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                    for (int dx = -4; dx <= 4; ++dx) {
                        for (int dy = -4; dy <= 4; ++dy) {
                            for (int dz = -4; dz <= 4; ++dz) {
                                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(x + dx, y + dy, z + dz));
                                Block block = iblockstate.func_177230_c();
                                if (!block.canSustainLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(x + dx, y + dy, z + dz))) {
                                    if (block.isLeaves(iblockstate, (IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(x + dx, y + dy, z + dz))) {
                                        this.surroundings[(dx + 16) * 1024 + (dy + 16) * 32 + dz + 16] = -2;
                                        continue;
                                    }
                                    this.surroundings[(dx + 16) * 1024 + (dy + 16) * 32 + dz + 16] = -1;
                                    continue;
                                }
                                this.surroundings[(dx + 16) * 1024 + (dy + 16) * 32 + dz + 16] = 0;
                            }
                        }
                    }
                    for (int level = 1; level <= 4; ++level) {
                        for (int dx = -4; dx <= 4; ++dx) {
                            for (int dy = -4; dy <= 4; ++dy) {
                                for (int dz = -4; dz <= 4; ++dz) {
                                    if (this.surroundings[(dx + 16) * 1024 + (dy + 16) * 32 + dz + 16] != level - 1) continue;
                                    if (this.surroundings[(dx + 16 - 1) * 1024 + (dy + 16) * 32 + dz + 16] == -2) {
                                        this.surroundings[(dx + 16 - 1) * 1024 + (dy + 16) * 32 + dz + 16] = level;
                                    }
                                    if (this.surroundings[(dx + 16 + 1) * 1024 + (dy + 16) * 32 + dz + 16] == -2) {
                                        this.surroundings[(dx + 16 + 1) * 1024 + (dy + 16) * 32 + dz + 16] = level;
                                    }
                                    if (this.surroundings[(dx + 16) * 1024 + (dy + 16 - 1) * 32 + dz + 16] == -2) {
                                        this.surroundings[(dx + 16) * 1024 + (dy + 16 - 1) * 32 + dz + 16] = level;
                                    }
                                    if (this.surroundings[(dx + 16) * 1024 + (dy + 16 + 1) * 32 + dz + 16] == -2) {
                                        this.surroundings[(dx + 16) * 1024 + (dy + 16 + 1) * 32 + dz + 16] = level;
                                    }
                                    if (this.surroundings[(dx + 16) * 1024 + (dy + 16) * 32 + (dz + 16 - 1)] == -2) {
                                        this.surroundings[(dx + 16) * 1024 + (dy + 16) * 32 + (dz + 16 - 1)] = level;
                                    }
                                    if (this.surroundings[(dx + 16) * 1024 + (dy + 16) * 32 + dz + 16 + 1] != -2) continue;
                                    this.surroundings[(dx + 16) * 1024 + (dy + 16) * 32 + dz + 16 + 1] = level;
                                }
                            }
                        }
                    }
                }
                if ((l2 = this.surroundings[16912]) >= 0) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.FALSE), 4);
                } else {
                    this.destroy(worldIn, pos);
                }
            }
        }

        private void destroy(World worldIn, BlockPos pos) {
            this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
            worldIn.func_175698_g(pos);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
            if (worldIn.func_175727_C(pos.func_177984_a()) && !worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) && rand.nextInt(15) == 1) {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (double)pos.func_177956_o() - 0.05;
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }

        public int func_149745_a(Random random) {
            return random.nextInt(20) == 0 ? 1 : 0;
        }

        @Override
        public Item func_180660_a(IBlockState state, Random rand, int fortune) {
            return Item.func_150898_a((Block)((TreeBlocks)this.xuTree.value).sapling);
        }

        @Override
        public int func_180651_a(IBlockState state) {
            IBlockState dropState = ((TreeBlocks)this.xuTree.value).sapling.func_176223_P();
            for (Map.Entry entry2 : state.func_177228_b().entrySet()) {
                if (!dropState.func_177228_b().containsKey(entry2.getKey())) continue;
                dropState = dropState.func_177226_a((IProperty)entry2.getKey(), (Comparable)entry2.getValue());
            }
            return ((TreeBlocks)this.xuTree.value).sapling.xuBlockState.getDropMetaFromState(dropState);
        }

        protected int getSaplingDropChance(IBlockState state) {
            return 20;
        }

        @Override
        public boolean func_149662_c(IBlockState state) {
            return !this.isLeavesFancy();
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public BlockRenderLayer func_180664_k() {
            return this.isLeavesFancy() ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
        }

        public boolean func_176214_u(IBlockState state) {
            return false;
        }

        public boolean isShearable(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos) {
            return true;
        }

        public List<ItemStack> onSheared(@Nonnull ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
            IBlockState blockState = world.func_180495_p(pos);
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this, 1, this.xuBlockState.getDropMetaFromState(blockState))});
        }

        public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
            return true;
        }

        public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
            if (!((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue()) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)), 4);
            }
        }

        @Override
        @Nonnull
        public List<ItemStack> getDrops(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
            ItemStack stack;
            ItemStack drop;
            Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            int chance = this.getSaplingDropChance(state);
            if (fortune > 0 && (chance -= 2 << fortune) < 10) {
                chance = 10;
            }
            if (rand.nextInt(chance) == 0 && !StackHelper.isEmpty(drop = new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state)))) {
                drops.add(drop);
            }
            chance = 200;
            if (fortune > 0 && (chance -= 10 << fortune) < 40) {
                chance = 40;
            }
            if (rand.nextInt(chance) == 0 && StackHelper.isNonNull(stack = this.getAppleDrop(world, pos, state, rand, fortune, chance))) {
                drops.add(stack);
            }
            return drops;
        }

        protected ItemStack getAppleDrop(IBlockAccess world, BlockPos pos, IBlockState state, Random rand, int fortune, int chance) {
            return StackHelper.empty();
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
            return (this.isLeavesFancy() || blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this) && super.func_176225_a(blockState, blockAccess, pos, side);
        }
    }

    public static class XUTreeLog
    extends XUBlockStatic {
        @Nonnull
        XUTree xuTree = (XUTree)Validate.notNull((Object)XUTree.access$000());

        public XUTreeLog() {
            super(Material.field_151575_d);
            this.func_149711_c(2.0f);
            this.func_149672_a(SoundType.field_185848_a);
        }

        @Override
        public BoxModel getModel(IBlockState state) {
            switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a)) {
                case X: {
                    return this.xuTree.createLogModel(state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y)).rotateToSide(EnumFacing.WEST);
                }
                case Y: {
                    return this.xuTree.createLogModel(state);
                }
                case Z: {
                    return this.xuTree.createLogModel(state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y)).rotateToSide(EnumFacing.NORTH);
                }
                case NONE: {
                    return this.xuTree.createBlankLogModel(state);
                }
            }
            throw new IllegalArgumentException("" + state);
        }

        @Override
        @Nonnull
        protected XUBlockStateCreator createBlockState() {
            return ((XUTree)Validate.notNull((Object)curXUTreeIniting)).getBuilder(this).addWorldPropertyWithDefault(BlockLog.field_176299_a, BlockLog.EnumAxis.Y).build();
        }

        @Override
        public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            if (worldIn.func_175707_a(pos.func_177982_a(-5, -5, -5), pos.func_177982_a(5, 5, 5))) {
                for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-4, -4, -4), (BlockPos)pos.func_177982_a(4, 4, 4))) {
                    IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                    if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                    iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
                }
            }
        }

        @Override
        @Nonnull
        public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
            switch (rot) {
                case COUNTERCLOCKWISE_90: 
                case CLOCKWISE_90: {
                    switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)BlockLog.field_176299_a)) {
                        case X: {
                            return state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
                        }
                        case Z: {
                            return state.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
                        }
                    }
                    return state;
                }
            }
            return state;
        }

        public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
            return true;
        }

        public boolean isWood(IBlockAccess world, BlockPos pos) {
            return true;
        }
    }

    public static class XUTreeSapling
    extends XUBlockStatic
    implements IPlantable,
    IGrowable {
        protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
        @Nonnull
        XUTree xuTree = (XUTree)Validate.notNull((Object)XUTree.access$000());

        public XUTreeSapling() {
            super(Material.field_151585_k);
            this.func_149675_a(true);
            this.func_149647_a(CreativeTabs.field_78031_c);
            this.func_149672_a(SoundType.field_185850_c);
            this.func_149711_c(0.0f);
        }

        @Override
        public AxisAlignedBB getCollisionBoundingBoxBase(IBlockState state, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos) {
            return field_185506_k;
        }

        @Override
        public BoxModel getModel(IBlockState state) {
            return this.xuTree.getSaplingWorldModel(state);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addInventoryQuads(MutableModel result, ItemStack stack) {
            this.xuTree.addSaplingInvQuads((PassthruModelItem.ModelLayer)result, this.xuBlockState.getStateFromItemStack(stack));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public MutableModel createInventoryMutableModel() {
            return new PassthruModelItem.ModelLayer(Transforms.itemTransforms);
        }

        public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }

        protected boolean canSustainBush(IBlockState state) {
            return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak;
        }

        @Override
        public void neighborChangedBase(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
            super.neighborChangedBase(state, worldIn, pos, neighborBlock);
            this.checkAndDropBlock(worldIn, pos, state);
        }

        protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
            if (!this.canBlockStay(worldIn, pos, state)) {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        }

        public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
            if (state.func_177230_c() == this) {
                IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
                return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
            }
            return this.canSustainBush(worldIn.func_180495_p(pos.func_177977_b()));
        }

        @Override
        public boolean func_149662_c(IBlockState state) {
            return false;
        }

        @Override
        public boolean func_149686_d(IBlockState state) {
            return false;
        }

        public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
            return EnumPlantType.Plains;
        }

        public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() != this) {
                return this.func_176223_P();
            }
            return state;
        }

        @Nonnull
        @SideOnly(value=Side.CLIENT)
        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT;
        }

        @Override
        @Nonnull
        public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
            return SAPLING_AABB;
        }

        @Nonnull
        public String func_149732_F() {
            return I18n.func_74838_a((String)(this.func_149739_a() + "." + BlockPlanks.EnumType.OAK.func_176840_c() + ".name"));
        }

        public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            this.checkAndDropBlock(worldIn, pos, state);
            if (!worldIn.field_72995_K) {
                this.tryGrow(worldIn, pos, state, rand);
            }
        }

        protected void tryGrow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }

        public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            if ((Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b) == 0) {
                worldIn.func_180501_a(pos, state.func_177231_a((IProperty)BlockSapling.field_176479_b), 4);
            } else {
                this.generateTree(worldIn, pos, state, rand);
            }
        }

        public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
                return;
            }
            IBlockState blockState = ((TreeBlocks)this.xuTree.value).leaves.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
            IBlockState logState = ((TreeBlocks)this.xuTree.value).log.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
            blockState = XUTree.getEquivalentState(state, blockState);
            logState = XUTree.getEquivalentState(state, logState);
            WorldGenTrees worldgenerator = new WorldGenTrees(true, this.xuTree.getHeight(worldIn, rand, state, pos), logState, blockState, false);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
            if (!worldgenerator.func_180709_b(worldIn, rand, pos)) {
                worldIn.func_180501_a(pos, state, 4);
            }
        }

        public boolean func_176473_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
            return true;
        }

        public boolean func_180670_a(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            return (double)worldIn.field_73012_v.nextFloat() < 0.45;
        }

        public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
            this.grow(worldIn, pos, state, rand);
        }

        @Override
        @Nonnull
        protected XUBlockStateCreator createBlockState() {
            return ((XUTree)Validate.notNull((Object)curXUTreeIniting)).getBuilder(this).addWorldProperties(new IProperty[]{BlockSapling.field_176479_b}).build();
        }
    }

    public static abstract class TreeModel {
        public abstract BoxModel createLogModel();

        public abstract BoxModel createBlankLogModel();

        public abstract BoxModel createSaplingWorldModel();

        @SideOnly(value=Side.CLIENT)
        public abstract void createSaplingInvModel(MutableModel var1);

        public abstract BoxModel createLeavesModel();

        public abstract BoxModel createPlanksModel();
    }

    public static class TreeModelTex
    extends TreeModel {
        final String saplingTex;
        final String logSideTex;
        final String logInsideTex;
        final String planksTex;
        final String leavesTex;

        public TreeModelTex(String prefix) {
            this(prefix + "_sapling", prefix + "_log", prefix + "_log_top", prefix + "_planks", prefix + "_leaves");
        }

        public TreeModelTex(String saplingTex, String logSideTex, String logInsideTex, String planksTex, String leavesTex) {
            this.saplingTex = saplingTex;
            this.logSideTex = logSideTex;
            this.logInsideTex = logInsideTex;
            this.planksTex = planksTex;
            this.leavesTex = leavesTex;
        }

        @Override
        public BoxModel createLogModel() {
            return BoxModel.newStandardBlock(this.logSideTex).setTextures(EnumFacing.UP, this.logInsideTex).setTextures(EnumFacing.DOWN, this.logInsideTex);
        }

        @Override
        public BoxModel createBlankLogModel() {
            return BoxModel.newStandardBlock(this.logSideTex);
        }

        @Override
        public BoxModel createSaplingWorldModel() {
            BoxModel boxes = BoxModel.crossBoxModel().setLayer(BlockRenderLayer.CUTOUT).setTexture(this.saplingTex);
            for (Box box : boxes) {
                box.noCollide = true;
            }
            return boxes;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createSaplingInvModel(MutableModel model) {
            model.clear();
            ((PassthruModelItem.ModelLayer)model).addSprite((TextureAtlasSprite)Textures.sprites.get((Object)this.saplingTex));
        }

        @Override
        public BoxModel createLeavesModel() {
            BoxModel model = BoxModel.newStandardBlock(this.leavesTex);
            Box box = (Box)model.get(0);
            model.renderAsNormalBlock = false;
            box.setTint(0);
            box.setLayer(BlockRenderLayer.CUTOUT);
            return model;
        }

        @Override
        public BoxModel createPlanksModel() {
            return BoxModel.newStandardBlock(this.planksTex);
        }
    }

    public static class TreeBlocks {
        public XUTreeLeaves leaves;
        public XUTreeLog log;
        public XUTreeSapling sapling;
        public XUTreePlanks planks;

        public TreeBlocks(XUTreeLeaves leaves, XUTreeLog log, XUTreeSapling sapling, XUTreePlanks planks) {
            this.leaves = leaves;
            this.log = log;
            this.sapling = sapling;
            this.planks = planks;
        }

        public Map<String, XUBlock> getBlocksAndNames() {
            return ImmutableMap.builder().put((Object)"leaves", (Object)this.leaves).put((Object)"log", (Object)this.log).put((Object)"sapling", (Object)this.sapling).put((Object)"planks", (Object)this.planks).build();
        }
    }
}

