/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.reference;

import dan200.computercraft.api.lua.LuaException;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.reference.EntityReference;

public class BoundedEntityReference<T extends Entity>
extends EntityReference<T> {
    private final IWorldLocation location;
    private final int radius;
    private boolean valid = true;

    BoundedEntityReference(T entity, IWorldLocation location, int radius) {
        super(entity);
        this.location = location;
        this.radius = radius;
    }

    @Override
    @Nonnull
    public T get() throws LuaException {
        Object entity = super.get();
        if (entity.func_130014_f_() != this.location.getWorld()) {
            throw new LuaException("The entity has gone");
        }
        Vec3d pos = entity.func_174791_d().func_178788_d(this.location.getLoc());
        if (pos.field_72450_a < (double)(-this.radius) || pos.field_72450_a > (double)this.radius || pos.field_72448_b < (double)(-this.radius) || pos.field_72448_b > (double)this.radius || pos.field_72449_c < (double)(-this.radius) || pos.field_72449_c > (double)this.radius) {
            this.valid = false;
            throw new LuaException("The entity is out of range");
        }
        this.valid = true;
        return entity;
    }

    @Override
    @Nonnull
    public T safeGet() throws LuaException {
        Object entity = super.safeGet();
        if (!this.valid) {
            throw new LuaException("The entity is out of range");
        }
        return entity;
    }
}

