/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import dan200.computercraft.api.lua.LuaException;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.method.ICostHandler;
import org.squiddev.plethora.api.method.IResultExecutor;
import org.squiddev.plethora.api.method.IUnbakedContext;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.core.Context;
import org.squiddev.plethora.core.ConverterReference;

public final class UnbakedContext<T>
implements IUnbakedContext<T> {
    final int target;
    final String[] keys;
    final Object[] references;
    final ICostHandler handler;
    final IReference<IModuleContainer> modules;
    final IResultExecutor executor;

    UnbakedContext(int target, String[] keys, Object[] references, ICostHandler handler, IReference<IModuleContainer> modules, IResultExecutor executor) {
        this.target = target;
        this.handler = handler;
        this.keys = keys;
        this.references = references;
        this.modules = modules;
        this.executor = executor;
    }

    UnbakedContext<?> withIndex(int index) {
        return index == this.target ? this : new UnbakedContext<T>(index, this.keys, this.references, this.handler, this.modules, this.executor);
    }

    @Override
    @Nonnull
    public Context<T> bake() throws LuaException {
        Object[] values = new Object[this.references.length];
        for (int i = 0; i < this.references.length; ++i) {
            Object reference = this.references[i];
            values[i] = reference instanceof IReference ? ((IReference)reference).get() : (reference instanceof ConverterReference ? ((ConverterReference)reference).tryConvert(values) : reference);
        }
        return new Context(this, values, this.modules.get());
    }

    @Override
    @Nonnull
    public Context<T> safeBake() throws LuaException {
        Object[] values = new Object[this.references.length];
        for (int i = 0; i < this.references.length; ++i) {
            Object reference = this.references[i];
            values[i] = reference instanceof IReference ? ((IReference)reference).safeGet() : (reference instanceof ConverterReference ? null : reference);
        }
        return new Context(this, values, this.modules.safeGet());
    }

    @Override
    @Nonnull
    public ICostHandler getCostHandler() {
        return this.handler;
    }

    @Override
    @Nonnull
    public IResultExecutor getExecutor() {
        return this.executor;
    }
}

