/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.wrapper;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;
import org.squiddev.plethora.core.ConfigCore;

final class ClassWriterHelpers {
    private ClassWriterHelpers() {
    }

    static void loadInt(MethodVisitor visitor, int value) {
        if (value >= -1 && value <= 5) {
            visitor.visitInsn(3 + value);
        } else {
            visitor.visitLdcInsn((Object)value);
        }
    }

    static void loadLong(MethodVisitor visitor, long value) {
        if (value >= 0L && value <= 1L) {
            visitor.visitInsn(9 + (int)value);
        } else {
            visitor.visitLdcInsn((Object)value);
        }
    }

    static void loadDouble(MethodVisitor visitor, double value) {
        if (value == 0.0 || value == 1.0) {
            visitor.visitInsn(14 + (int)value);
        } else {
            visitor.visitLdcInsn((Object)value);
        }
    }

    static void loadFloat(MethodVisitor visitor, float value) {
        if (value == 0.0f || value == 1.0f || value == 2.0f) {
            visitor.visitInsn(11 + (int)value);
        } else {
            visitor.visitLdcInsn((Object)Float.valueOf(value));
        }
    }

    static int loadVar(MethodVisitor mw, Class<?> klass, int slot) {
        if (klass == Double.TYPE) {
            mw.visitVarInsn(24, slot);
            return 2;
        }
        if (klass == Long.TYPE) {
            mw.visitVarInsn(22, slot);
            return 2;
        }
        if (klass == Float.TYPE) {
            mw.visitVarInsn(23, slot);
            return 1;
        }
        if (klass == Integer.TYPE || klass == Short.TYPE || klass == Byte.TYPE || klass == Boolean.TYPE) {
            mw.visitVarInsn(21, slot);
            return 1;
        }
        mw.visitVarInsn(25, slot);
        return 1;
    }

    static void validateClass(byte[] bytes, ClassLoader loader) {
        ClassWriterHelpers.validateClass(new ClassReader(bytes), loader);
    }

    static void validateClass(ClassReader reader, ClassLoader loader) {
        if (!ConfigCore.Testing.bytecodeVerify) {
            return;
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        Exception error = null;
        try {
            CheckClassAdapter.verify((ClassReader)reader, (ClassLoader)loader, (boolean)false, (PrintWriter)printWriter);
        }
        catch (Exception e) {
            error = e;
        }
        String contents = writer.toString();
        if (error != null || !contents.isEmpty()) {
            reader.accept((ClassVisitor)new TraceClassVisitor(printWriter), 0);
            throw new IllegalStateException(writer.toString(), error);
        }
    }
}

