/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.methods;

import com.google.common.base.Predicate;
import dan200.computercraft.api.lua.LuaException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.reference.Reference;
import org.squiddev.plethora.gameplay.modules.RangeInfo;
import org.squiddev.plethora.integration.vanilla.meta.MetaEntity;
import org.squiddev.plethora.utils.Helpers;

public final class MethodsSensor {
    private static final Predicate<Entity> DEFAULT_PREDICATE = entity -> entity != null && entity.func_70089_S() && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_175149_v());

    private MethodsSensor() {
    }

    @PlethoraMethod(module={"plethora:sensor"}, doc="function():table -- Scan for entities in the vicinity")
    public static MethodResult sense(IContext<IModuleContainer> context, @FromContext(value={"origin"}) IWorldLocation location, @FromContext(value={"plethora:sensor"}) RangeInfo range) throws LuaException {
        World world = location.getWorld();
        BlockPos pos = location.getPos();
        return context.getCostHandler().await((double)range.getBulkCost(), () -> {
            List entities = world.func_175647_a(Entity.class, MethodsSensor.getBox(pos, range.getRange()), arg_0 -> DEFAULT_PREDICATE.test(arg_0));
            return MethodResult.result(LuaList.of(entities, x -> MetaEntity.getBasicProperties(x, location)).asMap());
        });
    }

    @Optional
    @PlethoraMethod(module={"plethora:sensor"}, doc="-- Find a nearby entity by UUID")
    public static TypedMeta<Entity, ?> getMetaByID(IContext<IModuleContainer> context, @FromContext(value={"origin"}) IWorldLocation location, @FromContext(value={"plethora:sensor"}) RangeInfo range, UUID id) {
        int radius = range.getRange();
        Entity entity = MethodsSensor.findEntityByUUID(location, radius, id);
        return entity == null ? null : context.makeChild(entity, Reference.bounded(entity, location, radius)).getMeta();
    }

    @Optional
    @PlethoraMethod(module={"plethora:sensor"}, doc="-- Find a nearby entity by name")
    public static TypedMeta<Entity, ?> getMetaByName(IContext<IModuleContainer> context, @FromContext(value={"origin"}) IWorldLocation location, @FromContext(value={"plethora:sensor"}) RangeInfo range, String name) {
        int radius = range.getRange();
        Entity entity = MethodsSensor.findEntityByName(location, radius, name);
        return entity == null ? null : context.makeChild(entity, Reference.bounded(entity, location, radius)).getMeta();
    }

    private static AxisAlignedBB getBox(BlockPos pos, int radius) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return new AxisAlignedBB((double)(x - radius), (double)(y - radius), (double)(z - radius), (double)(x + radius), (double)(y + radius), (double)(z + radius));
    }

    @Nullable
    private static Entity findEntityByUUID(IWorldLocation location, int radius, UUID uuid) {
        List entities = location.getWorld().func_175647_a(Entity.class, MethodsSensor.getBox(location.getPos(), radius), entity -> DEFAULT_PREDICATE.test(entity) && entity.func_110124_au().equals(uuid));
        return entities.isEmpty() ? null : (Entity)entities.get(0);
    }

    @Nullable
    private static Entity findEntityByName(IWorldLocation location, int radius, String name) {
        List entities = location.getWorld().func_175647_a(Entity.class, MethodsSensor.getBox(location.getPos(), radius), entity -> DEFAULT_PREDICATE.test(entity) && Helpers.getName(entity).equals(name));
        return entities.isEmpty() ? null : (Entity)entities.get(0);
    }
}

