/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla;

import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import org.squiddev.plethora.integration.PlethoraIntegration;
import org.squiddev.plethora.utils.TypedField;

public final class DisableAI {
    static final ResourceLocation DISABLE_AI = new ResourceLocation("plethora", "disableAI");
    @CapabilityInject(value=IDisableAIHandler.class)
    public static Capability<IDisableAIHandler> DISABLE_AI_CAPABILITY = null;

    private DisableAI() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IDisableAIHandler.class, (Capability.IStorage)new Capability.IStorage<IDisableAIHandler>(){

            public NBTBase writeNBT(Capability<IDisableAIHandler> capability, IDisableAIHandler instance, EnumFacing side) {
                return new NBTTagByte((byte)(instance.isDisabled() ? 1 : 0));
            }

            public void readNBT(Capability<IDisableAIHandler> capability, IDisableAIHandler instance, EnumFacing side, NBTBase nbt) {
                instance.setDisabled(nbt instanceof NBTPrimitive && ((NBTPrimitive)nbt).func_150290_f() == 1);
            }
        }, DefaultDisableAI::new);
    }

    private static class PlethoraEntityLookHelper
    extends EntityLookHelper {
        PlethoraEntityLookHelper(EntityLiving entity) {
            super(entity);
        }

        public void func_75649_a() {
        }
    }

    private static class AIPlethoraObedience
    extends EntityAIBase {
        private static final TypedField<EntityLiving, EntityLookHelper> LOOK_HELPER = TypedField.of(EntityLiving.class, "lookHelper", "field_70749_g");
        private final EntityLiving entity;
        private final IDisableAIHandler handler;
        private final PlethoraEntityLookHelper plethoraLook;
        private EntityLookHelper oldLook;

        AIPlethoraObedience(EntityLiving entity, IDisableAIHandler handler) {
            this.handler = handler;
            this.entity = entity;
            this.plethoraLook = new PlethoraEntityLookHelper(this.entity);
        }

        private boolean isAIDisabled() {
            return this.handler.isDisabled();
        }

        public void func_75249_e() {
            if (this.entity.func_70671_ap() instanceof PlethoraEntityLookHelper) {
                PlethoraIntegration.LOG.error("Look helper is already a PlethoraEntityLookHelper ({})", (Object)this.entity.func_70671_ap());
                return;
            }
            this.oldLook = this.entity.func_70671_ap();
            LOOK_HELPER.set(this.entity, this.plethoraLook);
        }

        public void func_75251_c() {
            if (this.entity.func_70671_ap() instanceof PlethoraEntityLookHelper) {
                LOOK_HELPER.set(this.entity, this.oldLook);
                this.oldLook = null;
            }
        }

        public boolean func_75250_a() {
            return this.func_75253_b();
        }

        public boolean func_75253_b() {
            return this.isAIDisabled();
        }

        public boolean func_75252_g() {
            return !this.isAIDisabled();
        }

        public void func_75246_d() {
        }

        public int func_75247_h() {
            return Integer.MAX_VALUE;
        }
    }

    static class DefaultDisableAI
    implements IDisableAIHandler,
    ICapabilitySerializable<NBTTagCompound> {
        private final EntityLiving entity;
        private boolean disabled;
        private EntityAITasks.EntityAITaskEntry task;

        DefaultDisableAI(EntityLiving entity) {
            this.entity = entity;
        }

        DefaultDisableAI() {
            this.entity = null;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
            return capability == DISABLE_AI_CAPABILITY;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
            return (T)(capability == DISABLE_AI_CAPABILITY ? DISABLE_AI_CAPABILITY.cast((Object)this) : null);
        }

        @Override
        public boolean isDisabled() {
            return this.disabled;
        }

        @Override
        public void setDisabled(boolean value) {
            if (value == this.disabled) {
                return;
            }
            this.disabled = value;
            if (this.entity != null) {
                this.entity.func_70661_as().func_75499_g();
            }
            this.func_73660_a();
        }

        public void func_73660_a() {
            if (!this.disabled || this.entity == null) {
                return;
            }
            if (this.task == null) {
                this.entity.field_70714_bg.func_75776_a(Integer.MIN_VALUE, (EntityAIBase)new AIPlethoraObedience(this.entity, this));
                this.task = this.entity.field_70714_bg.field_75782_a.stream().filter(it -> it.field_75733_a instanceof AIPlethoraObedience).findFirst().orElse(null);
            } else {
                this.entity.field_70714_bg.field_75782_a.add(this.task);
            }
        }

        public NBTTagCompound serializeNBT() {
            if (this.disabled) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74757_a("disabled", true);
                return tag;
            }
            return new NBTTagCompound();
        }

        public void deserializeNBT(NBTTagCompound tag) {
            this.setDisabled(tag != null && tag.func_74767_n("disabled"));
        }
    }

    public static interface IDisableAIHandler
    extends ITickable {
        public boolean isDisabled();

        public void setDisabled(boolean var1);
    }
}

