/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.networking;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.INetworkManager;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.base.impl.networking.ChannelHandler;

@ChannelHandler.Sharable
public class PacketHandler
extends SimpleChannelInboundHandler<PregenPacket>
implements INetworkManager {
    private EnumMap<Side, FMLEmbeddedChannel> channel;
    ChannelHandler manager;

    @Override
    public INetworkManager init() {
        this.manager = new ChannelHandler();
        this.channel = NetworkRegistry.INSTANCE.newChannel("chunkpregenerator", new io.netty.channel.ChannelHandler[]{this.manager, this});
        return this;
    }

    @Override
    public void registerPacket(Class<? extends PregenPacket> packet) {
        this.manager.registerPacket(packet);
    }

    @Override
    public void sendPacketToServer(PregenPacket packet) {
        this.channel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channel.get(Side.CLIENT).writeOutbound(new Object[]{packet});
    }

    @Override
    public void sendPacketToPlayer(PregenPacket packet, EntityPlayer player) {
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channel.get(Side.SERVER).writeOutbound(new Object[]{packet});
    }

    protected void channelRead0(ChannelHandlerContext ctx, PregenPacket msg) throws Exception {
        INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        if (netHandler == null) {
            throw new RuntimeException("No nethandler found: " + ctx);
        }
        msg.handle(this.getPlayer(netHandler));
    }

    public EntityPlayer getPlayer(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)handler).field_147369_b;
        }
        return ChunkPregenerator.proxy.getClientPlayer();
    }
}

