/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.management;

import ic2.api.recipe.IRecipeInput;
import ic2.core.Direction;
import ic2.core.RotationList;
import ic2.core.block.personal.base.misc.IPersonalInventory;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.base.IRotatingInventory;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.BasicHandlerInstance;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.IInventoryModifier;
import ic2.core.inventory.management.IModularSlot;
import ic2.core.inventory.management.InternalInventoryHandler;
import ic2.core.inventory.management.ModularInventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.util.helpers.FilteredList;
import ic2.core.util.math.MathUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class InventoryHandler
implements IHasHandler.IInventoryHandler {
    List<Integer> registeredSlots = new FilteredList<Integer>();
    Map<SlotType, List<Integer>> typeToSlot = new Object2ObjectLinkedOpenHashMap();
    Int2ObjectMap<AccessRule> defaultSlotAccess = new Int2ObjectOpenHashMap();
    Map<EnumFacing, List<Integer>> defaultSlots = new EnumMap<EnumFacing, List<Integer>>(EnumFacing.class);
    Map<EnumFacing, AccessRule> defaultAccess = new EnumMap<EnumFacing, AccessRule>(EnumFacing.class);
    Int2ObjectMap<AccessRule> defaultOverride = new Int2ObjectOpenHashMap();
    Map<EnumFacing, IModularSlot> modularSlots = new EnumMap<EnumFacing, IModularSlot>(EnumFacing.class);
    Map<EnumFacing, List<Integer>> slots = new EnumMap<EnumFacing, List<Integer>>(EnumFacing.class);
    Int2ObjectMap<IFilter> slotInputFilter = new Int2ObjectOpenHashMap();
    Int2ObjectMap<IFilter> slotOutputFilter = new Int2ObjectOpenHashMap();
    Int2ObjectMap<Map<EnumFacing, AccessRule>> customAccess = new Int2ObjectOpenHashMap();
    Map<EnumFacing, AccessRule> inventoryAccess = new EnumMap<EnumFacing, AccessRule>(EnumFacing.class);
    Set<EnumFacing> locktSides = EnumSet.noneOf(EnumFacing.class);
    Map<EnumFacing, IItemHandler> handlers = new EnumMap<EnumFacing, IItemHandler>(EnumFacing.class);
    IHasInventory inventory;
    IRotatingInventory prov;
    boolean rotationEnabled = true;
    boolean dissableSlotModify = false;
    boolean dissableRedstone = false;
    boolean forceNoDuplicates = false;
    boolean allowOnlyOneStack = false;
    List<IRecipeInput> inputs = new LinkedList<IRecipeInput>();
    int maxStackSizeMod = -1;
    IPersonalInventory upgrades = new PersonalInventory(5);
    InternalInventoryHandler internal = new InternalInventoryHandler(this);

    public InventoryHandler(IHasInventory inv) {
        this.inventory = inv;
        if (inv instanceof IRotatingInventory) {
            this.prov = (IRotatingInventory)((Object)inv);
        }
    }

    public IHasInventory getUpgradeSlots() {
        return this.upgrades;
    }

    public void validateSlots() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.defaultAccess.putIfAbsent(facing, AccessRule.Both);
            if (this.locktSides.contains(facing)) {
                this.handlers.put(facing, new ModularInventoryHandler(this, facing, this.modularSlots.get(facing)));
                continue;
            }
            List<Integer> list = this.defaultSlots.get(facing);
            if (list == null) {
                list = new FilteredList<Integer>();
                this.defaultSlots.put(facing, list);
            }
            list = new FilteredList<Integer>((Collection<Integer>)list);
            Collections.sort(list);
            this.slots.put(facing, list);
            this.handlers.put(facing, new BasicHandlerInstance(this, facing, list));
        }
        this.mergeAccessMap(this.defaultAccess, this.inventoryAccess);
        this.mergeSlotAccess(this.defaultSlotAccess, this.customAccess, false);
    }

    public void registerSlotType(SlotType type, int ... slots) {
        List<Integer> list = this.typeToSlot.get(type);
        if (list == null) {
            list = new FilteredList<Integer>();
            this.typeToSlot.put(type, list);
        }
        for (int slot : slots) {
            list.add(slot);
            this.registeredSlots.add(slot);
        }
    }

    public void registerDefaultSlotAccess(AccessRule rule, int ... slots) {
        for (int slot : slots) {
            this.defaultSlotAccess.put(slot, (Object)rule);
        }
    }

    public void registerDefaultSideAccess(AccessRule rule, RotationList rotation) {
        for (EnumFacing side : rotation) {
            this.defaultAccess.put(side, rule);
        }
    }

    public void registerDefaultSlotsForSide(RotationList rotation, int ... slots) {
        for (EnumFacing side : rotation) {
            if (this.locktSides.contains(side)) continue;
            List<Integer> list = this.defaultSlots.get(side);
            if (list == null) {
                list = new FilteredList<Integer>();
                this.defaultSlots.put(side, list);
            }
            for (int slot : slots) {
                list.add(slot);
            }
        }
    }

    public void registerDefaultOverride(AccessRule rule, int ... slots) {
        for (int slot : slots) {
            this.defaultOverride.put(slot, (Object)rule);
        }
    }

    public void registerInputFilter(IFilter filter, int ... slots) {
        for (int slot : slots) {
            this.slotInputFilter.put(slot, (Object)filter);
        }
    }

    public void registerOutputFilter(IFilter filter, int ... slots) {
        for (int slot : slots) {
            this.slotOutputFilter.put(slot, (Object)filter);
        }
    }

    public void registerModularSlot(RotationList rotation, IModularSlot slot) {
        for (EnumFacing side : rotation) {
            this.locktSides.add(side);
            this.defaultSlots.remove(side);
            this.modularSlots.put(side, slot);
        }
    }

    @Override
    public void modifySideAccess(RotationList rotation, AccessRule rule) {
        for (EnumFacing side : rotation) {
            if (!this.defaultAccess.get(side).canWorkWith(rule)) continue;
            this.inventoryAccess.put(side, rule);
        }
    }

    @Override
    public void clearSide(RotationList list) {
        for (EnumFacing side : list) {
            if (this.locktSides.contains(side)) continue;
            this.slots.get(side).clear();
        }
    }

    @Override
    public void setTypeToSide(RotationList list, SlotType type) {
        List<Integer> slotList = this.typeToSlot.get(type);
        if (slotList == null || slotList.isEmpty()) {
            return;
        }
        for (EnumFacing side : list) {
            if (this.locktSides.contains(side)) continue;
            List<Integer> mapList = this.slots.get(side);
            mapList.addAll(slotList);
            Collections.sort(mapList);
        }
    }

    @Override
    public void clearTypeForSide(RotationList list, SlotType type) {
        List<Integer> slotList = this.typeToSlot.get(type);
        if (slotList == null || slotList.isEmpty()) {
            return;
        }
        for (EnumFacing side : list) {
            if (this.locktSides.contains(side)) continue;
            this.slots.get(side).removeAll(slotList);
        }
    }

    @Override
    public boolean canModifySlotSide(EnumFacing side) {
        return !this.locktSides.contains(side);
    }

    @Override
    public void addSlotsForSide(RotationList sides, int ... slotIDs) {
        List<Integer> list = MathUtil.fromIntToInteger(slotIDs);
        for (EnumFacing side : sides) {
            if (this.locktSides.contains(side)) continue;
            List<Integer> mapList = this.slots.get(side);
            mapList.addAll(list);
            Collections.sort(mapList);
        }
    }

    @Override
    public void removeSlotsForSide(RotationList sides, int ... slotIDs) {
        List<Integer> list = MathUtil.fromIntToInteger(slotIDs);
        for (EnumFacing side : sides) {
            if (this.locktSides.contains(side)) continue;
            this.slots.get(side).removeAll(list);
        }
    }

    @Override
    public void setAccessRuleForSlots(RotationList sides, AccessRule newRule, int ... slotIDs) {
        for (int slot : slotIDs) {
            AccessRule master = (AccessRule)((Object)this.defaultSlotAccess.get(slot));
            if (!master.canWorkWith(newRule)) continue;
            Map rules = (Map)this.customAccess.get(slot);
            for (EnumFacing side : sides) {
                if (this.locktSides.contains(side)) continue;
                rules.put(side, newRule);
            }
        }
    }

    @Override
    public String getInventoryID() {
        return this.inventory.getClass().getCanonicalName();
    }

    public Set<SlotType> getSlotTypes() {
        return this.typeToSlot.keySet();
    }

    @Override
    public void dissableStrongRedstone() {
        this.dissableRedstone = true;
    }

    @Override
    public void dissableRotation() {
        this.rotationEnabled = false;
    }

    public void dissableSlotModifiers() {
        this.dissableSlotModify = true;
    }

    @Override
    public void forceNoDuplicates() {
        this.forceNoDuplicates = true;
    }

    @Override
    public void allowOnlyOneStack() {
        this.allowOnlyOneStack = true;
    }

    @Override
    public void registerFilter(IRecipeInput input) {
        this.inputs.add(input);
    }

    @Override
    public void setMaxStacksizeModifier(int mod) {
        this.maxStackSizeMod = mod;
    }

    public boolean isBlockingStrong() {
        return this.dissableRedstone;
    }

    public boolean isAllowOnlyOneStack() {
        return this.allowOnlyOneStack;
    }

    public boolean isForceNoDuplicates() {
        return this.forceNoDuplicates;
    }

    @Override
    public boolean canModifySlots() {
        return !this.dissableSlotModify;
    }

    @Override
    public List<Integer> getAllSlots() {
        return this.registeredSlots;
    }

    @Override
    public List<Integer> getAccessableSlotsForSide(EnumFacing side) {
        if (this.locktSides.contains(side)) {
            return new ArrayList<Integer>();
        }
        return this.slots.get(side);
    }

    @Override
    public AccessRule getSideAccess(EnumFacing side) {
        return this.inventoryAccess.get(side);
    }

    public AccessRule getDefaultAccess(EnumFacing side) {
        return this.defaultAccess.get(side);
    }

    public AccessRule getMasterSlotRule(int slot) {
        return (AccessRule)((Object)this.defaultSlotAccess.get(slot));
    }

    @Override
    public Map<EnumFacing, AccessRule> getSlotRules(int slot) {
        return (Map)this.customAccess.get(slot);
    }

    @Override
    public List<Integer> getSlotsForType(SlotType type) {
        return this.typeToSlot.get(type);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.upgrades.writeToNBT(this.getTag(nbt, "Upgrades"));
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.upgrades.readFromNBT(nbt.func_74775_l("Upgrades"));
        this.resetSlots();
    }

    public void onSlotChange() {
        this.resetSlots();
    }

    private void resetSlots() {
        List<Integer> list;
        this.mergeAccessMap(this.defaultAccess, this.inventoryAccess);
        this.mergeSlotAccess(this.defaultSlotAccess, this.customAccess, true);
        this.mergeSlotAccess(this.defaultOverride, this.customAccess, true);
        this.rotationEnabled = true;
        this.dissableRedstone = false;
        this.forceNoDuplicates = false;
        this.allowOnlyOneStack = false;
        this.maxStackSizeMod = -1;
        this.inputs.clear();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.locktSides.contains(facing)) continue;
            list = this.defaultSlots.get(facing);
            if (list == null) {
                list = new FilteredList<Integer>();
                this.defaultSlots.put(facing, list);
            }
            list = new FilteredList<Integer>((Collection<Integer>)list);
            Collections.sort(list);
            this.slots.put(facing, list);
        }
        for (int i = 0; i < this.upgrades.getSlotCount(); ++i) {
            ItemStack stack = this.upgrades.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof IInventoryModifier)) continue;
            IInventoryModifier mod = (IInventoryModifier)stack.func_77973_b();
            mod.onInstalling(stack, this);
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.locktSides.contains(facing)) {
                this.handlers.put(facing, new ModularInventoryHandler(this, facing, this.modularSlots.get(facing)));
                continue;
            }
            list = this.slots.get(facing);
            Collections.sort(list);
            this.handlers.put(facing, new BasicHandlerInstance(this, facing, list));
        }
    }

    private EnumFacing getRealFacing(EnumFacing input) {
        if (this.prov == null || !this.prov.supportsRotation() || !this.rotationEnabled) {
            return input;
        }
        EnumFacing axis = this.prov.getFacing();
        if (axis == null) {
            return input;
        }
        EnumFacing result = Direction.rotate(axis, input);
        return result;
    }

    private void mergeAccessMap(Map<EnumFacing, AccessRule> key, Map<EnumFacing, AccessRule> value) {
        for (Map.Entry<EnumFacing, AccessRule> entry : key.entrySet()) {
            value.put(entry.getKey(), entry.getValue());
        }
    }

    private void mergeSlotAccess(Int2ObjectMap<AccessRule> key, Int2ObjectMap<Map<EnumFacing, AccessRule>> value, boolean override) {
        for (Map.Entry entry : key.entrySet()) {
            EnumMap rule = (EnumMap)value.get(entry.getKey());
            if (rule == null) {
                rule = new EnumMap(EnumFacing.class);
                value.put(entry.getKey(), rule);
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (override) {
                    rule.put(facing, entry.getValue());
                    continue;
                }
                rule.putIfAbsent(facing, entry.getValue());
            }
        }
    }

    private NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public boolean hasInventory(EnumFacing facing) {
        if (facing == null) {
            return true;
        }
        EnumFacing side = this.getRealFacing(facing);
        return this.inventoryAccess.get(side) != AccessRule.None && (this.locktSides.contains(side) || this.slots.get(side).size() > 0);
    }

    public IItemHandler getInventory(EnumFacing facing) {
        if (facing == null) {
            return this.internal;
        }
        return this.handlers.get(this.getRealFacing(facing));
    }

    IHasInventory getInventory() {
        return this.inventory;
    }

    AccessRule getAccess(int slot, EnumFacing side) {
        return (AccessRule)((Object)((Map)this.customAccess.get(slot)).get(side));
    }

    IFilter getInputFilter(int slot) {
        return (IFilter)this.slotInputFilter.get(slot);
    }

    IFilter getOutputFilter(int slot) {
        return (IFilter)this.slotOutputFilter.get(slot);
    }

    List<IRecipeInput> getInputLimits() {
        return this.inputs;
    }

    int getInputLimit() {
        return this.maxStackSizeMod;
    }
}

