/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric.scanners;

import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.inv.inventories.FluidScannerInv;
import ic2.core.item.tool.electric.scanners.IScanner;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class FilteredFluidScanner
implements IScanner,
IHandHeldInventory {
    @Override
    public boolean isAdv(ItemStack stack) {
        return true;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state) {
        Material mat;
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            return this.getFluids(stack).contains(((IFluidBlock)block).getFluid()) ? 1 : 0;
        }
        if (block instanceof BlockStaticLiquid && block.func_176201_c(state) == 0 && ((mat = state.func_185904_a()) == Material.field_151587_i || mat == Material.field_151586_h)) {
            return this.getFluids(stack).contains(mat == Material.field_151587_i ? FluidRegistry.LAVA : FluidRegistry.WATER) ? 1 : 0;
        }
        return 0;
    }

    @Override
    public int getOreValue(ItemStack stack, IBlockState state, World world, BlockPos pos) {
        Material mat;
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            IFluidBlock fluid = (IFluidBlock)block;
            if (fluid.canDrain(world, pos)) {
                FluidStack fluidStack = fluid.drain(world, pos, false);
                return fluidStack != null && this.getFluids(stack).contains(fluidStack.getFluid()) ? 1 : 0;
            }
        } else if (block instanceof BlockStaticLiquid && block.func_176201_c(state) == 0 && ((mat = state.func_185904_a()) == Material.field_151587_i || mat == Material.field_151586_h)) {
            return this.getFluids(stack).contains(mat == Material.field_151587_i ? FluidRegistry.LAVA : FluidRegistry.WATER) ? 1 : 0;
        }
        return 0;
    }

    @Override
    public Set<IBlockState> getTargets(ItemStack stack) {
        return EMPTY_STATES;
    }

    @Override
    public int getRadius(ItemStack stack) {
        return 20;
    }

    @Override
    public int getCost(ItemStack stack) {
        return 100;
    }

    @Override
    public boolean isValue(ItemStack stack) {
        return false;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean isFluidScanner(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isFluidValid(ItemStack stack, FluidStack fluid) {
        return this.getFluids(stack).contains(fluid.getFluid());
    }

    @Override
    public Set<Fluid> getFluidTargets(ItemStack stack) {
        return this.getFluids(stack);
    }

    @Override
    public LocaleComp getName(ItemStack stack) {
        return Ic2ItemLang.scannerFluidFiltered;
    }

    @Override
    public boolean hasCustomInfo(ItemStack stack) {
        return false;
    }

    @Override
    public boolean addCustomInfo(ItemStack stack, EntityPlayer player, List<String> list, List<String> post, Map<ToolTipType, List<String>> sortedTooltip) {
        return false;
    }

    @Override
    public boolean showTargets(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasRightClick(ItemStack stack) {
        return true;
    }

    @Override
    public boolean onRightClick(ItemStack stack, EntityPlayer player, EnumHand hand, World world) {
        if (IC2.keyboard.isSideinventoryKeyDown(player)) {
            IC2.platform.launchGui(player, this.getInventory(player, hand, stack), hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAOE(ItemStack stack) {
        return true;
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new FluidScannerInv(player, this, stack);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    public Set<Fluid> getFluids(ItemStack stack) {
        LinkedHashSet<Fluid> result = new LinkedHashSet<Fluid>();
        NBTTagList list = StackUtil.getNbtData(stack).func_150295_c("FluidData", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)list.func_150305_b(i));
            if (fluid == null || fluid.getFluid() == null) continue;
            result.add(fluid.getFluid());
        }
        return result;
    }
}

