/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon;

import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.DungeonConfiguration;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.RoomEmptyIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.RoomTreasureIo;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class RoomChestIo
extends RoomEmptyIo {
    public RoomChestIo() {
    }

    public RoomChestIo(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, EnumFacing entranceDir) {
        this(configuration, rand, blockPosX, blockPosZ, rand.nextInt(4) + 14, configuration.getRoomHeight(), rand.nextInt(4) + 14, entranceDir);
    }

    public RoomChestIo(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing entranceDir) {
        super(configuration, rand, blockPosX, blockPosZ, sizeX, sizeY, sizeZ, entranceDir);
    }

    @Override
    public boolean func_74875_a(World worldIn, Random rand, StructureBoundingBox boundingBox) {
        if (super.func_74875_a(worldIn, rand, boundingBox)) {
            int chestX = this.sizeX / 2;
            int chestY = 3;
            int chestZ = this.sizeZ / 2;
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    if (x != -3 && x != 2 || z != -3 && z != 2) continue;
                    this.func_175811_a(worldIn, Blocks.field_150403_cj.func_176223_P(), chestX + x, 1, chestZ + z, boundingBox);
                }
            }
            this.func_175811_a(worldIn, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)this.getDirection().func_176734_d()), chestX, chestY, chestZ, boundingBox);
            BlockPos blockpos = new BlockPos(this.func_74865_a(chestX, chestZ), this.func_74862_a(chestY), this.func_74873_b(chestX, chestZ));
            TileEntityChest chest = (TileEntityChest)worldIn.func_175625_s(blockpos);
            if (chest != null) {
                ResourceLocation chesttype = RoomTreasureIo.IOCHEST;
                if (worldIn.field_73011_w instanceof IGalacticraftWorldProvider) {
                    chesttype = ((IGalacticraftWorldProvider)worldIn.field_73011_w).getDungeonChestType();
                }
                chest.func_189404_a(chesttype, rand.nextLong());
            }
            this.func_175811_a(worldIn, Blocks.field_150474_ac.func_176223_P(), chestX, chestY - 1, chestZ, boundingBox);
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)worldIn.func_175625_s(blockpos.func_177984_a());
            if (spawner != null) {
                spawner.func_145881_a().func_190894_a(RoomChestIo.getMob(rand));
            }
            return true;
        }
        return false;
    }

    private static ResourceLocation getMob(Random rand) {
        switch (rand.nextInt(4)) {
            case 0: {
                return new ResourceLocation("galacticraftcore", "evolved_spider");
            }
            case 1: {
                return new ResourceLocation("galacticraftcore", "evolved_creeper");
            }
            case 2: {
                return new ResourceLocation("galacticraftcore", "evolved_skeleton");
            }
        }
        return new ResourceLocation("galacticraftcore", "evolved_zombie");
    }
}

