/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.TextBoxNumber;
import vswe.superfactory.components.TextBoxNumberList;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuInterval
extends ComponentMenu {
    private static final int MENU_WIDTH = 120;
    private static final String NBT_INTERVAL = "Interval";
    private static final int TEXT_BOX_X = 15;
    private static final int TEXT_BOX_Y = 35;
    private static final int TEXT_MARGIN_X = 5;
    private static final int TEXT_SECONDS_X = 60;
    private static final int TEXT_SECOND_Y = 38;
    private static final int TEXT_Y = 10;
    private static final int TEXT_Y2 = 15;
    private TextBoxNumber interval;
    private TextBoxNumberList textBoxes = new TextBoxNumberList();

    public ComponentMenuInterval(FlowComponent parent) {
        super(parent);
        this.interval = new TextBoxNumber(15, 35, 3, true){

            @Override
            public void onNumberChanged() {
                DataWriter dw = ComponentMenuInterval.this.getWriterForServerComponentPacket();
                dw.writeData(this.getNumber(), DataBitHelper.MENU_INTERVAL);
                PacketHandler.sendDataToServer(dw);
            }
        };
        this.textBoxes.addTextBox(this.interval);
        this.interval.setNumber(1);
    }

    @Override
    public String getName() {
        return Localization.INTERVAL_MENU.toString();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        gui.drawSplitString(Localization.INTERVAL_INFO.toString(), 5, 10, 110, 0.7f, 0x404040);
        gui.drawString(Localization.SECOND.toString(), 60, 38, 0.7f, 0x404040);
        this.textBoxes.draw(gui, mX, mY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        this.textBoxes.onClick(mX, mY, button);
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        return this.textBoxes.onKeyStroke(gui, c, k);
    }

    @Override
    public void writeData(DataWriter dw) {
        int val = this.getInterval();
        if (val == 0) {
            val = 1;
        }
        dw.writeData(val, DataBitHelper.MENU_INTERVAL);
    }

    @Override
    public void readData(DataReader dr) {
        this.setInterval(dr.readData(DataBitHelper.MENU_INTERVAL));
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        this.setInterval(((ComponentMenuInterval)menu).getInterval());
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        ComponentMenuInterval newDataInterval = (ComponentMenuInterval)newData;
        if (newDataInterval.getInterval() != this.getInterval()) {
            this.setInterval(newDataInterval.getInterval());
            DataWriter dw = this.getWriterForClientComponentPacket(container);
            dw.writeData(this.getInterval(), DataBitHelper.MENU_INTERVAL);
            PacketHandler.sendDataToListeningClients(container, dw);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        this.setInterval(nbtTagCompound.func_74765_d(NBT_INTERVAL));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        nbtTagCompound.func_74777_a(NBT_INTERVAL, (short)this.getInterval());
    }

    public int getInterval() {
        return this.interval.getNumber();
    }

    public void setInterval(int val) {
        this.interval.setNumber(val);
    }

    @Override
    public void readNetworkComponent(DataReader dr) {
        this.setInterval(dr.readData(DataBitHelper.MENU_INTERVAL));
    }
}

