/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.api.item.IColorableItem;
import cofh.api.item.IMultiModeItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class ItemMultiRF
extends ItemMulti
implements IColorableItem,
IEnchantableItem,
IEnergyContainerItem,
IMultiModeItem {
    public static final int CAPACITY_MIN = 10000;
    public static final int CAPACITY_MAX = 10000000;
    public static final int XFER_MIN = 100;
    public static final int XFER_MAX = 1000000;

    public ItemMultiRF(String modName) {
        super(modName);
    }

    public ItemStack setDefaultTag(ItemStack stack, int energy) {
        return EnergyHelper.setDefaultEnergyTag(stack, energy);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return !EnumEnchantmentType.BREAKABLE.equals((Object)enchantment.field_77351_y) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public boolean func_77645_m() {
        return true;
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !ItemMultiRF.isCreative(stack) && this.getEnergyStored(stack) > 0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            this.setDefaultTag(stack, 0);
        }
        return MathHelper.clamp(1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack), 0.0, 1.0);
    }

    protected abstract int getCapacity(ItemStack var1);

    protected abstract int getReceive(ItemStack var1);

    @Override
    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return !ItemMultiRF.isCreative(stack) && enchantment == CoreEnchantments.holding;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container, 0);
        }
        int stored = Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
        int receive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.getReceive(container)));
        if (!simulate && !ItemMultiRF.isCreative(container)) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container, 0);
        }
        if (ItemMultiRF.isCreative(container)) {
            return maxExtract;
        }
        int stored = Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container, 0);
        }
        return Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getCapacity(container);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }
}

