/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.shapes.BeaconType;
import mcjty.rftools.shapes.ScanDataManagerClient;
import mcjty.rftools.shapes.ScanExtraData;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketReturnExtraData
implements IMessage {
    private int scanId;
    private ScanExtraData data;

    public void fromBytes(ByteBuf buf) {
        this.scanId = buf.readInt();
        int size = buf.readInt();
        if (size == -1) {
            this.data = null;
        } else {
            this.data = new ScanExtraData();
            for (int i = 0; i < size; ++i) {
                BlockPos pos = NetworkTools.readPos((ByteBuf)buf);
                BeaconType type = BeaconType.VALUES[buf.readByte()];
                boolean doBeacon = buf.readBoolean();
                this.data.addBeacon(pos, type, doBeacon);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.scanId);
        if (this.data == null) {
            buf.writeInt(-1);
        } else {
            List<ScanExtraData.Beacon> beacons = this.data.getBeacons();
            buf.writeInt(beacons.size());
            for (ScanExtraData.Beacon beacon : beacons) {
                NetworkTools.writePos((ByteBuf)buf, (BlockPos)beacon.getPos());
                buf.writeByte(beacon.getType().ordinal());
                buf.writeBoolean(beacon.isDoBeacon());
            }
        }
    }

    public PacketReturnExtraData() {
    }

    public PacketReturnExtraData(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketReturnExtraData(int scanId, ScanExtraData extraData) {
        this.scanId = scanId;
        this.data = extraData;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> ScanDataManagerClient.getScansClient().registerExtraDataFromServer(this.scanId, this.data));
        ctx.setPacketHandled(true);
    }
}

