/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.math.geometry;

import net.machinemuse.numina.math.geometry.MusePoint2D;

public class SpiralPointToPoint2D
extends MusePoint2D {
    protected final MusePoint2D center;
    protected final long spawnTime;
    protected final double timeTo;
    protected final boolean outwards;
    protected final double spiral = Math.PI;
    protected double radius;
    protected double rotation;

    public SpiralPointToPoint2D(double x, double y, double x2, double y2, double timeTo, boolean outwards) {
        super(x2, y2);
        this.center = new MusePoint2D(x, y);
        this.radius = this.distanceTo(this.center);
        this.rotation = Math.atan2(y2 - y, x2 - x);
        this.spawnTime = System.currentTimeMillis();
        this.timeTo = timeTo;
        this.outwards = outwards;
    }

    public SpiralPointToPoint2D(double x, double y, double x2, double y2, double timeTo) {
        this(x, y, x2, y2, timeTo, true);
    }

    public SpiralPointToPoint2D(MusePoint2D center, MusePoint2D target, double timeTo, boolean outwards) {
        this(center.getX(), center.getY(), target.getX(), target.getY(), timeTo, outwards);
    }

    public SpiralPointToPoint2D(MusePoint2D center, MusePoint2D target, double timeTo) {
        this(center, target, timeTo, true);
    }

    public SpiralPointToPoint2D(MusePoint2D center, double radius, double rotation, double timeTo, boolean outward) {
        this(center.getX(), center.getY(), radius * Math.cos(rotation), radius * Math.sin(rotation), timeTo, outward);
        this.radius = radius;
        this.rotation = rotation;
    }

    public SpiralPointToPoint2D(MusePoint2D center, double radius, double rotation, double timeTo) {
        this(center, radius, rotation, timeTo, true);
    }

    private double getRatio() {
        long elapsed = System.currentTimeMillis() - this.spawnTime;
        double ratio = (double)elapsed / this.timeTo;
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        if (this.outwards) {
            return ratio;
        }
        return 1.0 - ratio;
    }

    private double getTheta() {
        return this.rotation + Math.PI * (1.0 - this.getRatio());
    }

    @Override
    public double getX() {
        return this.center.getX() + this.radius * this.getRatio() * Math.cos(this.getTheta());
    }

    @Override
    public double getY() {
        return this.center.getY() + this.radius * this.getRatio() * Math.sin(this.getTheta());
    }
}

