/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.refinedstorage;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.method.ContextHelpers;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.integration.refinedstorage.MetaItemPattern;
import org.squiddev.plethora.utils.WorldDummy;

@Injects(value="refinedstorage")
public final class MetaCraftingPattern
extends BaseMetaProvider<ICraftingPattern> {
    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IPartialContext<ICraftingPattern> context) {
        ICraftingPattern pattern = context.getTarget();
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put("id", pattern.getId());
        out.put("outputs", ContextHelpers.getMetaList(context, pattern.getOutputs()));
        out.put("fluidInputs", ContextHelpers.getMetaList(context, pattern.getFluidInputs()));
        out.put("fluidOutputs", ContextHelpers.getMetaList(context, pattern.getFluidOutputs()));
        out.put("byproducts", ContextHelpers.getMetaList(context, pattern.getByproducts()));
        out.put("oredict", pattern.isOredict());
        out.put("processing", pattern.isProcessing());
        out.put("valid", pattern.isValid());
        out.put("inputs", LuaList.of(pattern.getInputs(), x -> x.isEmpty() ? null : ContextHelpers.getMetaList(context, x)).asMap());
        return out;
    }

    @Override
    @Nullable
    public ICraftingPattern getExample() {
        return ItemPattern.getPatternFromCache((World)WorldDummy.INSTANCE, (ItemStack)MetaItemPattern.getExampleStack());
    }
}

