/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvanced;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public abstract class BlockTransmitter
extends BlockAdvanced {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");

    public BlockTransmitter(Material material) {
        super(material);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        TileEntity tile = worldIn.func_175625_s(pos);
        GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_WIRE_BOUNDS, GCCoreUtil.getDimensionID(worldIn), new Object[]{pos}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(worldIn), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0));
        if (tile instanceof INetworkConnection) {
            ((INetworkConnection)tile).refresh();
        }
    }

    public abstract NetworkType getNetworkType(IBlockState var1);

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof ITransmitter) {
            TileEntity[] connectable = new TileEntity[6];
            switch (this.getNetworkType(state)) {
                case FLUID: {
                    connectable = OxygenUtil.getAdjacentFluidConnections(tileEntity);
                    break;
                }
                case POWER: {
                    connectable = EnergyUtil.getAdjacentPowerConnections(tileEntity);
                    break;
                }
            }
            return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(connectable[EnumFacing.DOWN.ordinal()] != null)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(connectable[EnumFacing.UP.ordinal()] != null)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(connectable[EnumFacing.NORTH.ordinal()] != null)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(connectable[EnumFacing.EAST.ordinal()] != null)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(connectable[EnumFacing.SOUTH.ordinal()] != null)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(connectable[EnumFacing.WEST.ordinal()] != null));
        }
        return state;
    }
}

