/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.init.NCItems;
import nc.network.tile.ProcessorUpdatePacket;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.IGui;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.tile.processor.IItemFluidProcessor;
import nc.tile.processor.IProcessor;
import nc.tile.processor.IUpgradable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class TileItemFluidProcessor
extends TileEnergyFluidSidedInventory
implements IItemFluidProcessor,
IGui<ProcessorUpdatePacket>,
IUpgradable {
    public final int defaultProcessTime;
    public final int defaultProcessPower;
    public double baseProcessTime;
    public double baseProcessPower;
    public double baseProcessRadiation;
    public final int itemInputSize;
    public final int fluidInputSize;
    public final int itemOutputSize;
    public final int fluidOutputSize;
    public double time;
    public boolean isProcessing;
    public boolean canProcessInputs;
    public final boolean shouldLoseProgress;
    public final boolean hasUpgrades;
    public final int processorID;
    public final int sideConfigYOffset;
    public final ProcessorRecipeHandler recipeHandler;
    protected RecipeInfo<ProcessorRecipe> recipeInfo;
    protected Set<EntityPlayer> playersToUpdate;

    public TileItemFluidProcessor(String name, int itemInSize, int fluidInSize, int itemOutSize, int fluidOutSize, @Nonnull List<ItemSorption> itemSorptions, @Nonnull List<Integer> fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluids, int time, int power, boolean shouldLoseProgress, @Nonnull ProcessorRecipeHandler recipeHandler, int processorID, int sideConfigYOffset) {
        this(name, itemInSize, fluidInSize, itemOutSize, fluidOutSize, itemSorptions, fluidCapacity, tankSorptions, allowedFluids, time, power, shouldLoseProgress, true, recipeHandler, processorID, sideConfigYOffset);
    }

    public TileItemFluidProcessor(String name, int itemInSize, int fluidInSize, int itemOutSize, int fluidOutSize, @Nonnull List<ItemSorption> itemSorptions, @Nonnull List<Integer> fluidCapacity, @Nonnull List<TankSorption> tankSorptions, List<List<String>> allowedFluids, int time, int power, boolean shouldLoseProgress, boolean upgrades, @Nonnull ProcessorRecipeHandler recipeHandler, int processorID, int sideConfigYOffset) {
        super(name, itemInSize + itemOutSize + (upgrades ? 2 : 0), ITileInventory.inventoryConnectionAll(itemSorptions), IProcessor.getCapacity(recipeHandler, time, 1.0, power, 1.0), power != 0 ? ITileEnergy.energyConnectionAll(EnergyConnection.IN) : ITileEnergy.energyConnectionAll(EnergyConnection.NON), fluidCapacity, fluidCapacity, allowedFluids, ITileFluid.fluidConnectionAll(tankSorptions));
        this.itemInputSize = itemInSize;
        this.fluidInputSize = fluidInSize;
        this.itemOutputSize = itemOutSize;
        this.fluidOutputSize = fluidOutSize;
        this.defaultProcessTime = time;
        this.defaultProcessPower = power;
        this.baseProcessTime = time;
        this.baseProcessPower = power;
        this.shouldLoseProgress = shouldLoseProgress;
        this.hasUpgrades = upgrades;
        this.processorID = processorID;
        this.sideConfigYOffset = sideConfigYOffset;
        this.setInputTanksSeparated(fluidInSize > 1);
        this.recipeHandler = recipeHandler;
        this.playersToUpdate = new ObjectOpenHashSet();
    }

    public static List<ItemSorption> defaultItemSorptions(int inSize, int outSize, boolean upgrades) {
        int i;
        ArrayList<ItemSorption> itemSorptions = new ArrayList<ItemSorption>();
        for (i = 0; i < inSize; ++i) {
            itemSorptions.add(ItemSorption.IN);
        }
        for (i = 0; i < outSize; ++i) {
            itemSorptions.add(ItemSorption.OUT);
        }
        if (upgrades) {
            itemSorptions.add(ItemSorption.IN);
            itemSorptions.add(ItemSorption.IN);
        }
        return itemSorptions;
    }

    public static List<Integer> defaultTankCapacities(int capacity, int inSize, int outSize) {
        ArrayList<Integer> tankCapacities = new ArrayList<Integer>();
        for (int i = 0; i < inSize + outSize; ++i) {
            tankCapacities.add(capacity);
        }
        return tankCapacities;
    }

    public static List<TankSorption> defaultTankSorptions(int inSize, int outSize) {
        int i;
        ArrayList<TankSorption> tankSorptions = new ArrayList<TankSorption>();
        for (i = 0; i < inSize; ++i) {
            tankSorptions.add(TankSorption.IN);
        }
        for (i = 0; i < outSize; ++i) {
            tankSorptions.add(TankSorption.OUT);
        }
        return tankSorptions;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.refreshUpgrades();
            this.isProcessing = this.isProcessing();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateProcessor();
    }

    public void updateProcessor() {
        if (!this.field_145850_b.field_72995_K) {
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            boolean shouldUpdate = false;
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
                if (!(!(this.time > 0.0) || this.isHaltedByRedstone() && this.readyToProcess())) {
                    this.loseProgress();
                }
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
                this.updateBlockType();
                this.sendUpdateToAllPlayers();
            }
            this.sendUpdateToListeningPlayers();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void updateBlockType() {
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
        this.setState(this.isProcessing, this);
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    @Override
    public void refreshRecipe() {
        this.recipeInfo = this.recipeHandler.getRecipeInfoFromInputs(this.getItemInputs(), this.getFluidInputs());
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs(false);
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs(true);
    }

    public int getProcessTime() {
        return Math.max(1, (int)Math.round(Math.ceil(this.baseProcessTime / this.getSpeedMultiplier())));
    }

    public int getProcessPower() {
        return Math.min(Integer.MAX_VALUE, (int)(this.baseProcessPower * this.getPowerMultiplier()));
    }

    public int getProcessEnergy() {
        return this.getProcessTime() * this.getProcessPower();
    }

    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessTime = this.defaultProcessTime;
            this.baseProcessPower = this.defaultProcessPower;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = this.recipeInfo.getRecipe().getBaseProcessTime(this.defaultProcessTime);
        this.baseProcessPower = this.recipeInfo.getRecipe().getBaseProcessPower(this.defaultProcessPower);
        this.baseProcessRadiation = this.recipeInfo.getRecipe().getBaseProcessRadiation();
        return true;
    }

    public void setCapacityFromSpeed() {
        this.getEnergyStorage().setStorageCapacity(IProcessor.getCapacity(this.recipeHandler, this.defaultProcessTime, this.getSpeedMultiplier(), this.defaultProcessPower, this.getPowerMultiplier()));
        this.getEnergyStorage().setMaxTransfer(IProcessor.getCapacity(this.recipeHandler, this.defaultProcessTime, this.getSpeedMultiplier(), this.defaultProcessPower, this.getPowerMultiplier()));
    }

    private int getMaxEnergyModified() {
        return ModCheck.galacticraftLoaded() ? this.getMaxEnergyStored() - 16 : this.getMaxEnergyStored();
    }

    public boolean isProcessing() {
        return this.readyToProcess() && !this.isHaltedByRedstone();
    }

    public boolean isHaltedByRedstone() {
        return this.getRedstoneControl() && this.getIsRedstonePowered();
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasSufficientEnergy();
    }

    public boolean canProcessInputs(boolean justProduced) {
        if (!this.setRecipeStats()) {
            return false;
        }
        if (!justProduced && this.time >= this.baseProcessTime) {
            return true;
        }
        return this.canProduceProducts();
    }

    public boolean hasSufficientEnergy() {
        return this.time <= 0.0 && (this.getProcessEnergy() >= this.getMaxEnergyModified() && this.getEnergyStored() >= this.getMaxEnergyModified() || this.getProcessEnergy() <= this.getEnergyStored()) || this.time > 0.0 && this.getEnergyStored() >= this.getProcessPower();
    }

    public boolean canProduceProducts() {
        int j;
        for (j = 0; j < this.itemOutputSize; ++j) {
            if (this.getItemOutputSetting(j + this.itemInputSize) == ItemOutputSetting.VOID) {
                this.getInventoryStacks().set(j + this.itemInputSize, (Object)ItemStack.field_190927_a);
                continue;
            }
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getMaxStackSize(0) <= 0) continue;
            if (itemProduct.getStack() == null || itemProduct.getStack() == ItemStack.field_190927_a) {
                return false;
            }
            if (((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_190926_b()) continue;
            if (!((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_77969_a((ItemStack)itemProduct.getStack())) {
                return false;
            }
            if (this.getItemOutputSetting(j + this.itemInputSize) != ItemOutputSetting.DEFAULT || ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_190916_E() + itemProduct.getMaxStackSize(0) <= ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_77976_d()) continue;
            return false;
        }
        for (j = 0; j < this.fluidOutputSize; ++j) {
            if (this.getTankOutputSetting(j + this.fluidInputSize) == TankOutputSetting.VOID) {
                this.clearTank(j + this.fluidInputSize);
                continue;
            }
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) continue;
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.getTankOutputSetting(j + this.fluidInputSize) != TankOutputSetting.DEFAULT || this.getTanks().get(j + this.fluidInputSize).getFluidAmount() + fluidProduct.getMaxStackSize(0) <= this.getTanks().get(j + this.fluidInputSize).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void process() {
        this.time += this.getSpeedMultiplier();
        this.getEnergyStorage().changeEnergyStored(-this.getProcessPower());
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.getSpeedMultiplier());
        if (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        if (!this.setRecipeStats()) {
            this.time = 0.0;
            for (int i = 0; i < this.fluidInputSize; ++i) {
                if (!this.getVoidUnusableFluidInput(i)) continue;
                this.getTanks().get(i).setFluid(null);
            }
        } else {
            this.time = MathHelper.func_151237_a((double)(this.time - oldProcessTime), (double)0.0, (double)this.baseProcessTime);
        }
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
    }

    public void produceProducts() {
        int j;
        int i;
        if (this.recipeInfo == null) {
            return;
        }
        List<Integer> itemInputOrder = this.recipeInfo.getItemInputOrder();
        List<Integer> fluidInputOrder = this.recipeInfo.getFluidInputOrder();
        if (itemInputOrder == AbstractRecipeHandler.INVALID || fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < this.itemInputSize; ++i) {
            int itemIngredientStackSize = this.getItemIngredients().get(itemInputOrder.get(i)).getMaxStackSize(this.recipeInfo.getItemIngredientNumbers().get(i));
            if (itemIngredientStackSize > 0) {
                ((ItemStack)this.getInventoryStacks().get(i)).func_190918_g(itemIngredientStackSize);
            }
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190916_E() > 0) continue;
            this.getInventoryStacks().set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < this.fluidInputSize; ++i) {
            int fluidIngredientStackSize = this.getFluidIngredients().get(fluidInputOrder.get(i)).getMaxStackSize(this.recipeInfo.getFluidIngredientNumbers().get(i));
            if (fluidIngredientStackSize > 0) {
                this.getTanks().get(i).changeFluidAmount(-fluidIngredientStackSize);
            }
            if (this.getTanks().get(i).getFluidAmount() > 0) continue;
            this.getTanks().get(i).setFluidStored(null);
        }
        for (j = 0; j < this.itemOutputSize; ++j) {
            if (this.getItemOutputSetting(j + this.itemInputSize) == ItemOutputSetting.VOID) {
                this.getInventoryStacks().set(j + this.itemInputSize, (Object)ItemStack.field_190927_a);
                continue;
            }
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getMaxStackSize(0) <= 0) continue;
            if (((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_190926_b()) {
                this.getInventoryStacks().set(j + this.itemInputSize, (Object)itemProduct.getNextStack(0));
                continue;
            }
            if (!((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_77969_a((ItemStack)itemProduct.getStack())) continue;
            int count = Math.min(this.getInventoryStackLimit(), ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_190916_E() + itemProduct.getNextStackSize(0));
            ((ItemStack)this.getInventoryStacks().get(j + this.itemInputSize)).func_190920_e(count);
        }
        for (j = 0; j < this.fluidOutputSize; ++j) {
            if (this.getTankOutputSetting(j + this.fluidInputSize) == TankOutputSetting.VOID) {
                this.clearTank(j + this.fluidInputSize);
                continue;
            }
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (this.getTanks().get(j + this.fluidInputSize).isEmpty()) {
                this.getTanks().get(j + this.fluidInputSize).setFluidStored(fluidProduct.getNextStack(0));
                continue;
            }
            if (!this.getTanks().get(j + this.fluidInputSize).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) continue;
            this.getTanks().get(j + this.fluidInputSize).changeFluidAmount(fluidProduct.getNextStackSize(0));
        }
    }

    public void loseProgress() {
        this.time = MathHelper.func_151237_a((double)(this.time - 1.5 * this.getSpeedMultiplier()), (double)0.0, (double)this.baseProcessTime);
    }

    @Override
    public List<ItemStack> getItemInputs() {
        return this.getInventoryStacks().subList(0, this.itemInputSize);
    }

    @Override
    public List<Tank> getFluidInputs() {
        return this.getTanks().subList(0, this.fluidInputSize);
    }

    @Override
    public List<IItemIngredient> getItemIngredients() {
        return this.recipeInfo.getRecipe().itemIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipeInfo.getRecipe().fluidIngredients();
    }

    @Override
    public List<IItemIngredient> getItemProducts() {
        return this.recipeInfo.getRecipe().itemProducts();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipeInfo.getRecipe().fluidProducts();
    }

    @Override
    public boolean hasUpgrades() {
        return this.hasUpgrades;
    }

    @Override
    public int getSpeedUpgradeSlot() {
        return this.itemInputSize + this.itemOutputSize;
    }

    @Override
    public int getEnergyUpgradeSlot() {
        return this.itemInputSize + this.itemOutputSize + 1;
    }

    @Override
    public int getSpeedCount() {
        return this.hasUpgrades ? ((ItemStack)this.getInventoryStacks().get(this.getSpeedUpgradeSlot())).func_190916_E() + 1 : 1;
    }

    @Override
    public int getEnergyCount() {
        return this.hasUpgrades ? Math.min(this.getSpeedCount(), ((ItemStack)this.getInventoryStacks().get(this.getEnergyUpgradeSlot())).func_190916_E() + 1) : 1;
    }

    @Override
    public void refreshUpgrades() {
        this.setCapacityFromSpeed();
    }

    @Override
    public int getEUSourceTier() {
        return 1;
    }

    @Override
    public int getEUSinkTier() {
        return 10;
    }

    @Override
    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = super.decrStackSize(slot, amount);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < this.itemInputSize) {
                this.refreshRecipe();
                this.refreshActivity();
            } else if (slot < this.itemInputSize + this.itemOutputSize) {
                this.refreshActivity();
            } else if (slot == this.getSpeedUpgradeSlot() || slot == this.getEnergyUpgradeSlot()) {
                this.refreshUpgrades();
            }
        }
        return stack;
    }

    @Override
    public void setInventorySlotContents(int slot, ItemStack stack) {
        super.setInventorySlotContents(slot, stack);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < this.itemInputSize) {
                this.refreshRecipe();
                this.refreshActivity();
            } else if (slot < this.itemInputSize + this.itemOutputSize) {
                this.refreshActivity();
            } else if (slot == this.getSpeedUpgradeSlot() || slot == this.getEnergyUpgradeSlot()) {
                this.refreshUpgrades();
            }
        }
    }

    public void func_70296_d() {
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshUpgrades();
        super.func_70296_d();
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return false;
        }
        if (this.hasUpgrades && stack.func_77973_b() == NCItems.upgrade) {
            if (slot == this.getSpeedUpgradeSlot()) {
                return stack.func_77960_j() == 0;
            }
            if (slot == this.getEnergyUpgradeSlot()) {
                return stack.func_77960_j() == 1;
            }
        }
        if (slot >= this.itemInputSize) {
            return false;
        }
        return NCConfig.smart_processor_input ? this.recipeHandler.isValidItemInput(stack, (ItemStack)this.getInventoryStacks().get(slot), this.inputItemStacksExcludingSlot(slot)) : this.recipeHandler.isValidItemInput(stack);
    }

    public List<ItemStack> inputItemStacksExcludingSlot(int slot) {
        ArrayList<ItemStack> inputItemsExcludingSlot = new ArrayList<ItemStack>(this.getItemInputs());
        inputItemsExcludingSlot.remove(slot);
        return inputItemsExcludingSlot;
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, EnumFacing side) {
        return super.canInsertItem(slot, stack, side) && this.isItemValidForSlot(slot, stack);
    }

    @Override
    public boolean hasConfigurableInventoryConnections() {
        return true;
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        if (nbt.func_74764_b("redstoneControl")) {
            this.setRedstoneControl(nbt.func_74767_n("redstoneControl"));
        } else {
            this.setRedstoneControl(true);
        }
    }

    @Override
    public int getGuiID() {
        return this.processorID;
    }

    @Override
    public Set<EntityPlayer> getPlayersToUpdate() {
        return this.playersToUpdate;
    }

    @Override
    public ProcessorUpdatePacket getGuiUpdatePacket() {
        return new ProcessorUpdatePacket(this.field_174879_c, this.time, this.getEnergyStored(), this.baseProcessTime, this.baseProcessPower, this.getTanks());
    }

    @Override
    public void onGuiPacket(ProcessorUpdatePacket message) {
        this.time = message.time;
        this.getEnergyStorage().setEnergyStored(message.energyStored);
        this.baseProcessTime = message.baseProcessTime;
        this.baseProcessPower = message.baseProcessPower;
        for (int i = 0; i < this.getTanks().size(); ++i) {
            this.getTanks().get(i).readInfo(message.tanksInfo.get(i));
        }
    }

    @Override
    public int getSideConfigYOffset() {
        return this.sideConfigYOffset;
    }
}

