/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.awt.Rectangle;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.widget.WidgetBase;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WidgetTank
extends WidgetBase {
    private final IFluidTank tank;

    public WidgetTank(int id, int x, int y, IFluidTank tank) {
        super(id, x, y, 16, 64);
        this.tank = tank;
    }

    public WidgetTank(int x, int y, FluidStack stack) {
        super(-1, x, y, 16, 64);
        this.tank = new FluidTank(stack, 16000);
    }

    public WidgetTank(int x, int y, int width, int height, FluidStack stack) {
        super(-1, x, y, width, height);
        this.tank = new FluidTank(stack, stack.amount);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        GlStateManager.func_179140_f();
        GuiUtils.drawFluid(new Rectangle(this.x, this.y, this.getBounds().width, this.getBounds().height), this.getFluid(), (IFluidTank)this.getTank());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
        for (int i = 3; i < this.getBounds().height - 1; i += 4) {
            int width = (i - 3) % 20 == 0 ? 16 : 2;
            Gui.func_73734_a((int)this.x, (int)(this.y + i), (int)(this.x + width), (int)(this.y + i + 1), (int)-13684945);
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shift) {
        Fluid fluid = null;
        int amt = 0;
        int capacity = 0;
        if (this.tank.getFluid() != null) {
            fluid = this.tank.getFluid().getFluid();
            amt = this.tank.getFluidAmount();
        }
        capacity = this.tank.getCapacity();
        if (fluid == null || amt == 0 || capacity == 0) {
            curTip.add(amt + "/" + capacity + " mb");
            curTip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.liquid.empty", (Object[])new Object[0]));
        } else {
            curTip.add(amt + "/" + capacity + " mb");
            curTip.add(TextFormatting.GRAY + fluid.getLocalizedName(new FluidStack(fluid, amt)));
        }
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    @SideOnly(value=Side.CLIENT)
    public FluidTank getTank() {
        return (FluidTank)this.tank;
    }
}

