/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public interface IProgWidget {
    public int getX();

    public int getY();

    public void setX(int var1);

    public void setY(int var1);

    public int getWidth();

    public int getHeight();

    public void render();

    public ResourceLocation getTexture();

    public Pair<Double, Double> getMaxUV();

    public int getTextureSize();

    public void getTooltip(List<String> var1);

    public void addWarnings(List<String> var1, List<IProgWidget> var2);

    public void addErrors(List<String> var1, List<IProgWidget> var2);

    public void renderExtraInfo();

    public boolean hasStepInput();

    public boolean hasStepOutput();

    public EntityAIBase getWidgetTargetAI(IDroneBase var1, IProgWidget var2);

    public EntityAIBase getWidgetAI(IDroneBase var1, IProgWidget var2);

    public void setOutputWidget(IProgWidget var1);

    public IProgWidget getOutputWidget();

    public IProgWidget getOutputWidget(IDroneBase var1, List<IProgWidget> var2);

    public Class<? extends IProgWidget> returnType();

    public Class<? extends IProgWidget>[] getParameters();

    public void setParameter(int var1, IProgWidget var2);

    public boolean canSetParameter(int var1);

    public IProgWidget[] getConnectedParameters();

    public void setParent(IProgWidget var1);

    public IProgWidget getParent();

    public String getWidgetString();

    public int getCraftingColorIndex();

    public void writeToNBT(NBTTagCompound var1);

    public void readFromNBT(NBTTagCompound var1);

    public IProgWidget copy();

    public boolean canBeRunByComputers(IDroneBase var1, IProgWidget var2);

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer var1);

    public WidgetDifficulty getDifficulty();

    public static enum WidgetDifficulty {
        EASY("easy"),
        MEDIUM("medium"),
        ADVANCED("advanced");

        private final String name;

        private WidgetDifficulty(String name) {
            this.name = name;
        }

        public String getLocalizedName() {
            return I18n.func_135052_a((String)("gui.progWidget.difficulty." + this.name), (Object[])new Object[0]);
        }
    }
}

