/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.mixinhelper.extended;

import cf.terminator.laggoggles.mixinhelper.MixinConfigPlugin;
import cf.terminator.laggoggles.mixinhelper.extended.Debugging;
import cf.terminator.laggoggles.mixinhelper.extended.MethodHelper;
import cf.terminator.laggoggles.mixinhelper.extended.Transformer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.AnnotationNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;

public class DynamicMethodReplacer
implements Transformer {
    private final ClassNode classNode;

    public DynamicMethodReplacer(ClassNode classNode) {
        this.classNode = classNode;
    }

    @Override
    public void transform() {
        LinkedList<MethodNode> changedMethods = new LinkedList<MethodNode>();
        for (MethodNode method : this.classNode.methods) {
            if (method.visibleAnnotations == null) continue;
            for (AnnotationNode annotation : method.visibleAnnotations) {
                if (!annotation.desc.equals("Lcf/terminator/laggoggles/mixinhelper/extended/DynamicMethodReplacer$RedirectMethodCalls;")) continue;
                String currentKey = null;
                String nameRegexDeobf = null;
                String nameRegexObf = null;
                boolean convertSelf = false;
                for (Object key_value : annotation.values) {
                    if (currentKey == null) {
                        currentKey = (String)key_value;
                        continue;
                    }
                    if (currentKey.equals("nameRegexDeobf")) {
                        nameRegexDeobf = (String)key_value;
                    } else if (currentKey.equals("nameRegexObf")) {
                        nameRegexObf = (String)key_value;
                    } else if (currentKey.equals("convertSelf")) {
                        convertSelf = (Boolean)key_value;
                    }
                    currentKey = null;
                }
                if (nameRegexDeobf == null || nameRegexObf == null) {
                    MixinConfigPlugin.LOGGER.fatal("Invalid annotation found. (@DynamicMethodFinder.RedirectMethodCalls)");
                    FMLCommonHandler.instance().exitJava(-1, true);
                    continue;
                }
                String nameRegex = MixinConfigPlugin.isProductionEnvironment() ? nameRegexObf : nameRegexDeobf;
                for (MethodNode changedMethod : this.findTargets(this.classNode, method, nameRegex, convertSelf, 1)) {
                    if (changedMethods.contains(changedMethod)) continue;
                    changedMethods.add(changedMethod);
                }
            }
        }
        for (MethodNode method : changedMethods) {
            MixinConfigPlugin.LOGGER.debug(Debugging.getMethodName(method));
            MixinConfigPlugin.LOGGER.debug(Debugging.getInstructions(method));
        }
    }

    private LinkedList<MethodNode> findTargets(final ClassNode classNode, final MethodNode instructor, String nameRegex, final boolean convertSelf, int expected) {
        String signatureToMatch = convertSelf ? "(" + Pattern.compile("\\([^;]+;").matcher(instructor.desc).replaceFirst("") : instructor.desc;
        LinkedList<MethodNode> changedMethods = MethodHelper.findMethodCalls(nameRegex, signatureToMatch, classNode, new MethodHelper.InsnMethodHandler(){

            @Override
            public void onFoundMethodNode(MethodNode method, MethodInsnNode node) {
                if (Objects.equals(instructor, method)) {
                    return;
                }
                String beforeChange = Debugging.getInstructionText(node);
                node.name = instructor.name;
                if (convertSelf) {
                    node.desc = node.desc.replaceFirst("\\(", "(L" + node.owner + ";");
                }
                node.owner = classNode.name;
                if (convertSelf) {
                    AbstractInsnNode currentNode = node;
                    while ((currentNode = currentNode.getPrevious()) instanceof VarInsnNode || currentNode instanceof FieldInsnNode) {
                    }
                    method.instructions.insert(currentNode, new VarInsnNode(25, 0));
                }
                MixinConfigPlugin.LOGGER.info("Redirected call in method " + Debugging.getMethodName(method) + "\n from " + beforeChange + "\n   to " + Debugging.getInstructionText(node));
            }
        });
        if (changedMethods.size() < expected) {
            MixinConfigPlugin.LOGGER.fatal(Debugging.printClassNodeMethods(classNode));
            throw new IllegalStateException(changedMethods.size() + " methods changed, expected at least " + expected);
        }
        return changedMethods;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface RedirectMethodCalls {
        public String nameRegexDeobf();

        public String nameRegexObf();

        public boolean convertSelf() default false;
    }
}

