/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.Chunk3D;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.PacketHandler;
import mekanism.common.Upgrade;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.chunkloading.IChunkLoader;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.IFrequencyHandler;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.network.PacketEntityMove;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTeleporter
extends TileEntityElectricBlock
implements IComputerIntegration,
IChunkLoader,
IFrequencyHandler,
IRedstoneControl,
ISecurityTile,
IUpgradeTile,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "canTeleport", "getMaxEnergy", "teleport", "setFrequency"};
    public AxisAlignedBB teleportBounds = null;
    public Set<UUID> didTeleport = new HashSet<UUID>();
    public int teleDelay = 0;
    public boolean shouldRender;
    public boolean prevShouldRender;
    public Frequency frequency;
    public List<Frequency> publicCache = new ArrayList<Frequency>();
    public List<Frequency> privateCache = new ArrayList<Frequency>();
    public byte status = 0;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentSecurity securityComponent;
    public TileComponentChunkLoader chunkLoaderComponent;
    public TileComponentUpgrade upgradeComponent;

    public TileEntityTeleporter() {
        super("Teleporter", BlockStateMachine.MachineType.TELEPORTER.getStorage());
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        this.securityComponent = new TileComponentSecurity(this);
        this.chunkLoaderComponent = new TileComponentChunkLoader(this);
        this.upgradeComponent = new TileComponentUpgrade(this, 1);
        this.upgradeComponent.clearSupportedTypes();
        this.upgradeComponent.setSupported(Upgrade.ANCHOR);
    }

    public static void teleportPlayerTo(EntityPlayerMP player, Coord4D coord, TileEntityTeleporter teleporter) {
        if (player.field_71093_bK != coord.dimensionId) {
            player.changeDimension(coord.dimensionId, (world, entity, yaw) -> entity.func_70634_a((double)coord.x + 0.5, (double)(coord.y + 1), (double)coord.z + 0.5));
        } else {
            player.func_70634_a((double)coord.x + 0.5, (double)(coord.y + 1), (double)coord.z + 0.5);
        }
        player.field_70170_p.func_72866_a((Entity)player, true);
    }

    public static void alignPlayer(EntityPlayerMP player, Coord4D coord) {
        Coord4D upperCoord = coord.offset(EnumFacing.UP);
        EnumFacing side = null;
        float yaw = player.field_70177_z;
        for (EnumFacing iterSide : MekanismUtils.SIDE_DIRS) {
            if (!upperCoord.offset(iterSide).isAirBlock((IBlockAccess)player.field_70170_p)) continue;
            side = iterSide;
            break;
        }
        if (side != null) {
            switch (side) {
                case NORTH: {
                    yaw = 180.0f;
                    break;
                }
                case SOUTH: {
                    yaw = 0.0f;
                    break;
                }
                case WEST: {
                    yaw = 90.0f;
                    break;
                }
                case EAST: {
                    yaw = 270.0f;
                    break;
                }
            }
        }
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, yaw, player.field_70125_A);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.teleportBounds == null) {
            this.resetBounds();
        }
        if (!this.field_145850_b.field_72995_K) {
            FrequencyManager manager = this.getManager(this.frequency);
            if (manager != null) {
                if (this.frequency != null && !this.frequency.valid) {
                    this.frequency = manager.validateFrequency(this.getSecurity().getOwnerUUID(), Coord4D.get(this), this.frequency);
                }
                if (this.frequency != null) {
                    this.frequency = manager.update(Coord4D.get(this), this.frequency);
                }
            } else {
                this.frequency = null;
            }
            this.status = this.canTeleport();
            if (MekanismUtils.canFunction(this) && this.status == 1 && this.teleDelay == 0) {
                this.teleport();
            }
            if (this.teleDelay == 0 && this.didTeleport.size() > 0) {
                this.cleanTeleportCache();
            }
            boolean bl = this.shouldRender = this.status == 1 || this.status > 4;
            if (this.shouldRender != this.prevShouldRender) {
                Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(this), Coord4D.get(this).getTargetPoint(40.0));
                MekanismUtils.notifyLoadedNeighborsOfTileChange(this.field_145850_b, Coord4D.get(this));
            }
            this.prevShouldRender = this.shouldRender;
            this.teleDelay = Math.max(0, this.teleDelay - 1);
        }
        ChargeUtils.discharge(0, this);
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies) {
            return this.getSecurity().getFrequency();
        }
        return this.frequency;
    }

    public Coord4D getClosest() {
        if (this.frequency != null) {
            return this.frequency.getClosestCoords(Coord4D.get(this));
        }
        return null;
    }

    public void setFrequency(String name, boolean publicFreq) {
        FrequencyManager manager = this.getManager(new Frequency(name, null).setPublic(publicFreq));
        manager.deactivate(Coord4D.get(this));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.name.equals(name)) continue;
            this.frequency = freq;
            this.frequency.activeCoords.add(Coord4D.get(this));
            return;
        }
        Frequency freq = new Frequency(name, this.getSecurity().getOwnerUUID()).setPublic(publicFreq);
        freq.activeCoords.add(Coord4D.get(this));
        manager.addFrequency(freq);
        this.frequency = freq;
        MekanismUtils.saveChunk(this);
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.getSecurity().getOwnerUUID() == null || freq == null) {
            return null;
        }
        if (freq.isPublic()) {
            return Mekanism.publicTeleporters;
        }
        if (!Mekanism.privateTeleporters.containsKey(this.getSecurity().getOwnerUUID())) {
            FrequencyManager manager = new FrequencyManager(Frequency.class, "Teleporter", this.getSecurity().getOwnerUUID());
            Mekanism.privateTeleporters.put(this.getSecurity().getOwnerUUID(), manager);
            manager.createOrLoad(this.field_145850_b);
        }
        return Mekanism.privateTeleporters.get(this.getSecurity().getOwnerUUID());
    }

    @Override
    public void onChunkUnload() {
        FrequencyManager manager;
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    @Override
    public void func_145843_s() {
        FrequencyManager manager;
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    public void cleanTeleportCache() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (Entity e : this.field_145850_b.func_72872_a(Entity.class, this.teleportBounds)) {
            list.add(e.getPersistentID());
        }
        HashSet<UUID> teleportCopy = new HashSet<UUID>(this.didTeleport);
        for (UUID id : teleportCopy) {
            if (list.contains(id)) continue;
            this.didTeleport.remove(id);
        }
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return new int[]{0};
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    public void resetBounds() {
        this.teleportBounds = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 3, 1));
    }

    public byte canTeleport() {
        if (!this.hasFrame()) {
            return 2;
        }
        if (this.getClosest() == null) {
            return 3;
        }
        List<Entity> entitiesInPortal = this.getToTeleport();
        Coord4D closestCoords = this.getClosest();
        int electricityNeeded = 0;
        for (Entity entity : entitiesInPortal) {
            electricityNeeded += this.calculateEnergyCost(entity, closestCoords);
        }
        if (this.getEnergy() < (double)electricityNeeded) {
            return 4;
        }
        return 1;
    }

    public void teleport() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List<Entity> entitiesInPortal = this.getToTeleport();
        Coord4D closestCoords = this.getClosest();
        if (closestCoords == null) {
            return;
        }
        for (Entity entity : entitiesInPortal) {
            WorldServer teleWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(closestCoords.dimensionId);
            TileEntityTeleporter teleporter = (TileEntityTeleporter)closestCoords.getTileEntity((IBlockAccess)teleWorld);
            if (teleporter == null) continue;
            teleporter.didTeleport.add(entity.getPersistentID());
            teleporter.teleDelay = 5;
            if (entity instanceof EntityPlayerMP) {
                TileEntityTeleporter.teleportPlayerTo((EntityPlayerMP)entity, closestCoords, teleporter);
                TileEntityTeleporter.alignPlayer((EntityPlayerMP)entity, closestCoords);
            } else {
                this.teleportEntityTo(entity, closestCoords, teleporter);
            }
            for (Coord4D coords : this.frequency.activeCoords) {
                Mekanism.packetHandler.sendToAllAround(new PacketPortalFX.PortalFXMessage(coords), coords.getTargetPoint(40.0));
            }
            this.setEnergy(this.getEnergy() - (double)this.calculateEnergyCost(entity, closestCoords));
            this.field_145850_b.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187534_aX, entity.func_184176_by(), 1.0f, 1.0f, false);
        }
    }

    public void teleportEntityTo(Entity entity, Coord4D coord, TileEntityTeleporter teleporter) {
        if (entity.field_70170_p.field_73011_w.getDimension() != coord.dimensionId) {
            entity.changeDimension(coord.dimensionId, (world, entity2, yaw) -> entity2.func_70634_a((double)coord.x + 0.5, (double)(coord.y + 1), (double)coord.z + 0.5));
        } else {
            entity.func_70634_a((double)coord.x + 0.5, (double)(coord.y + 1), (double)coord.z + 0.5);
            Mekanism.packetHandler.sendToAllTracking((IMessage)new PacketEntityMove.EntityMoveMessage(entity), new Coord4D(entity));
        }
    }

    public List<Entity> getToTeleport() {
        List entities = this.field_145850_b.func_72872_a(Entity.class, this.teleportBounds);
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (this.didTeleport.contains(entity.getPersistentID())) continue;
            ret.add(entity);
        }
        return ret;
    }

    public int calculateEnergyCost(Entity entity, Coord4D coords) {
        int energyCost = MekanismConfig.current().usage.teleporterBase.val();
        if (entity.field_70170_p.field_73011_w.getDimension() != coords.dimensionId) {
            energyCost += MekanismConfig.current().usage.teleporterDimensionPenalty.val();
        } else {
            int distance = (int)entity.func_70011_f((double)coords.x, (double)coords.y, (double)coords.z);
            energyCost += distance * MekanismConfig.current().usage.teleporterDistance.val();
        }
        return energyCost;
    }

    public boolean hasFrame() {
        if (this.isFrame(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()) && this.isFrame(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()) && this.isFrame(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o() + 1, this.func_174877_v().func_177952_p()) && this.isFrame(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o() + 1, this.func_174877_v().func_177952_p()) && this.isFrame(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o() + 2, this.func_174877_v().func_177952_p()) && this.isFrame(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o() + 2, this.func_174877_v().func_177952_p()) && this.isFrame(this.func_174877_v().func_177958_n() - 1, this.func_174877_v().func_177956_o() + 3, this.func_174877_v().func_177952_p()) && this.isFrame(this.func_174877_v().func_177958_n() + 1, this.func_174877_v().func_177956_o() + 3, this.func_174877_v().func_177952_p()) && this.isFrame(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o() + 3, this.func_174877_v().func_177952_p())) {
            return true;
        }
        return this.isFrame(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() - 1) && this.isFrame(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + 1) && this.isFrame(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o() + 1, this.func_174877_v().func_177952_p() - 1) && this.isFrame(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o() + 1, this.func_174877_v().func_177952_p() + 1) && this.isFrame(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o() + 2, this.func_174877_v().func_177952_p() - 1) && this.isFrame(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o() + 2, this.func_174877_v().func_177952_p() + 1) && this.isFrame(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o() + 3, this.func_174877_v().func_177952_p() - 1) && this.isFrame(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o() + 3, this.func_174877_v().func_177952_p() + 1) && this.isFrame(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o() + 3, this.func_174877_v().func_177952_p());
    }

    public boolean isFrame(int x, int y, int z) {
        IBlockState state = this.field_145850_b.func_180495_p(new BlockPos(x, y, z));
        return state.func_177230_c() == MekanismBlocks.BasicBlock && state.func_177230_c().func_176201_c(state) == 7;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("frequency")) {
            this.frequency = new Frequency(nbtTags.func_74775_l("frequency"));
            this.frequency.valid = false;
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.frequency != null) {
            NBTTagCompound frequencyTag = new NBTTagCompound();
            this.frequency.write(frequencyTag);
            nbtTags.func_74782_a("frequency", (NBTBase)frequencyTag);
        }
        return nbtTags;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            boolean isPublic;
            String freq;
            FrequencyManager manager;
            int type = dataStream.readInt();
            if (type == 0) {
                String name = PacketHandler.readString(dataStream);
                boolean isPublic2 = dataStream.readBoolean();
                this.setFrequency(name, isPublic2);
            } else if (type == 1 && (manager = this.getManager(new Frequency(freq = PacketHandler.readString(dataStream), null).setPublic(isPublic = dataStream.readBoolean()))) != null) {
                manager.remove(freq, this.getSecurity().getOwnerUUID());
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            int i;
            this.frequency = dataStream.readBoolean() ? new Frequency(dataStream) : null;
            this.status = dataStream.readByte();
            this.shouldRender = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.publicCache.clear();
            this.privateCache.clear();
            int amount = dataStream.readInt();
            for (i = 0; i < amount; ++i) {
                this.publicCache.add(new Frequency(dataStream));
            }
            amount = dataStream.readInt();
            for (i = 0; i < amount; ++i) {
                this.privateCache.add(new Frequency(dataStream));
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        if (this.frequency != null) {
            data.add(true);
            this.frequency.write(data);
        } else {
            data.add(false);
        }
        data.add(this.status);
        data.add(this.shouldRender);
        data.add(this.controlType.ordinal());
        data.add(Mekanism.publicTeleporters.getFrequencies().size());
        for (Frequency freq : Mekanism.publicTeleporters.getFrequencies()) {
            freq.write(data);
        }
        FrequencyManager manager = this.getManager(new Frequency(null, null).setPublic(false));
        if (manager != null) {
            data.add(manager.getFrequencies().size());
            for (Frequency freq : manager.getFrequencies()) {
                freq.write(data);
            }
        } else {
            data.add(0);
        }
        return data;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        return ChargeUtils.canBeOutputted(itemstack, false);
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.canTeleport()};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                this.teleport();
                return new Object[]{"Attempted to teleport."};
            }
            case 4: {
                if (!(arguments[0] instanceof String) || !(arguments[1] instanceof Boolean)) {
                    return new Object[]{"Invalid parameters."};
                }
                String freq = ((String)arguments[0]).trim();
                boolean isPublic = (Boolean)arguments[1];
                this.setFrequency(freq, isPublic);
                return new Object[]{"Frequency set."};
            }
        }
        throw new NoSuchMethodException();
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public TileComponentChunkLoader getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        HashSet<ChunkPos> ret = new HashSet<ChunkPos>();
        ret.add(new Chunk3D(Coord4D.get(this)).getPos());
        return ret;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public int getRedstoneLevel() {
        return this.shouldRender ? 15 : 0;
    }
}

