/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.api.energy.EnergyNet;
import ic2.core.block.wiring.tile.TileEntityBatteryStation;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IconButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2Formatters;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.math.IntCounter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BatteryStationComp
extends GuiComponent {
    public static final NumberComparator counter = new NumberComparator();
    TileEntityBatteryStation station;
    int lastEnergy;
    int lastPacket;

    public BatteryStationComp(TileEntityBatteryStation tile) {
        super(Ic2GuiComp.nullBox);
        this.station = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.GuiTick, GuiComponent.ActionRequest.GuiInit);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        gui.registerButton(new IconButton(0, x + 152, y + 3, 20, 20).setItemStack(Ic2Items.glassFiberCable.func_77946_l()).addText(this.station.getStationMode()));
        gui.registerButton(new IconButton(1, x + 130, y + 3, 20, 20).setItemStack(Ic2Items.battery.func_77946_l()).addText(this.station.getSendingMode()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        if (this.lastEnergy != this.station.stationMode) {
            this.lastEnergy = this.station.stationMode;
            gui.getCastedButton(0, IconButton.class).clearText().addText(this.station.getStationMode());
        }
        if (this.lastPacket != this.station.sendingMode) {
            this.lastPacket = this.station.sendingMode;
            gui.getCastedButton(1, IconButton.class).clearText().addText(this.station.getSendingMode());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        int reqTime;
        int change = this.station.averageIn - this.station.averageOut;
        if (change > 0) {
            reqTime = this.station.maxEnergy - this.station.storedEnergy;
            gui.drawString(Ic2GuiLang.energyIncrease.getLocalizedFormatted(this.getTime(reqTime /= change)), 8, 45, 0x404040);
        } else if (change < 0) {
            reqTime = -(this.station.storedEnergy / change);
            gui.drawString(Ic2GuiLang.energyDecrease.getLocalizedFormatted(this.getTime(reqTime)), 8, 45, 0x404040);
        } else {
            gui.drawString(Ic2GuiLang.energyNothing, 8, 45, 0x404040);
        }
        gui.drawString(Ic2GuiLang.energyStorageCharge, 8, 60, 0x404040);
        int eu = this.station.getStoredEU();
        int max = this.station.getMaxEU();
        if (eu > max) {
            eu = max;
        }
        gui.drawString("" + eu, 8, 70, 0x404040);
        gui.drawString("/" + max, 8, 80, 0x404040);
        gui.drawString(Ic2GuiLang.energyOutput, 80, 70, 0x404040);
        if (this.station.stationMode == 0) {
            gui.drawString(Ic2GuiLang.euATick.getLocalizedFormatted(0), 100, 70, 0x404040);
        } else if (this.station.sendingMode != 2) {
            gui.drawString(Ic2GuiLang.euATick.getLocalizedFormatted(EnergyNet.instance.getPowerFromTier(this.station.slots.getTier())), 100, 70, 0x404040);
        } else {
            Map<Integer, IntCounter> map = this.station.slots.getSlotInfo();
            if (map.isEmpty()) {
                gui.drawString(Ic2GuiLang.euATick.getLocalizedFormatted(0), 100, 70, 0x404040);
            } else if (map.size() == 1) {
                Map.Entry<Integer, IntCounter> entry = map.entrySet().iterator().next();
                gui.getFont().func_78279_b(Ic2GuiLang.packetCountPerTick.getLocalizedFormatted(entry.getValue().getValue(), entry.getKey()), 100, 70, 70, 0x404040);
            } else {
                ArrayList<Map.Entry<Integer, IntCounter>> keys = new ArrayList<Map.Entry<Integer, IntCounter>>(map.entrySet());
                Collections.sort(keys, counter);
                String text = "";
                for (Map.Entry entry : keys) {
                    text = text + " " + Ic2GuiLang.packetCountPerTick.getLocalizedFormatted(((IntCounter)entry.getValue()).getValue(), entry.getKey());
                }
                gui.getFont().func_78279_b(text, 99, 70, 70, 0x404040);
            }
        }
    }

    private String getTime(int ticks) {
        DecimalFormat form = Ic2Formatters.timeFormat;
        int delay = ticks / 20;
        int seconds = delay % 60;
        int minutes = delay / 60 % 60;
        int hours = delay / 3600 % 24;
        return "" + form.format(hours) + ":" + form.format(minutes) + ":" + form.format(seconds);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0 || id == 1) {
            this.station.getNetwork().initiateClientTileEntityEvent(this.station, id);
        }
    }

    public static class NumberComparator
    implements Comparator<Map.Entry<Integer, IntCounter>> {
        @Override
        public int compare(Map.Entry<Integer, IntCounter> o1, Map.Entry<Integer, IntCounter> o2) {
            int b;
            int a = o1.getKey();
            if (a < (b = o2.getKey().intValue())) {
                return -1;
            }
            if (b < a) {
                return 1;
            }
            return 0;
        }
    }
}

