/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block.plates;

import com.google.common.base.Predicate;
import lumien.randomthings.block.BlockBase;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.lib.INoItem;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BlockRedstonePlate
extends BlockBase
implements INoItem {
    protected static final AxisAlignedBB AABB = null;
    protected static final AxisAlignedBB VISUAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
    public static final PropertyDirection INPUT_FACING = PropertyDirection.func_177712_a((String)"inputfacing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection OUTPUT_FACING = PropertyDirection.func_177712_a((String)"outputfacing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    final boolean powered;

    public BlockRedstonePlate(boolean powered) {
        super("plate_redstone" + (powered ? "_powered" : ""), Material.field_151578_c);
        if (!powered) {
            ForgeRegistries.ITEMS.register(new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        }
        this.powered = powered;
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        this.checkForDrop(worldIn, pos, state);
        this.checkForRedstone(state, worldIn, pos);
    }

    private void checkForRedstone(IBlockState state, World worldIn, BlockPos pos) {
        boolean shouldBePowered;
        boolean currentlyPowered = this.powered;
        boolean bl = shouldBePowered = worldIn.func_175687_A(pos) > 0;
        if (currentlyPowered != shouldBePowered) {
            if (shouldBePowered) {
                worldIn.func_175656_a(pos, ModBlocks.redstonePlatePowered.func_176203_a(this.func_176201_c(state)));
            } else {
                worldIn.func_175656_a(pos, ModBlocks.redstonePlate.func_176203_a(this.func_176201_c(state)));
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.canPlaceOn(worldIn, pos.func_177977_b());
    }

    private boolean canPlaceOn(World worldIn, BlockPos pos) {
        return worldIn.isSideSolid(pos, EnumFacing.UP);
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceOn(worldIn, pos.func_177977_b())) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return VISUAL_AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing currentInput = (EnumFacing)state.func_177229_b((IProperty)INPUT_FACING);
        EnumFacing currentOutput = (EnumFacing)state.func_177229_b((IProperty)OUTPUT_FACING);
        return currentInput.ordinal() - 2 + (currentOutput.ordinal() - 2) * 4;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing output = EnumFacing.values()[meta / 4 + 2];
        EnumFacing input = EnumFacing.values()[meta - (output.ordinal() - 2) * 4 + 2];
        return this.func_176223_P().func_177226_a((IProperty)INPUT_FACING, (Comparable)input).func_177226_a((IProperty)OUTPUT_FACING, (Comparable)output);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INPUT_FACING, OUTPUT_FACING});
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        Vec3d motionVec = new Vec3d(entityIn.field_70159_w, entityIn.field_70181_x, entityIn.field_70179_y);
        EnumFacing roughMovingFacing = EnumFacing.func_176737_a((float)((float)motionVec.field_72450_a), (float)((float)motionVec.field_72448_b), (float)((float)motionVec.field_72449_c)).func_176734_d();
        Vec3d center = new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.0, 0.5);
        Vec3d difVec = center.func_178788_d(entityIn.func_174791_d());
        EnumFacing facing = EnumFacing.func_176737_a((float)((float)difVec.field_72450_a), (float)((float)difVec.field_72448_b), (float)((float)difVec.field_72449_c)).func_176734_d();
        EnumFacing currentInput = (EnumFacing)state.func_177229_b((IProperty)INPUT_FACING);
        EnumFacing currentOutput = this.powered ? currentInput.func_176734_d() : (EnumFacing)state.func_177229_b((IProperty)OUTPUT_FACING);
        EnumFacing outputFacing = null;
        if (facing == currentInput && roughMovingFacing == currentInput) {
            outputFacing = currentOutput;
        } else if (facing == currentOutput && roughMovingFacing == currentOutput) {
            outputFacing = currentInput;
        }
        if (outputFacing != null) {
            Vec3d facingVec = new Vec3d(outputFacing.func_176730_m()).func_186678_a(0.4).func_178787_e(center);
            float dif = facing.func_176734_d().func_185119_l() - outputFacing.func_185119_l();
            Vec3d outputMotionVec = motionVec.func_178785_b((float)Math.toRadians(dif));
            entityIn.func_70107_b(facingVec.field_72450_a, facingVec.field_72448_b, facingVec.field_72449_c);
            entityIn.field_70159_w = outputMotionVec.field_72450_a;
            entityIn.field_70181_x = outputMotionVec.field_72448_b;
            entityIn.field_70179_y = outputMotionVec.field_72449_c;
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side == EnumFacing.UP) {
            EnumFacing currentInput = (EnumFacing)state.func_177229_b((IProperty)INPUT_FACING);
            EnumFacing currentOutput = (EnumFacing)state.func_177229_b((IProperty)OUTPUT_FACING);
            EnumFacing newOutput = EnumFacing.func_176737_a((float)(hitX - 0.5f), (float)0.0f, (float)(hitZ - 0.5f));
            if (currentInput != newOutput && currentOutput != newOutput) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)OUTPUT_FACING, (Comparable)newOutput));
                }
                return true;
            }
        }
        return false;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.checkForDrop(worldIn, pos, state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)INPUT_FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)OUTPUT_FACING, (Comparable)placer.func_174811_aO());
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)INPUT_FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)INPUT_FACING, (Comparable)enumfacing).func_177226_a((IProperty)OUTPUT_FACING, (Comparable)enumfacing.func_176734_d()), 2);
        }
    }
}

