/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.gui.IGuiElement;
import forestry.api.gui.events.GuiEvent;
import forestry.api.gui.events.GuiEventDestination;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IGuiSizable;
import forestry.core.gui.elements.Window;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.input.Mouse;

public class GuiWindow
extends GuiScreen
implements IGuiSizable {
    protected final Window window;
    protected final int xSize;
    protected final int ySize;
    protected int guiLeft;
    protected int guiTop;

    public GuiWindow(int xSize, int ySize) {
        this.xSize = xSize;
        this.ySize = ySize;
        this.window = new Window<GuiWindow>(xSize, ySize, this);
        this.addElements();
    }

    protected void addElements() {
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        this.window.updateClient();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.window.setMousePosition(mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.window.draw(mouseX, mouseY);
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o().func_190926_b()) {
            GuiUtil.drawToolTips(this, this.field_146292_n, mouseX, mouseY);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
            this.window.drawTooltip(mouseX, mouseY);
            GlStateManager.func_179121_F();
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.window.init(this.guiLeft, this.guiTop);
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        this.window.setSize(width, height);
        super.func_146280_a(mc, width, height);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
        IGuiElement origin = this.window.getFocusedElement() == null ? this.window : this.window.getFocusedElement();
        this.window.postEvent(new GuiEvent.KeyEvent(origin, typedChar, keyCode), GuiEventDestination.ALL);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        IGuiElement origin = this.window.getMousedOverElement() == null ? this.window : this.window.getMousedOverElement();
        this.window.postEvent(new GuiEvent.DownEvent(origin, mouseX, mouseY, mouseButton), GuiEventDestination.ALL);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        IGuiElement origin = this.window.getMousedOverElement() == null ? this.window : this.window.getMousedOverElement();
        this.window.postEvent(new GuiEvent.UpEvent(origin, mouseX, mouseY, state), GuiEventDestination.ALL);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int dWheel = Mouse.getDWheel();
        if (dWheel != 0) {
            this.window.postEvent(new GuiEvent.WheelEvent((IGuiElement)this.window, dWheel), GuiEventDestination.ALL);
        }
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getSizeX() {
        return this.xSize;
    }

    @Override
    public int getSizeY() {
        return this.ySize;
    }

    @Override
    public Minecraft getMC() {
        return this.field_146297_k;
    }
}

