/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ItemStackList
extends NonNullList<ItemStack> {
    protected ItemStackList() {
        this(new ArrayList<ItemStack>());
    }

    protected ItemStackList(List<ItemStack> delegate) {
        super(delegate, (Object)ItemStack.field_190927_a);
    }

    public static ItemStackList create() {
        return new ItemStackList();
    }

    public static ItemStackList withSize(int size) {
        Object[] aobject = new ItemStack[size];
        Arrays.fill(aobject, ItemStack.field_190927_a);
        return new ItemStackList(Arrays.asList(aobject));
    }

    public static ItemStackList of(ItemStack ... element) {
        ItemStackList itemStackList = ItemStackList.create();
        itemStackList.addAll(Arrays.asList(element));
        return itemStackList;
    }

    public static ItemStackList of(Collection<ItemStack> boringList) {
        ItemStackList itemStackList = ItemStackList.create();
        itemStackList.addAll(boringList);
        return itemStackList;
    }

    public static ItemStackList of(IInventory inventory) {
        ItemStackList itemStackList = ItemStackList.withSize(inventory.func_70302_i_());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            itemStackList.add(inventory.func_70301_a(i));
        }
        return itemStackList;
    }

    public boolean hasItem(int index) {
        return index >= 0 && index < this.size() && !((ItemStack)this.get(index)).func_190926_b();
    }

    public void setEmpty(int index) {
        if (index >= 0 && index < this.size()) {
            this.set(index, ItemStack.field_190927_a);
        }
    }

    public ItemStackList copy(boolean fixed) {
        ItemStackList copy = fixed ? ItemStackList.withSize(this.size()) : ItemStackList.create();
        for (int i = 0; i < this.size(); ++i) {
            copy.set(i, this.get(i));
        }
        return copy;
    }

    public ItemStackList deepCopy(boolean fixed) {
        ItemStackList copy = fixed ? ItemStackList.withSize(this.size()) : ItemStackList.create();
        for (int i = 0; i < this.size(); ++i) {
            copy.set(i, ((ItemStack)this.get(i)).func_77946_l());
        }
        return copy;
    }
}

