/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.client.gui.GuiCelestialSelection;
import stevekung.mods.moreplanets.client.gui.GuiListCelestialSelectionEntry;

@SideOnly(value=Side.CLIENT)
public class GuiListCelestialSelection
extends GuiListExtended {
    private final GuiCelestialSelection selection;
    private final List<GuiListCelestialSelectionEntry> entries = new ArrayList<GuiListCelestialSelectionEntry>();
    public final List<CelestialBody> listCelestial;
    private int selectedId = -1;

    public GuiListCelestialSelection(GuiCelestialSelection gui, List<CelestialBody> listCelestial, int width, int height, int top, int bottom, int slotHeight) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, slotHeight);
        this.selection = gui;
        this.listCelestial = listCelestial;
        this.refreshList(GuiCelestialSelection.SortType.A_TO_Z);
    }

    public void refreshList(GuiCelestialSelection.SortType type) {
        this.entries.clear();
        Collections.sort(this.listCelestial, type);
        for (CelestialBody celestial : this.listCelestial) {
            this.entries.add(new GuiListCelestialSelectionEntry(this, celestial));
        }
    }

    public void refreshListSearch(String text) {
        this.entries.clear();
        ArrayList<CelestialBody> listCelestialTemp = new ArrayList<CelestialBody>();
        for (CelestialBody body : this.listCelestial) {
            if (!body.getName().toLowerCase().contains(text.toLowerCase())) continue;
            listCelestialTemp.add(body);
        }
        for (CelestialBody celestial : listCelestialTemp) {
            this.entries.add(new GuiListCelestialSelectionEntry(this, celestial));
        }
    }

    public GuiListCelestialSelectionEntry getListEntry(int index) {
        return this.entries.get(index);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    protected int func_148137_d() {
        return super.func_148137_d() - 165;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 150;
    }

    protected boolean func_148131_a(int slotIndex) {
        return slotIndex == this.selectedId;
    }

    protected void func_192638_a(int insideLeft, int insideTop, int mouseX, int mouseY, float partialTicks) {
        int i = this.func_148127_b();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (int j = 0; j < i; ++j) {
            int k = insideTop + j * this.field_148149_f + this.field_148160_j;
            int l = this.field_148149_f - 4;
            if (k > this.field_148154_c || k + l < this.field_148153_b) {
                this.func_192639_a(j, insideLeft, k, partialTicks);
            }
            if (this.field_148166_t && this.func_148131_a(j)) {
                int left = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2;
                int right = this.field_148152_e + this.field_148155_a / 2 - 230 + this.func_148139_c() / 2;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179090_x();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                bufferbuilder.func_181662_b((double)left, (double)(k + l + 2), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)right, (double)(k + l + 2), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)right, (double)(k - 2), 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)left, (double)(k - 2), 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(left + 1), (double)(k + l + 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(right - 1), (double)(k + l + 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(right - 1), (double)(k - 1), 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                bufferbuilder.func_181662_b((double)(left + 1), (double)(k - 1), 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            this.func_192637_a(j, insideLeft, k, l, mouseX, mouseY, partialTicks);
        }
    }

    @Nullable
    public GuiListCelestialSelectionEntry getSelectedCelestial() {
        return this.selectedId >= 0 && this.selectedId < this.func_148127_b() ? this.getListEntry(this.selectedId) : null;
    }

    public void selectCelestial(int idx) {
        this.selectedId = idx;
        this.selection.selectCelestial(this.getSelectedCelestial());
    }

    public GuiCelestialSelection getGui() {
        return this.selection;
    }

    public List<CelestialBody> getCelestialList() {
        return this.listCelestial;
    }
}

