/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import stevekung.mods.moreplanets.core.MorePlanetsMod;
import stevekung.mods.moreplanets.init.MPItems;
import stevekung.mods.moreplanets.network.PacketSimpleMP;
import stevekung.mods.moreplanets.planets.nibiru.entity.EntityVeinFloaterMinion;
import stevekung.mods.moreplanets.planets.nibiru.entity.projectile.EntityVeinBall;
import stevekung.mods.moreplanets.planets.nibiru.entity.weather.EntityNibiruLightningBolt;
import stevekung.mods.moreplanets.utils.BossType;
import stevekung.mods.moreplanets.utils.IMorePlanetsBoss;
import stevekung.mods.moreplanets.utils.entity.ISpaceMob;
import stevekung.mods.stevekunglib.utils.ColorUtils;
import stevekung.mods.stevekunglib.utils.JsonUtils;
import stevekung.mods.stevekunglib.utils.LangUtils;

public class EntityVeinFloater
extends EntityMob
implements IMorePlanetsBoss,
IEntityBreathable,
ISpaceMob,
IEntityMultiPart {
    private TileEntityDungeonSpawner<?> spawner;
    public int deathTicks = 0;
    private int entitiesWithin;
    private int entitiesWithinLast;
    private static final DataParameter<Boolean> VINE_PULL = EntityDataManager.func_187226_a(EntityVeinFloater.class, (DataSerializer)DataSerializers.field_187198_h);
    private MultiPartEntityPart[] partArray;
    private MultiPartEntityPart partHead;
    private MultiPartEntityPart partTentacle0;
    private MultiPartEntityPart partTentacle1;
    private MultiPartEntityPart partTentacle2;
    private MultiPartEntityPart partHoodN;
    private MultiPartEntityPart partHoodE;
    private MultiPartEntityPart partHoodW;
    private MultiPartEntityPart partHoodS;
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    private UUID bossInfoUUID = this.bossInfo.func_186737_d();
    private boolean playMusic;

    public EntityVeinFloater(World world) {
        super(world);
        this.field_70158_ak = true;
        this.partHead = new MultiPartEntityPart((IEntityMultiPart)this, "head", 7.0f, 5.0f);
        this.partHoodN = new MultiPartEntityPart((IEntityMultiPart)this, "hood_n", 6.0f, 2.0f);
        this.partHoodE = new MultiPartEntityPart((IEntityMultiPart)this, "hood_e", 6.0f, 2.0f);
        this.partHoodW = new MultiPartEntityPart((IEntityMultiPart)this, "hood_w", 6.0f, 2.0f);
        this.partHoodS = new MultiPartEntityPart((IEntityMultiPart)this, "hood_s", 6.0f, 2.0f);
        this.partTentacle2 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle_2", 7.0f, 5.0f);
        this.partTentacle1 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle_1", 7.0f, 5.0f);
        this.partTentacle0 = new MultiPartEntityPart((IEntityMultiPart)this, "tentacle_0", 7.0f, 5.0f);
        this.partArray = new MultiPartEntityPart[]{this.partHead, this.partHoodN, this.partHoodE, this.partHoodW, this.partHoodS, this.partTentacle2, this.partTentacle1, this.partTentacle0};
        this.field_70178_ae = true;
        this.func_70105_a(16.0f, 16.0f);
        if (world.field_72995_K) {
            MorePlanetsMod.PROXY.addBoss(this);
        }
    }

    public float func_70047_e() {
        return 16.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VINE_PULL, (Object)false);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (((Boolean)this.field_70180_af.func_187225_a(VINE_PULL)).booleanValue()) {
            nbt.func_74757_a("VinePull", true);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(VINE_PULL, (Object)nbt.func_74767_n("VinePull"));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70181_x *= 0.5;
        if (this.func_110143_aJ() <= 0.0f) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.S_UPDATE_NIBIRU_WEATHER, GCCoreUtil.getDimensionID((World)this.field_70170_p), false));
            this.field_70180_af.func_187227_b(VINE_PULL, (Object)false);
            return;
        }
        int tick = this.field_70173_aa;
        tick %= 600;
        if (this.func_110143_aJ() <= this.func_110138_aP() / 3.0f) {
            EntityPlayer player;
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.S_UPDATE_NIBIRU_WEATHER, GCCoreUtil.getDimensionID((World)this.field_70170_p), true));
            if (this.field_70146_Z.nextFloat() > 0.975f && !this.field_70128_L && (player = this.field_70170_p.func_184137_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0, false)) != null && !player.field_71075_bZ.field_75098_d && !player.field_70128_L) {
                EntityNibiruLightningBolt bolt = new EntityNibiruLightningBolt(this.field_70170_p);
                bolt.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)bolt);
            }
        } else if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
            if (!this.field_70128_L) {
                if (tick > 300) {
                    this.field_70180_af.func_187227_b(VINE_PULL, (Object)true);
                } else {
                    this.field_70180_af.func_187227_b(VINE_PULL, (Object)false);
                }
            }
        } else {
            List minionList;
            this.field_70180_af.func_187227_b(VINE_PULL, (Object)false);
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 200 == 0 && (minionList = this.field_70170_p.func_72872_a(EntityVeinFloaterMinion.class, new AxisAlignedBB(this.field_70165_t - 32.0, this.field_70163_u - 32.0, this.field_70161_v - 32.0, this.field_70165_t + 32.0, this.field_70163_u + 32.0, this.field_70161_v + 32.0))).size() <= 32) {
                EntityVeinFloaterMinion tentacle1 = new EntityVeinFloaterMinion(this.field_70170_p);
                tentacle1.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u + 12.0, this.field_70161_v + 2.0, 0.0f, 0.0f);
                tentacle1.func_110149_m(20.0f);
                this.field_70170_p.func_72838_d((Entity)tentacle1);
                EntityVeinFloaterMinion tentacle2 = new EntityVeinFloaterMinion(this.field_70170_p);
                tentacle2.func_70012_b(this.field_70165_t - 2.0, this.field_70163_u + 12.0, this.field_70161_v - 2.0, 0.0f, 0.0f);
                tentacle2.func_110149_m(20.0f);
                this.field_70170_p.func_72838_d((Entity)tentacle2);
                EntityVeinFloaterMinion tentacle3 = new EntityVeinFloaterMinion(this.field_70170_p);
                tentacle3.func_70012_b(this.field_70165_t + 2.0, this.field_70163_u + 12.0, this.field_70161_v - 2.0, 0.0f, 0.0f);
                tentacle3.func_110149_m(20.0f);
                this.field_70170_p.func_72838_d((Entity)tentacle3);
                EntityVeinFloaterMinion tentacle4 = new EntityVeinFloaterMinion(this.field_70170_p);
                tentacle4.func_70012_b(this.field_70165_t - 2.0, this.field_70163_u + 12.0, this.field_70161_v + 2.0, 0.0f, 0.0f);
                tentacle4.func_110149_m(20.0f);
                this.field_70170_p.func_72838_d((Entity)tentacle4);
            }
        }
        if (this.getVinePull()) {
            int range = 16;
            List entitiesAroundBH = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range));
            for (EntityPlayer entity : entitiesAroundBH) {
                if (entity.field_71075_bZ.field_75098_d) continue;
                double motionX = this.field_70165_t - entity.field_70165_t;
                double motionY = this.field_70163_u - entity.field_70163_u + 12.0;
                double motionZ = this.field_70161_v - entity.field_70161_v;
                entity.field_70159_w = motionX * (double)0.025f;
                entity.field_70181_x = motionY * (double)0.025f;
                entity.field_70179_y = motionZ * (double)0.025f;
                this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t - 1.0, this.field_70163_u - 1.0, this.field_70161_v - 1.0, this.field_70165_t + 5.0, this.field_70163_u + 12.5, this.field_70161_v + 5.0)).forEach(near -> near.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 8.0f));
            }
        }
        if (!this.playMusic && !this.field_70128_L && this.field_70173_aa > 20) {
            int range = 256;
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range));
            for (EntityPlayer player : players) {
                if (player == null || !(player instanceof EntityPlayerMP)) continue;
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_PLAY_VEIN_FLOATER_MUSIC, playerMP.field_71093_bK, new Object[0]), playerMP);
            }
            this.playMusic = true;
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (!(damageSource.func_76364_f() instanceof EntityVeinBall) && damageSource != DamageSource.field_180137_b) {
            if (this.func_180431_b(damageSource)) {
                return false;
            }
            if (super.func_70097_a(damageSource, damage)) {
                Entity entity = damageSource.func_76346_g();
                if (this.func_184188_bt().contains(entity) && this.func_184187_bx() != entity) {
                    if (entity != this) {
                        this.func_70604_c((EntityLivingBase)entity);
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void func_82167_n(Entity entity) {
    }

    public void func_174812_G() {
        this.func_70606_j(0.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect effect) {
    }

    public boolean func_70090_H() {
        return false;
    }

    public boolean func_70072_I() {
        return false;
    }

    public void func_70653_a(Entity entity, float strength, double xRatio, double zRatio) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0 * ConfigManagerCore.dungeonBossHealthMod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
    }

    protected void func_70619_bc() {
        if (this.field_70173_aa % 40 == 0) {
            this.func_70691_i(10.0f);
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70609_aI() {
        this.field_70170_p.func_175718_b(1010, this.func_180425_c(), 0);
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 5.5f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 28.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 5.5f;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks >= 180 && this.deathTicks % 5 == 0) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_EXPLODE, GCCoreUtil.getDimensionID((World)this.field_70170_p), new Object[0]), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID((World)this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int j;
                for (int i = 200; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            if (this.deathTicks == 40) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_DEATH, GCCoreUtil.getDimensionID((World)this.field_70170_p), new Object[]{Float.valueOf(this.func_70647_i() - 0.1f)}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID((World)this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
        }
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 200; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            this.func_70099_a(new ItemStack(MPItems.NIBIRU_DUNGEON_KEY_BLADE), 0.5f);
            this.func_70106_y();
            if (this.spawner != null) {
                this.spawner.isBossDefeated = true;
                this.spawner.boss = null;
                this.spawner.spawned = false;
            }
        }
    }

    public void func_70636_d() {
        if (this.spawner != null) {
            List playersWithin = this.field_70170_p.func_72872_a(EntityPlayer.class, this.spawner.getRangeBounds());
            this.entitiesWithin = playersWithin.size();
            if (this.entitiesWithin == 0 && this.entitiesWithinLast != 0) {
                this.field_70170_p.func_72872_a(EntityPlayer.class, this.spawner.getRangeBoundsPlus11()).forEach(player -> player.func_145747_a(JsonUtils.create((String)LangUtils.translate((String)"gui.skeleton_boss.message")).func_150255_a(JsonUtils.red())));
                this.func_70106_y();
                return;
            }
            this.entitiesWithinLast = this.entitiesWithin;
        }
        this.partTentacle0.func_70071_h_();
        this.partTentacle0.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
        this.partTentacle1.func_70071_h_();
        this.partTentacle1.func_70012_b(this.field_70165_t, this.field_70163_u + 5.0, this.field_70161_v, 0.0f, 0.0f);
        this.partTentacle2.func_70071_h_();
        this.partTentacle2.func_70012_b(this.field_70165_t, this.field_70163_u + 10.0, this.field_70161_v, 0.0f, 0.0f);
        this.partHead.func_70071_h_();
        this.partHead.func_70012_b(this.field_70165_t, this.field_70163_u + 13.0, this.field_70161_v, 0.0f, 0.0f);
        this.partHoodN.func_70071_h_();
        this.partHoodN.func_70012_b(this.field_70165_t, this.field_70163_u + 13.0, this.field_70161_v - 6.0, 0.0f, 0.0f);
        this.partHoodE.func_70071_h_();
        this.partHoodE.func_70012_b(this.field_70165_t + 6.0, this.field_70163_u + 13.0, this.field_70161_v, 0.0f, 0.0f);
        this.partHoodW.func_70071_h_();
        this.partHoodW.func_70012_b(this.field_70165_t - 6.0, this.field_70163_u + 13.0, this.field_70161_v, 0.0f, 0.0f);
        this.partHoodS.func_70071_h_();
        this.partHoodS.func_70012_b(this.field_70165_t, this.field_70163_u + 13.0, this.field_70161_v + 6.0, 0.0f, 0.0f);
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        super.func_70636_d();
    }

    public void func_70106_y() {
        if (this.spawner != null) {
            this.spawner.isBossDefeated = false;
            this.spawner.boss = null;
            this.spawner.spawned = false;
        }
        this.playMusic = false;
        int range = 256;
        List players = this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range));
        for (EntityPlayer player : players) {
            if (player == null || !(player instanceof EntityPlayerMP)) continue;
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimpleMP(PacketSimpleMP.EnumSimplePacketMP.C_STOP_VEIN_FLOATER_MUSIC, playerMP.field_71093_bK, new Object[0]), playerMP);
        }
        if (this.field_70170_p.field_72995_K) {
            MorePlanetsMod.PROXY.removeBoss(this);
        }
        super.func_70106_y();
    }

    public void onBossSpawned(TileEntityDungeonSpawner spawner) {
        this.spawner = spawner;
    }

    @Override
    public ISpaceMob.EnumMobType getMobType() {
        return ISpaceMob.EnumMobType.NIBIRU;
    }

    public boolean canBreath() {
        return true;
    }

    public void func_184178_b(EntityPlayerMP player) {
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        this.bossInfo.func_186761_b(player);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        return super.func_70097_a(source, damage);
    }

    public Entity[] func_70021_al() {
        return this.partArray;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public UUID getBossUUID() {
        return this.bossInfoUUID;
    }

    @Override
    public String getBossName() {
        return this.func_70005_c_();
    }

    @Override
    public BossType getBossType() {
        return BossType.NIBIRU;
    }

    @Override
    public int getBossTextColor() {
        return ColorUtils.rgbToDecimal((int)189, (int)95, (int)17);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeLong(this.bossInfoUUID.getMostSignificantBits());
        buffer.writeLong(this.bossInfoUUID.getLeastSignificantBits());
    }

    @SideOnly(value=Side.CLIENT)
    public void readSpawnData(ByteBuf buffer) {
        long msb = buffer.readLong();
        long lsb = buffer.readLong();
        this.bossInfoUUID = new UUID(msb, lsb);
    }

    public boolean getVinePull() {
        return (Boolean)this.field_70180_af.func_187225_a(VINE_PULL);
    }
}

