/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.world.gen.structure;

import java.util.Random;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import stevekung.mods.moreplanets.init.MPBlocks;
import stevekung.mods.moreplanets.init.MPLootTables;
import stevekung.mods.moreplanets.planets.nibiru.tileentity.TileEntityJuicerEgg;
import stevekung.mods.moreplanets.utils.tileentity.TileEntityChestMP;

public abstract class StructureNibiruPyramidPieces
extends StructureComponent {
    protected int scatteredFeatureSizeX;
    protected int scatteredFeatureSizeY;
    protected int scatteredFeatureSizeZ;
    protected int horizontalPos = -1;

    public StructureNibiruPyramidPieces() {
    }

    protected StructureNibiruPyramidPieces(Random rand, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        super(0);
        this.scatteredFeatureSizeX = sizeX;
        this.scatteredFeatureSizeY = sizeY;
        this.scatteredFeatureSizeZ = sizeZ;
        this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new StructureBoundingBox(x, y, z, x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1) : new StructureBoundingBox(x, y, z, x + sizeZ - 1, y + sizeY - 1, z + sizeX - 1);
    }

    protected boolean func_186167_a(World world, StructureBoundingBox box, Random randomIn, int x, int y, int z, ResourceLocation loot) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (box.func_175898_b((Vec3i)blockpos) && world.func_180495_p(blockpos).func_177230_c() != MPBlocks.INFECTED_CHEST) {
            IBlockState iblockstate = MPBlocks.INFECTED_CHEST.func_176223_P();
            world.func_180501_a(blockpos, MPBlocks.INFECTED_CHEST.correctFacing(world, blockpos, iblockstate), 2);
            TileEntity tileentity = world.func_175625_s(blockpos);
            if (tileentity instanceof TileEntityChestMP) {
                ((TileEntityChestMP)tileentity).func_189404_a(loot, randomIn.nextLong());
            }
            return true;
        }
        return false;
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        nbt.func_74768_a("Width", this.scatteredFeatureSizeX);
        nbt.func_74768_a("Height", this.scatteredFeatureSizeY);
        nbt.func_74768_a("Depth", this.scatteredFeatureSizeZ);
        nbt.func_74768_a("HPos", this.horizontalPos);
    }

    protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        this.scatteredFeatureSizeX = nbt.func_74762_e("Width");
        this.scatteredFeatureSizeY = nbt.func_74762_e("Height");
        this.scatteredFeatureSizeZ = nbt.func_74762_e("Depth");
        this.horizontalPos = nbt.func_74762_e("HPos");
    }

    protected boolean offsetToAverageGroundLevel(World world, StructureBoundingBox box, int yOffset) {
        if (this.horizontalPos >= 0) {
            return true;
        }
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k = this.field_74887_e.field_78896_c; k <= this.field_74887_e.field_78892_f; ++k) {
            for (int l = this.field_74887_e.field_78897_a; l <= this.field_74887_e.field_78893_d; ++l) {
                blockpos$mutableblockpos.func_181079_c(l, 64, k);
                if (!box.func_175898_b((Vec3i)blockpos$mutableblockpos)) continue;
                i += Math.max(world.func_175672_r((BlockPos)blockpos$mutableblockpos).func_177956_o(), world.field_73011_w.func_76557_i());
                ++j;
            }
        }
        if (j == 0) {
            return false;
        }
        this.horizontalPos = i / j;
        this.field_74887_e.func_78886_a(0, this.horizontalPos - this.field_74887_e.field_78895_b + yOffset, 0);
        return true;
    }

    public static class NibiruPyramid
    extends StructureNibiruPyramidPieces {
        private boolean[] hasPlacedChest = new boolean[4];

        public NibiruPyramid() {
        }

        public NibiruPyramid(Random rand, int x, int z) {
            super(rand, x, 64, z, 21, 15, 21);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasPlacedChest0", this.hasPlacedChest[0]);
            nbt.func_74757_a("hasPlacedChest1", this.hasPlacedChest[1]);
            nbt.func_74757_a("hasPlacedChest2", this.hasPlacedChest[2]);
            nbt.func_74757_a("hasPlacedChest3", this.hasPlacedChest[3]);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
            super.func_143011_b(nbt, manager);
            this.hasPlacedChest[0] = nbt.func_74767_n("hasPlacedChest0");
            this.hasPlacedChest[1] = nbt.func_74767_n("hasPlacedChest1");
            this.hasPlacedChest[2] = nbt.func_74767_n("hasPlacedChest2");
            this.hasPlacedChest[3] = nbt.func_74767_n("hasPlacedChest3");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.func_175804_a(world, box, 0, -4, 0, this.scatteredFeatureSizeX - 1, 0, this.scatteredFeatureSizeZ - 1, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            for (int i = 1; i <= 9; ++i) {
                this.func_175804_a(world, box, i, i, i, this.scatteredFeatureSizeX - 1 - i, i, this.scatteredFeatureSizeZ - 1 - i, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
                this.func_175804_a(world, box, i + 1, i, i + 1, this.scatteredFeatureSizeX - 2 - i, i, this.scatteredFeatureSizeZ - 2 - i, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            for (int i2 = 0; i2 < this.scatteredFeatureSizeX; ++i2) {
                for (int j = 0; j < this.scatteredFeatureSizeZ; ++j) {
                    this.func_175808_b(world, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), i2, -5, j, box);
                }
            }
            IBlockState orangeClay = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.ORANGE);
            IBlockState iblockstate1 = MPBlocks.INFECTED_SANDSTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
            IBlockState iblockstate2 = MPBlocks.INFECTED_SANDSTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
            IBlockState iblockstate3 = MPBlocks.INFECTED_SANDSTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
            IBlockState iblockstate = MPBlocks.INFECTED_SANDSTONE_STAIRS.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
            this.func_175804_a(world, box, 0, 0, 0, 4, 9, 4, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 1, 10, 1, 3, 10, 3, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175811_a(world, iblockstate1, 2, 10, 0, box);
            this.func_175811_a(world, iblockstate2, 2, 10, 4, box);
            this.func_175811_a(world, iblockstate3, 0, 10, 2, box);
            this.func_175811_a(world, iblockstate, 4, 10, 2, box);
            this.func_175804_a(world, box, this.scatteredFeatureSizeX - 5, 0, 0, this.scatteredFeatureSizeX - 1, 9, 4, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, this.scatteredFeatureSizeX - 4, 10, 1, this.scatteredFeatureSizeX - 2, 10, 3, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175811_a(world, iblockstate1, this.scatteredFeatureSizeX - 3, 10, 0, box);
            this.func_175811_a(world, iblockstate2, this.scatteredFeatureSizeX - 3, 10, 4, box);
            this.func_175811_a(world, iblockstate3, this.scatteredFeatureSizeX - 5, 10, 2, box);
            this.func_175811_a(world, iblockstate, this.scatteredFeatureSizeX - 1, 10, 2, box);
            this.func_175804_a(world, box, 8, 0, 0, 12, 4, 4, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 9, 1, 0, 11, 3, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 9, 1, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 9, 2, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 9, 3, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 10, 3, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 11, 3, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 11, 2, 1, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 11, 1, 1, box);
            this.func_175804_a(world, box, 4, 1, 1, 8, 3, 3, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 4, 1, 2, 8, 2, 2, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 12, 1, 1, 16, 3, 3, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 12, 1, 2, 16, 2, 2, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 5, 4, 5, this.scatteredFeatureSizeX - 6, 4, this.scatteredFeatureSizeZ - 6, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 9, 4, 9, 11, 4, 11, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 8, 1, 8, 8, 3, 8, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 12, 1, 8, 12, 3, 8, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 8, 1, 12, 8, 3, 12, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 12, 1, 12, 12, 3, 12, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 1, 1, 5, 4, 4, 11, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, this.scatteredFeatureSizeX - 5, 1, 5, this.scatteredFeatureSizeX - 2, 4, 11, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 6, 7, 9, 6, 7, 11, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, this.scatteredFeatureSizeX - 7, 7, 9, this.scatteredFeatureSizeX - 7, 7, 11, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 5, 5, 9, 5, 7, 11, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, this.scatteredFeatureSizeX - 6, 5, 9, this.scatteredFeatureSizeX - 6, 7, 11, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), false);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 5, 5, 10, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 5, 6, 10, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 6, 6, 10, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), this.scatteredFeatureSizeX - 6, 5, 10, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), this.scatteredFeatureSizeX - 6, 6, 10, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), this.scatteredFeatureSizeX - 7, 6, 10, box);
            this.func_175804_a(world, box, 2, 4, 4, 2, 6, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, this.scatteredFeatureSizeX - 3, 4, 4, this.scatteredFeatureSizeX - 3, 6, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(world, iblockstate1, 2, 4, 5, box);
            this.func_175811_a(world, iblockstate1, 2, 3, 4, box);
            this.func_175811_a(world, iblockstate1, this.scatteredFeatureSizeX - 3, 4, 5, box);
            this.func_175811_a(world, iblockstate1, this.scatteredFeatureSizeX - 3, 3, 4, box);
            this.func_175804_a(world, box, 1, 1, 3, 2, 2, 3, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, this.scatteredFeatureSizeX - 3, 1, 3, this.scatteredFeatureSizeX - 2, 2, 3, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175811_a(world, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), 1, 1, 2, box);
            this.func_175811_a(world, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), this.scatteredFeatureSizeX - 2, 1, 2, box);
            this.func_175811_a(world, MPBlocks.INFECTED_SANDSTONE_SLAB.func_176223_P(), 1, 2, 2, box);
            this.func_175811_a(world, MPBlocks.INFECTED_SANDSTONE_SLAB.func_176223_P(), this.scatteredFeatureSizeX - 2, 2, 2, box);
            this.func_175811_a(world, iblockstate, 2, 1, 2, box);
            this.func_175811_a(world, iblockstate3, this.scatteredFeatureSizeX - 3, 1, 2, box);
            this.func_175804_a(world, box, 4, 3, 5, 4, 3, 18, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, this.scatteredFeatureSizeX - 5, 3, 5, this.scatteredFeatureSizeX - 5, 3, 17, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 3, 1, 5, 4, 2, 16, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, this.scatteredFeatureSizeX - 6, 1, 5, this.scatteredFeatureSizeX - 5, 2, 16, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (int j1 = 5; j1 <= 17; j1 += 2) {
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 4, 1, j1, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), 4, 2, j1, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), this.scatteredFeatureSizeX - 5, 1, j1, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), this.scatteredFeatureSizeX - 5, 2, j1, box);
            }
            this.func_175811_a(world, orangeClay, 10, 0, 7, box);
            this.func_175811_a(world, orangeClay, 10, 0, 8, box);
            this.func_175811_a(world, orangeClay, 9, 0, 9, box);
            this.func_175811_a(world, orangeClay, 11, 0, 9, box);
            this.func_175811_a(world, orangeClay, 8, 0, 10, box);
            this.func_175811_a(world, orangeClay, 12, 0, 10, box);
            this.func_175811_a(world, orangeClay, 7, 0, 10, box);
            this.func_175811_a(world, orangeClay, 13, 0, 10, box);
            this.func_175811_a(world, orangeClay, 9, 0, 11, box);
            this.func_175811_a(world, orangeClay, 11, 0, 11, box);
            this.func_175811_a(world, orangeClay, 10, 0, 12, box);
            this.func_175811_a(world, orangeClay, 10, 0, 13, box);
            this.func_175811_a(world, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED), 10, 0, 10, box);
            for (int j2 = 0; j2 <= this.scatteredFeatureSizeX - 1; j2 += this.scatteredFeatureSizeX - 1) {
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), j2, 2, 1, box);
                this.func_175811_a(world, orangeClay, j2, 2, 2, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), j2, 2, 3, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), j2, 3, 1, box);
                this.func_175811_a(world, orangeClay, j2, 3, 2, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), j2, 3, 3, box);
                this.func_175811_a(world, orangeClay, j2, 4, 1, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), j2, 4, 2, box);
                this.func_175811_a(world, orangeClay, j2, 4, 3, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), j2, 5, 1, box);
                this.func_175811_a(world, orangeClay, j2, 5, 2, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), j2, 5, 3, box);
                this.func_175811_a(world, orangeClay, j2, 6, 1, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), j2, 6, 2, box);
                this.func_175811_a(world, orangeClay, j2, 6, 3, box);
                this.func_175811_a(world, orangeClay, j2, 7, 1, box);
                this.func_175811_a(world, orangeClay, j2, 7, 2, box);
                this.func_175811_a(world, orangeClay, j2, 7, 3, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), j2, 8, 1, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), j2, 8, 2, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), j2, 8, 3, box);
            }
            for (int k2 = 2; k2 <= this.scatteredFeatureSizeX - 3; k2 += this.scatteredFeatureSizeX - 3 - 2) {
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), k2 - 1, 2, 0, box);
                this.func_175811_a(world, orangeClay, k2, 2, 0, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), k2 + 1, 2, 0, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), k2 - 1, 3, 0, box);
                this.func_175811_a(world, orangeClay, k2, 3, 0, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), k2 + 1, 3, 0, box);
                this.func_175811_a(world, orangeClay, k2 - 1, 4, 0, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), k2, 4, 0, box);
                this.func_175811_a(world, orangeClay, k2 + 1, 4, 0, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), k2 - 1, 5, 0, box);
                this.func_175811_a(world, orangeClay, k2, 5, 0, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), k2 + 1, 5, 0, box);
                this.func_175811_a(world, orangeClay, k2 - 1, 6, 0, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), k2, 6, 0, box);
                this.func_175811_a(world, orangeClay, k2 + 1, 6, 0, box);
                this.func_175811_a(world, orangeClay, k2 - 1, 7, 0, box);
                this.func_175811_a(world, orangeClay, k2, 7, 0, box);
                this.func_175811_a(world, orangeClay, k2 + 1, 7, 0, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), k2 - 1, 8, 0, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), k2, 8, 0, box);
                this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), k2 + 1, 8, 0, box);
            }
            this.func_175804_a(world, box, 8, 4, 0, 12, 6, 0, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), false);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 8, 6, 0, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 12, 6, 0, box);
            this.func_175811_a(world, orangeClay, 9, 5, 0, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), 10, 5, 0, box);
            this.func_175811_a(world, orangeClay, 11, 5, 0, box);
            this.func_175804_a(world, box, 8, -14, 8, 12, -11, 12, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 8, -10, 8, 12, -10, 12, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 8, -9, 8, 12, -9, 12, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 8, -8, 8, 12, -1, 12, MPBlocks.INFECTED_SANDSTONE.func_176223_P(), MPBlocks.INFECTED_SANDSTONE.func_176223_P(), false);
            this.func_175804_a(world, box, 9, -11, 9, 11, -1, 11, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 9, -13, 9, 11, -13, 11, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            BlockPos blockpos = new BlockPos(this.func_74865_a(10, 10), this.func_74862_a(-11), this.func_74873_b(10, 10));
            if (box.func_175898_b((Vec3i)blockpos)) {
                world.func_180501_a(blockpos, MPBlocks.JUICER_EGG.func_176223_P(), 2);
                if (world.func_175625_s(blockpos) instanceof TileEntityJuicerEgg) {
                    ((TileEntityJuicerEgg)world.func_175625_s(blockpos)).setNeedPlayerNearby();
                }
            }
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 8, -11, 10, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 8, -10, 10, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), 7, -10, 10, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 7, -11, 10, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 12, -11, 10, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 12, -10, 10, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), 13, -10, 10, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 13, -11, 10, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 10, -11, 8, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 10, -10, 8, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), 10, -10, 7, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 10, -11, 7, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 10, -11, 12, box);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 10, -10, 12, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CHISELED_SANDSTONE.func_176223_P(), 10, -10, 13, box);
            this.func_175811_a(world, MPBlocks.INFECTED_CUT_SANDSTONE.func_176223_P(), 10, -11, 13, box);
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                if (this.hasPlacedChest[enumfacing.func_176736_b()]) continue;
                int k1 = enumfacing.func_82601_c() * 2;
                int l1 = enumfacing.func_82599_e() * 2;
                this.hasPlacedChest[enumfacing.func_176736_b()] = this.func_186167_a(world, box, rand, 10 + k1, -11, 10 + l1, MPLootTables.NIBIRU_DESERT_PYRAMID);
            }
            return true;
        }
    }
}

